/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_bitbucket_pipeline.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.BitbucketApi;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbBranch;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbOrg;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmRepository;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public abstract class BbRepo {
    @JsonProperty(value="slug")
    public abstract String getSlug();

    @JsonProperty(value="name")
    public abstract String getName();

    @JsonProperty(value="organization")
    public abstract BbOrg getOrg();

    @Deprecated
    @JsonIgnore
    public abstract boolean isGit();

    @JsonProperty(value="private")
    public abstract boolean isPrivate();

    public ScmRepository toScmRepository(@Nonnull BitbucketApi api, final @Nonnull Reachable parent) {
        final BbBranch defaultBranch = api.getDefaultBranch(this.getOrg().getKey(), this.getSlug());
        return new ScmRepository(){

            public String getName() {
                return BbRepo.this.getSlug();
            }

            public boolean isPrivate() {
                return BbRepo.this.isPrivate();
            }

            public String getDescription() {
                return this.getName();
            }

            public String getDefaultBranch() {
                if (defaultBranch != null) {
                    return defaultBranch.getDisplayId();
                }
                return null;
            }

            public Map<String, Boolean> getPermissions() {
                return Collections.emptyMap();
            }

            public Link getLink() {
                return parent.getLink().rel(BbRepo.this.getSlug());
            }
        };
    }
}

