/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_bitbucket_pipeline.server.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbOrg;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;

public class BbServerProject
extends BbOrg {
    private final String key;
    private final String name;
    private final boolean publicProject;
    private final String selfLink;

    @JsonCreator
    public BbServerProject(@JsonProperty(value="key") String key, @JsonProperty(value="name") String name, @JsonProperty(value="public") boolean publicProject, @JsonProperty(value="links") Map<String, List<Map<String, String>>> links) {
        this.key = key;
        this.name = name;
        this.publicProject = publicProject;
        List<Map<String, String>> hrefs = links.get("self");
        String link = null;
        for (Map<String, String> hrefLink : hrefs) {
            String href = hrefLink.get("href");
            if (href == null) continue;
            link = href;
            break;
        }
        this.selfLink = link;
    }

    @Override
    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="avatar")
    public String getAvatar() {
        try {
            return new URIBuilder(this.selfLink + "/avatar.png").addParameter("s", "50").build().toString();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    @JsonProperty(value="public")
    public boolean isPublicProject() {
        return this.publicProject;
    }
}

