/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_bitbucket_pipeline.server;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import hudson.Extension;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.BitbucketApi;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.BitbucketApiFactory;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.Messages;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbBranch;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbOrg;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbPage;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbRepo;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbSaveContentResponse;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbUser;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.server.model.BbServerBranch;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.server.model.BbServerPage;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.server.model.BbServerProject;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.server.model.BbServerRepo;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.server.model.BbServerSaveContentResponse;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.server.model.BbServerUser;
import io.jenkins.blueocean.commons.JsonConverter;
import io.jenkins.blueocean.commons.ServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.misc.NotNull;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class BitbucketServerApi
extends BitbucketApi {
    public static final DefaultArtifactVersion MINIMUM_SUPPORTED_VERSION = new DefaultArtifactVersion("5.2.0");
    private final String baseUrl;

    BitbucketServerApi(@Nonnull String hostUrl, @Nonnull StandardUsernamePasswordCredentials credentials) {
        super(hostUrl, credentials);
        this.baseUrl = this.apiUrl + "rest/api/1.0/";
    }

    @Nonnull
    public static String getVersion(@Nonnull String apiUrl) {
        try {
            apiUrl = BitbucketServerApi.ensureTrailingSlash(apiUrl);
            InputStream inputStream = Request.Get((String)(apiUrl + "rest/api/1.0/application-properties")).execute().returnContent().asStream();
            Map resp = (Map)JsonConverter.om.readValue(inputStream, (TypeReference)new TypeReference<Map<String, String>>(){});
            String version = (String)resp.get("version");
            if (StringUtils.isBlank((String)version)) {
                throw new ServiceException.PreconditionRequired("Unsupported Bitbucket server, no version information could be determined");
            }
            return version;
        }
        catch (IOException e) {
            if (e instanceof HttpResponseException) {
                throw new ServiceException(((HttpResponseException)e).getStatusCode(), e.getMessage(), (Throwable)e);
            }
            throw new ServiceException.UnexpectedErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @Nonnull
    public BbUser getUser(@Nonnull String userName) {
        try {
            InputStream inputStream = Request.Get((String)String.format("%s/%s", this.baseUrl + "users", userName)).addHeader("Authorization", this.basicAuthHeaderValue).execute().returnContent().asStream();
            return (BbUser)JsonConverter.om.readValue(inputStream, BbServerUser.class);
        }
        catch (IOException e) {
            throw this.handleException(e);
        }
    }

    @Override
    @Nonnull
    public BbPage<BbOrg> getOrgs(int pageNumber, int pageSize) {
        try {
            InputStream inputStream = Request.Get((String)String.format("%s?start=%s&limit=%s", this.baseUrl + "projects/", this.toStart(pageNumber, pageSize), pageSize)).addHeader("Authorization", this.basicAuthHeaderValue).execute().returnContent().asStream();
            return (BbPage)JsonConverter.om.readValue(inputStream, (TypeReference)new TypeReference<BbServerPage<BbServerProject>>(){});
        }
        catch (IOException e) {
            throw this.handleException(e);
        }
    }

    @Override
    @Nonnull
    public BbOrg getOrg(@Nonnull String projectName) {
        try {
            InputStream inputStream = Request.Get((String)String.format("%s/%s", this.baseUrl + "projects", projectName)).addHeader("Authorization", this.basicAuthHeaderValue).execute().returnContent().asStream();
            return (BbOrg)JsonConverter.om.readValue(inputStream, BbServerProject.class);
        }
        catch (IOException e) {
            throw this.handleException(e);
        }
    }

    @Override
    @Nonnull
    public BbPage<BbRepo> getRepos(@Nonnull String projectKey, int pageNumber, int pageSize) {
        try {
            InputStream inputStream = Request.Get((String)String.format("%s?start=%s&limit=%s", this.baseUrl + "projects/" + projectKey + "/repos/", this.toStart(pageNumber, pageSize), pageSize)).addHeader("Authorization", this.basicAuthHeaderValue).execute().returnContent().asStream();
            return (BbPage)JsonConverter.om.readValue(inputStream, (TypeReference)new TypeReference<BbServerPage<BbServerRepo>>(){});
        }
        catch (IOException e) {
            throw this.handleException(e);
        }
    }

    @Override
    @Nonnull
    public BbRepo getRepo(@Nonnull String orgId, @Nonnull String repoSlug) {
        try {
            InputStream inputStream = Request.Get((String)String.format("%s/%s/repos/%s/", this.baseUrl + "projects", orgId, repoSlug)).addHeader("Authorization", this.basicAuthHeaderValue).execute().returnContent().asStream();
            return (BbRepo)JsonConverter.om.readValue(inputStream, BbServerRepo.class);
        }
        catch (IOException e) {
            throw this.handleException(e);
        }
    }

    @Override
    @Nonnull
    public String getContent(@Nonnull String orgId, @Nonnull String repoSlug, @Nonnull String path, @Nonnull String commitId) {
        ArrayList<String> content = new ArrayList<String>();
        this.getAndBuildContent(orgId, repoSlug, path, commitId, 0, 500, content);
        return Joiner.on((char)'\n').join(content);
    }

    @Override
    @Nonnull
    public BbSaveContentResponse saveContent(@Nonnull String projectKey, @Nonnull String repoSlug, @Nonnull String path, @Nonnull String content, @Nonnull String commitMessage, @Nullable String branch, @Nullable String sourceBranch, @Nullable String commitId) {
        try {
            String version = BitbucketServerApi.getVersion(this.apiUrl);
            if (!BitbucketServerApi.isSupportedVersion(version)) {
                throw new ServiceException.PreconditionRequired(Messages.bbserver_version_validation_error(version, MINIMUM_SUPPORTED_VERSION));
            }
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().addTextBody("content", content).addTextBody("message", commitMessage);
            if (StringUtils.isNotBlank((String)branch)) {
                builder.addTextBody("branch", branch);
            }
            if (StringUtils.isNotBlank((String)sourceBranch)) {
                builder.addTextBody("sourceBranch", sourceBranch);
            }
            if (StringUtils.isNotBlank((String)commitId)) {
                builder.addTextBody("sourceCommitId", commitId);
            }
            HttpEntity entity = builder.build();
            InputStream inputStream = Request.Put((String)String.format("%s/%s/repos/%s/browse/%s", this.baseUrl + "projects", projectKey, repoSlug, path)).addHeader("Authorization", this.basicAuthHeaderValue).body(entity).execute().returnContent().asStream();
            return (BbSaveContentResponse)JsonConverter.om.readValue(inputStream, BbServerSaveContentResponse.class);
        }
        catch (IOException e) {
            if (commitId != null && e instanceof HttpResponse && ((HttpResponse)e).getStatusLine().getStatusCode() == 409) {
                return new BbServerSaveContentResponse(commitId);
            }
            throw this.handleException(e);
        }
    }

    @Override
    public boolean fileExists(@Nonnull String projectKey, @Nonnull String repoSlug, @Nonnull String path, @Nonnull String branch) {
        try {
            Response response;
            URIBuilder uriBuilder = new URIBuilder(String.format("%s/%s/repos/%s/browse/%s", this.baseUrl + "projects", projectKey, repoSlug, path));
            if (branch != null) {
                uriBuilder.addParameter("at", "refs/heads/" + branch);
            }
            return (response = Request.Head((URI)uriBuilder.build()).addHeader("Authorization", this.basicAuthHeaderValue).execute()).returnResponse().getStatusLine().getStatusCode() == 200;
        }
        catch (IOException | URISyntaxException e) {
            throw this.handleException(e);
        }
    }

    @Override
    @CheckForNull
    public BbBranch getBranch(@Nonnull String orgId, @Nonnull String repoSlug, @Nonnull String branch) {
        try {
            URIBuilder uriBuilder = new URIBuilder(String.format("%s/%s/repos/%s/branches/", this.baseUrl + "projects", orgId, repoSlug));
            uriBuilder.addParameter("filterText", branch);
            BbServerPage branches = (BbServerPage)JsonConverter.om.readValue(Request.Get((URI)uriBuilder.build()).addHeader("Authorization", this.basicAuthHeaderValue).execute().returnContent().asStream(), (TypeReference)new TypeReference<BbServerPage<BbServerBranch>>(){});
            String expectedId = "refs/heads/" + branch;
            for (BbServerBranch b : branches.getValues()) {
                if (!b.getId().equals(expectedId)) continue;
                return b;
            }
            return null;
        }
        catch (IOException | URISyntaxException e) {
            throw this.handleException(e);
        }
    }

    @Override
    @Nonnull
    public BbBranch createBranch(@Nonnull String orgId, @Nonnull String repoSlug, Map<String, String> payload) {
        try {
            return (BbBranch)JsonConverter.om.readValue(Request.Post((String)String.format("%s/%s/repos/%s/branches/", this.baseUrl + "projects", orgId, repoSlug)).addHeader("Authorization", this.basicAuthHeaderValue).bodyString(JsonConverter.om.writeValueAsString(payload), ContentType.APPLICATION_JSON).execute().returnContent().asStream(), BbServerBranch.class);
        }
        catch (IOException e) {
            throw this.handleException(e);
        }
    }

    @Override
    @CheckForNull
    public BbBranch getDefaultBranch(@Nonnull String orgId, @Nonnull String repoSlug) {
        try {
            InputStream inputStream = Request.Get((String)String.format("%s/%s/repos/%s/branches/default", this.baseUrl + "projects", orgId, repoSlug)).addHeader("Authorization", this.basicAuthHeaderValue).execute().returnContent().asStream();
            return (BbBranch)JsonConverter.om.readValue(inputStream, (TypeReference)new TypeReference<BbServerBranch>(){});
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw this.handleException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw this.handleException(e);
        }
    }

    @Override
    public boolean isEmptyRepo(@NotNull String orgId, @Nonnull String repoSlug) {
        try {
            URIBuilder uriBuilder = new URIBuilder(String.format("%s/%s/repos/%s/branches/default", this.baseUrl + "projects", orgId, repoSlug));
            Response response = Request.Head((URI)uriBuilder.build()).addHeader("Authorization", this.basicAuthHeaderValue).execute();
            return response.returnResponse().getStatusLine().getStatusCode() == 404;
        }
        catch (IOException | URISyntaxException e) {
            throw this.handleException(e);
        }
    }

    private void getAndBuildContent(@Nonnull String projectKey, @Nonnull String repoSlug, @Nonnull String path, @Nonnull String commitId, int start, int limit, @Nonnull List<String> lines) {
        try {
            InputStream inputStream = Request.Get((String)String.format("%s/%s/repos/%s/browse/%s?at=%s&start=%s&limit=%s", this.baseUrl + "projects", projectKey, repoSlug, path, commitId, start, limit)).addHeader("Authorization", this.basicAuthHeaderValue).execute().returnContent().asStream();
            Map content = (Map)JsonConverter.om.readValue(inputStream, (TypeReference)new TypeReference<Map<String, Object>>(){});
            List lineMap = (List)content.get("lines");
            this.collectLines(lineMap, lines);
            int size = (Integer)content.get("size");
            if (!((Boolean)content.get("isLastPage")).booleanValue()) {
                this.getAndBuildContent(projectKey, repoSlug, path, commitId, start + size, limit, lines);
            }
        }
        catch (IOException e) {
            throw this.handleException(e);
        }
    }

    private void collectLines(List<Map<String, String>> lineMap, List<String> lines) {
        lines.addAll(Lists.transform(lineMap, (Function)new Function<Map<String, String>, String>(){

            @Nullable
            public String apply(@Nullable Map<String, String> input) {
                String text;
                if (input != null && (text = input.get("text")) != null) {
                    return text;
                }
                return null;
            }
        }));
    }

    private void assertDefaultBranch(BbBranch defaultBranch, String projectKey, String repo) {
        if (defaultBranch == null) {
            throw new ServiceException.BadRequestException(String.format("No default branch on project %s, repo %s. Please resubmit request with content.branch", projectKey, repo));
        }
    }

    private int toStart(int pageNumber, int pageSize) {
        int start = pageSize * (pageNumber - 1);
        if (start < 0) {
            start = 0;
        }
        return start;
    }

    public static boolean isSupportedVersion(@Nonnull String version) {
        return new DefaultArtifactVersion(version).compareTo((ArtifactVersion)MINIMUM_SUPPORTED_VERSION) >= 0;
    }

    @Extension
    public static class BitbucketServerApiFactory
    extends BitbucketApiFactory {
        @Override
        public boolean handles(@Nonnull String apiUrl) {
            StaplerRequest request = Stapler.getCurrentRequest();
            Preconditions.checkNotNull((Object)request);
            String mode = request.getHeader("X_BB_API_TEST_MODE_HEADER");
            boolean isCloudMode = StringUtils.isNotBlank((String)mode) && mode.equals("cloud");
            return !isCloudMode && !apiUrl.startsWith("https://bitbucket.org") && !apiUrl.startsWith("https://api.bitbucket.org");
        }

        @Override
        @Nonnull
        public BitbucketApi create(@Nonnull String apiUrl, @Nonnull StandardUsernamePasswordCredentials credentials) {
            return new BitbucketServerApi(apiUrl, credentials);
        }
    }
}

