/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_bitbucket_pipeline;

import io.jenkins.blueocean.blueocean_bitbucket_pipeline.BitbucketApi;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbOrg;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbPage;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbRepo;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmRepositories;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmRepository;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmRepositoryContainer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

public class BitbucketRepositoryContainer
extends ScmRepositoryContainer {
    private final Link self;
    private final BitbucketApi api;
    private final BbOrg project;

    public BitbucketRepositoryContainer(BbOrg project, BitbucketApi api, Reachable parent) {
        this.self = parent.getLink().rel("repositories");
        this.api = api;
        this.project = project;
    }

    public Link getLink() {
        return this.self;
    }

    public ScmRepositories getRepositories() {
        return new BitbucketRepositories();
    }

    public ScmRepository get(String name) {
        if (name == null) {
            throw new ServiceException.BadRequestException("Repo slug is required parameter");
        }
        return this.api.getRepo(this.project.getKey(), name).toScmRepository(this.api, (Reachable)this);
    }

    public class BitbucketRepositories
    extends ScmRepositories {
        private final Link self;
        private final boolean isLastPage;
        private final Integer nextPage;
        private final Integer pageSize;
        private final List<ScmRepository> repositories = new ArrayList<ScmRepository>();

        public BitbucketRepositories() {
            this.self = BitbucketRepositoryContainer.this.getLink().rel("repositories");
            StaplerRequest request = Stapler.getCurrentRequest();
            int pageNumber = 0;
            if (!StringUtils.isBlank((String)request.getParameter("pageNumber"))) {
                pageNumber = Integer.parseInt(request.getParameter("pageNumber"));
            }
            if (pageNumber <= 0) {
                pageNumber = 1;
            }
            int pageSize = 0;
            if (request.getParameter("pageSize") != null) {
                pageSize = Integer.parseInt(request.getParameter("pageSize"));
            }
            if (pageSize <= 0) {
                pageSize = 100;
            }
            BbPage<BbRepo> repos = BitbucketRepositoryContainer.this.api.getRepos(BitbucketRepositoryContainer.this.project.getKey(), pageNumber, pageSize);
            for (BbRepo repo : repos.getValues()) {
                this.repositories.add(repo.toScmRepository(BitbucketRepositoryContainer.this.api, (Reachable)this));
            }
            this.isLastPage = repos.isLastPage();
            this.pageSize = repos.getLimit();
            this.nextPage = !repos.isLastPage() ? Integer.valueOf(pageNumber + 1) : null;
        }

        public Link getLink() {
            return this.self;
        }

        @Exported(name="isLastPage")
        public boolean isLastPage() {
            return this.isLastPage;
        }

        @Exported(name="nextPage")
        public Integer getNextPage() {
            return this.nextPage;
        }

        @Exported(name="pageSize")
        public Integer getPageSize() {
            return this.pageSize;
        }

        public Iterable<ScmRepository> getItems() {
            return this.repositories;
        }
    }
}

