/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_bitbucket_pipeline;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.util.Secret;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbBranch;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbOrg;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbPage;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbRepo;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbSaveContentResponse;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbUser;
import io.jenkins.blueocean.commons.ServiceException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.misc.NotNull;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.client.HttpResponseException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public abstract class BitbucketApi {
    protected final String apiUrl;
    protected final StandardUsernamePasswordCredentials credentials;
    protected final String userName;
    protected final String basicAuthHeaderValue;
    public static final String X_BB_API_TEST_MODE_HEADER = "X_BB_API_TEST_MODE_HEADER";

    protected BitbucketApi(@Nonnull String apiUrl, @Nonnull StandardUsernamePasswordCredentials credentials) {
        this.apiUrl = BitbucketApi.ensureTrailingSlash(apiUrl);
        this.credentials = credentials;
        try {
            this.basicAuthHeaderValue = String.format("Basic %s", Base64.encodeBase64String((byte[])String.format("%s:%s", credentials.getUsername(), Secret.toString((Secret)credentials.getPassword())).getBytes("UTF-8")));
            this.userName = credentials.getUsername();
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceException.UnexpectedErrorException("Failed to create basic auth header: " + e.getMessage(), (Throwable)e);
        }
    }

    @Nonnull
    public BbUser getUser() {
        return this.getUser(this.userName);
    }

    @Nonnull
    public abstract BbUser getUser(@Nonnull String var1);

    @Nonnull
    public abstract BbPage<BbOrg> getOrgs(int var1, int var2);

    @Nonnull
    public abstract BbOrg getOrg(@Nonnull String var1);

    @Nonnull
    public abstract BbRepo getRepo(@Nonnull String var1, String var2);

    @Nonnull
    public abstract BbPage<BbRepo> getRepos(@Nonnull String var1, int var2, int var3);

    @Nonnull
    public abstract String getContent(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3, @Nonnull String var4);

    @Nonnull
    public abstract BbSaveContentResponse saveContent(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3, @Nonnull String var4, @Nonnull String var5, @Nullable String var6, @Nullable String var7, @Nullable String var8);

    public abstract boolean fileExists(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3, @Nonnull String var4);

    @CheckForNull
    public abstract BbBranch getBranch(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3);

    @Nonnull
    public abstract BbBranch createBranch(@Nonnull String var1, @Nonnull String var2, Map<String, String> var3);

    @CheckForNull
    public abstract BbBranch getDefaultBranch(@Nonnull String var1, @Nonnull String var2);

    public abstract boolean isEmptyRepo(@NotNull String var1, @Nonnull String var2);

    protected ServiceException handleException(Exception e) {
        if (e instanceof HttpResponseException) {
            return new ServiceException(((HttpResponseException)((Object)e)).getStatusCode(), e.getMessage(), (Throwable)e);
        }
        return new ServiceException.UnexpectedErrorException(e.getMessage(), (Throwable)e);
    }

    protected static String ensureTrailingSlash(String url) {
        if (url.charAt(url.length() - 1) != '/') {
            return url + "/";
        }
        return url;
    }
}

