/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.pipeline.arquillian.cube.kubernetes;

import hudson.model.Run;
import hudson.model.TaskListener;
import io.fabric8.kubernetes.clnt.v2_5.KubernetesClient;
import io.fabric8.kubernetes.pipeline.arquillian.cube.kubernetes.AbstractStepExecution;
import io.fabric8.kubernetes.pipeline.arquillian.cube.kubernetes.InNamespaceStep;
import io.fabric8.kubernetes.pipeline.arquillian.cube.kubernetes.MapLabelProvider;
import io.fabric8.kubernetes.pipeline.arquillian.cube.kubernetes.NamespaceDestructionCallback;
import io.fabric8.kubernetes.pipeline.arquillian.cube.kubernetes.NamespaceExpander;
import io.fabric8.kubernetes.pipeline.arquillian.cube.kubernetes.StreamLogger;
import io.fabric8.openshift.clnt.v2_5.OpenShiftClient;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.api.LabelProvider;
import org.arquillian.cube.kubernetes.api.Logger;
import org.arquillian.cube.kubernetes.api.NamespaceService;
import org.arquillian.cube.kubernetes.impl.DefaultConfigurationBuilder;
import org.arquillian.cube.kubernetes.impl.namespace.DefaultNamespaceService;
import org.arquillian.cube.openshift.impl.namespace.OpenshiftNamespaceService;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.NamespaceAction;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class InNamespaceStepExecution
extends AbstractStepExecution<InNamespaceStep> {
    private InNamespaceStep step;
    private String sessionId;
    private String namespace;
    private transient KubernetesClient client;
    private transient NamespaceService namespaceService;
    private transient Configuration configuration;
    private boolean isOpenshift;

    InNamespaceStepExecution(InNamespaceStep step, StepContext context) {
        super(context);
        this.step = step;
    }

    public boolean start() throws Exception {
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        NamespaceAction namespaceAction = new NamespaceAction((Run)this.getContext().get(Run.class));
        this.sessionId = this.generateSessionId();
        this.namespace = this.generateNamespaceId(this.step.getName(), this.step.getPrefix(), this.sessionId);
        this.client = this.getKubernetesClient();
        this.isOpenshift = this.client.isAdaptable(OpenShiftClient.class);
        this.configuration = ((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)new DefaultConfigurationBuilder().withNamespace(this.namespace)).withNamespaceLazyCreateEnabled(this.step.isNamespaceLazyCreateEnabled().booleanValue())).withNamespaceDestroyEnabled(this.step.isNamespaceDestroyEnabled().booleanValue())).withMasterUrl(this.client.getMasterUrl())).build();
        StreamLogger logger = new StreamLogger(listener.getLogger());
        MapLabelProvider labelProvider = new MapLabelProvider(this.step.getLabels());
        Object object = this.namespaceService = this.isOpenshift ? new OpenshiftNamespaceService.ImmutableOpenshiftNamespaceService(this.client, this.configuration, (LabelProvider)labelProvider, (Logger)logger) : new DefaultNamespaceService.ImmutableNamespaceService(this.client, this.configuration, (LabelProvider)labelProvider, (Logger)logger);
        if (!this.namespaceService.exists(this.namespace).booleanValue() && this.configuration.isNamespaceLazyCreateEnabled()) {
            this.namespaceService.create(this.namespace);
        }
        namespaceAction.push(this.namespace);
        this.getContext().newBodyInvoker().withContext((Object)EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)new NamespaceExpander(this.namespace))).withCallback((BodyExecutionCallback)new NamespaceDestructionCallback(this.namespace, this.configuration, this.namespaceService, namespaceAction)).start();
        return false;
    }

    public void stop(Throwable cause) throws Exception {
        if (this.configuration.isNamespaceDestroyEnabled()) {
            this.namespaceService.destroy(this.namespace);
        }
        String ns = new NamespaceAction((Run)this.getContext().get(Run.class)).pop();
    }

    @Override
    InNamespaceStep getStep() {
        return this.step;
    }
}

