/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.pipeline.arquillian.cube.kubernetes;

import hudson.Extension;
import io.fabric8.kubernetes.pipeline.arquillian.cube.kubernetes.AbstractStep;
import io.fabric8.kubernetes.pipeline.arquillian.cube.kubernetes.InNamespaceStepExecution;
import java.io.Serializable;
import java.util.Map;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class InNamespaceStep
extends AbstractStep
implements Serializable {
    private static final long serialVersionUID = 5588861066775717487L;
    private final String name;
    private final String prefix;
    private final Map<String, String> labels;
    private final Map<String, String> annotations;
    private final Boolean namespaceLazyCreateEnabled;
    private final Boolean namespaceDestroyEnabled;

    @DataBoundConstructor
    public InNamespaceStep(String cloud, String name, String prefix, Map<String, String> labels, Map<String, String> annotations, Boolean namespaceLazyCreateEnabled, Boolean namespaceDestroyEnabled) {
        super(cloud);
        this.name = name;
        this.prefix = prefix;
        this.labels = labels;
        this.annotations = annotations;
        this.namespaceLazyCreateEnabled = namespaceLazyCreateEnabled != null ? namespaceLazyCreateEnabled : true;
        this.namespaceDestroyEnabled = namespaceDestroyEnabled != null ? namespaceDestroyEnabled : true;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public Boolean isNamespaceLazyCreateEnabled() {
        return this.namespaceLazyCreateEnabled;
    }

    public Boolean isNamespaceDestroyEnabled() {
        return this.namespaceDestroyEnabled;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new InNamespaceStepExecution(this, context);
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(InNamespaceStepExecution.class);
        }

        public DescriptorImpl(Class<? extends StepExecution> executionType) {
            super(executionType);
        }

        public String getFunctionName() {
            return "inNamespace";
        }

        public String getDisplayName() {
            return "Run build steps inside an arquillian cube kubernetes managed namespace";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public boolean isAdvanced() {
            return true;
        }
    }
}

