/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.pipeline.arquillian.cube.kubernetes;

import hudson.AbortException;
import hudson.model.Run;
import hudson.slaves.Cloud;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.clnt.v2_5.DefaultKubernetesClient;
import io.fabric8.kubernetes.clnt.v2_5.KubernetesClient;
import io.fabric8.kubernetes.clnt.v2_5.utils.Serialization;
import io.fabric8.kubernetes.pipeline.arquillian.cube.kubernetes.AbstractStep;
import io.fabric8.kubernetes.pipeline.arquillian.cube.kubernetes.InSessionStepExecution;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.RandomStringUtils;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.NamespaceAction;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

public abstract class AbstractStepExecution<S extends AbstractStep>
extends StepExecution {
    private static final transient String NAME_FORMAT = "%s-%s";
    private static final transient String DEFAULT_PREFIX = "temp";
    private static final transient String RANDOM_CHARACTERS = "bcdfghjklmnpqrstvwxz0123456789";
    protected static final transient Logger LOGGER = Logger.getLogger(InSessionStepExecution.class.getName());

    abstract S getStep();

    AbstractStepExecution(StepContext context) {
        super(context);
    }

    protected KubernetesClient getKubernetesClient() throws AbortException {
        Cloud cloud = Jenkins.getInstance().getCloud(((AbstractStep)this.getStep()).getCloud());
        if (cloud == null) {
            LOGGER.warning("Cloud does not exist: [" + ((AbstractStep)this.getStep()).getCloud() + "]. Falling back to default KubernetesClient.");
        } else if (!(cloud instanceof KubernetesCloud)) {
            LOGGER.warning("Cloud is not a Kubernetes cloud: [" + ((AbstractStep)this.getStep()).getCloud() + "]. Falling back to default KubernetesClient.");
        } else {
            KubernetesCloud kubernetesCloud = (KubernetesCloud)cloud;
            try {
                String json = Serialization.asJson((Object)kubernetesCloud.connect().getConfiguration());
                return DefaultKubernetesClient.fromConfig((String)json);
            }
            catch (Throwable t) {
                LOGGER.warning("Could not connect to cloud: [" + ((AbstractStep)this.getStep()).getCloud() + "]. Falling back to default KubernetesClient.");
            }
        }
        return new DefaultKubernetesClient();
    }

    protected String generateSessionId() {
        return RandomStringUtils.random((int)5, (String)RANDOM_CHARACTERS);
    }

    protected String generateNamespaceId(String name, String prefix, String sessionId) {
        if (Utils.isNotNullOrEmpty((String)name)) {
            return name;
        }
        if (Utils.isNotNullOrEmpty((String)prefix)) {
            return String.format(NAME_FORMAT, prefix, sessionId);
        }
        NamespaceAction namespaceAction = this.getNamespaceAction();
        if (namespaceAction != null && Utils.isNotNullOrEmpty((String)namespaceAction.getNamespace())) {
            return namespaceAction.getNamespace();
        }
        return String.format(NAME_FORMAT, DEFAULT_PREFIX, sessionId);
    }

    protected NamespaceAction getNamespaceAction() {
        try {
            return new NamespaceAction((Run)this.getContext().get(Run.class));
        }
        catch (Throwable t) {
            return null;
        }
    }
}

