/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.pipeline.arquillian.cube.kubernetes;

import hudson.model.Run;
import hudson.model.TaskListener;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.clnt.v2_5.KubernetesClient;
import io.fabric8.kubernetes.pipeline.arquillian.cube.kubernetes.AbstractSessionManagerStep;
import io.fabric8.kubernetes.pipeline.arquillian.cube.kubernetes.AbstractStepExecution;
import io.fabric8.kubernetes.pipeline.arquillian.cube.kubernetes.EmptyDependencyResolver;
import io.fabric8.kubernetes.pipeline.arquillian.cube.kubernetes.MapAnnotationProvider;
import io.fabric8.kubernetes.pipeline.arquillian.cube.kubernetes.MapLabelProvider;
import io.fabric8.kubernetes.pipeline.arquillian.cube.kubernetes.StreamLogger;
import io.fabric8.openshift.clnt.v2_5.OpenShiftClient;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.arquillian.cube.kubernetes.api.AnnotationProvider;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.api.DependencyResolver;
import org.arquillian.cube.kubernetes.api.FeedbackProvider;
import org.arquillian.cube.kubernetes.api.KubernetesResourceLocator;
import org.arquillian.cube.kubernetes.api.LabelProvider;
import org.arquillian.cube.kubernetes.api.Logger;
import org.arquillian.cube.kubernetes.api.NamespaceService;
import org.arquillian.cube.kubernetes.api.ResourceInstaller;
import org.arquillian.cube.kubernetes.api.Session;
import org.arquillian.cube.kubernetes.impl.DefaultConfigurationBuilder;
import org.arquillian.cube.kubernetes.impl.DefaultSession;
import org.arquillian.cube.kubernetes.impl.SessionManager;
import org.arquillian.cube.kubernetes.impl.feedback.DefaultFeedbackProvider;
import org.arquillian.cube.kubernetes.impl.install.DefaultResourceInstaller;
import org.arquillian.cube.kubernetes.impl.locator.DefaultKubernetesResourceLocator;
import org.arquillian.cube.kubernetes.impl.namespace.DefaultNamespaceService;
import org.arquillian.cube.openshift.impl.locator.OpenshiftKubernetesResourceLocator;
import org.arquillian.cube.openshift.impl.namespace.OpenshiftNamespaceService;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.NamespaceAction;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public abstract class AbstractSessionManagerStepExecution<S extends AbstractSessionManagerStep>
extends AbstractStepExecution<S> {
    protected Session session;
    protected transient KubernetesClient client;
    protected transient Configuration configuration;
    protected transient SessionManager sessionManager;
    protected boolean isOpenShift;

    AbstractSessionManagerStepExecution(StepContext context) {
        super(context);
    }

    public abstract boolean onStart(SessionManager var1) throws Exception;

    public abstract void onStop(SessionManager var1) throws Exception;

    public boolean start() throws Exception {
        this.init();
        return this.onStart(this.sessionManager);
    }

    public void stop(Throwable cause) throws Exception {
        this.onStop(this.sessionManager);
    }

    protected void init() throws Exception {
        boolean isNamespaceCleanupEnabled;
        String sessionId = this.generateSessionId();
        String namespace = this.generateNamespaceId(sessionId);
        this.client = this.getKubernetesClient();
        this.isOpenShift = this.client.isAdaptable(OpenShiftClient.class);
        boolean bl = isNamespaceCleanupEnabled = ((AbstractSessionManagerStep)this.getStep()).isNamespaceCleanupEnabled() != null ? ((AbstractSessionManagerStep)this.getStep()).isNamespaceCleanupEnabled() : false;
        boolean isNamespaceDestroyEnabled = ((AbstractSessionManagerStep)this.getStep()).isNamespaceDestroyEnabled() != null ? ((AbstractSessionManagerStep)this.getStep()).isNamespaceDestroyEnabled() : !this.isNamespaceProvided();
        this.configuration = ((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)new DefaultConfigurationBuilder().withMasterUrl(this.client.getMasterUrl())).withNamespace(namespace)).withEnvironmentInitEnabled(true)).withNamespaceLazyCreateEnabled(((AbstractSessionManagerStep)this.getStep()).isNamespaceLazyCreateEnabled().booleanValue())).withNamespaceCleanupEnabled(isNamespaceCleanupEnabled)).withNamespaceDestroyEnabled(isNamespaceDestroyEnabled)).withEnvironmentDependencies(this.toURL(((AbstractSessionManagerStep)this.getStep()).getEnvironmentDependencies()))).withEnvironmentConfigUrl(this.toURL(((AbstractSessionManagerStep)this.getStep()).getEnvironmentConfigUrl()))).withScriptEnvironmentVariables(((AbstractSessionManagerStep)this.getStep()).getScriptEnvironmentVariables())).withEnvironmentSetupScriptUrl(this.toURL(((AbstractSessionManagerStep)this.getStep()).getEnvironmentSetupScriptUrl()))).withEnvironmentTeardownScriptUrl(this.toURL(((AbstractSessionManagerStep)this.getStep()).getEnvironmentTeardownScriptUrl()))).withWaitForServiceList(((AbstractSessionManagerStep)this.getStep()).getWaitForServiceList())).withWaitTimeout(((AbstractSessionManagerStep)this.getStep()).getWaitTimeout().longValue())).build();
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        StreamLogger logger = new StreamLogger(listener.getLogger());
        this.session = new DefaultSession(sessionId, namespace, (Logger)logger);
        MapLabelProvider labelProvider = new MapLabelProvider(((AbstractSessionManagerStep)this.getStep()).getLabels());
        MapAnnotationProvider annotationProvider = new MapAnnotationProvider(((AbstractSessionManagerStep)this.getStep()).getAnnotations());
        OpenshiftNamespaceService.ImmutableOpenshiftNamespaceService namespaceService = this.isOpenShift ? new OpenshiftNamespaceService.ImmutableOpenshiftNamespaceService(this.client, this.configuration, (LabelProvider)labelProvider, (Logger)logger) : new DefaultNamespaceService.ImmutableNamespaceService(this.client, this.configuration, (LabelProvider)labelProvider, (Logger)logger);
        OpenshiftKubernetesResourceLocator resourceLocator = this.isOpenShift ? new OpenshiftKubernetesResourceLocator() : new DefaultKubernetesResourceLocator();
        DefaultResourceInstaller.ImmutableResourceInstaller resourceInstaller = this.isOpenShift ? new DefaultResourceInstaller.ImmutableResourceInstaller(this.client, this.configuration, (Logger)logger, Collections.emptyList()) : new DefaultResourceInstaller.ImmutableResourceInstaller(this.client, this.configuration, (Logger)logger, Collections.emptyList());
        DefaultFeedbackProvider.ImmutableFeedbackProvider feedbackProvider = new DefaultFeedbackProvider.ImmutableFeedbackProvider(this.client, (Logger)logger);
        EmptyDependencyResolver dependencyResolver = new EmptyDependencyResolver();
        this.sessionManager = new SessionManager(this.session, this.client, this.configuration, (AnnotationProvider)annotationProvider, (NamespaceService)namespaceService, (KubernetesResourceLocator)resourceLocator, (DependencyResolver)dependencyResolver, (ResourceInstaller)resourceInstaller, (FeedbackProvider)feedbackProvider);
    }

    protected boolean isNamespaceProvided() {
        if (Utils.isNotNullOrEmpty((String)((AbstractSessionManagerStep)this.getStep()).getName())) {
            return true;
        }
        NamespaceAction namespaceAction = this.getNamespaceAction();
        return namespaceAction != null && Utils.isNotNullOrEmpty((String)namespaceAction.getNamespace());
    }

    protected String generateNamespaceId(String sessionId) {
        return super.generateNamespaceId(((AbstractSessionManagerStep)this.getStep()).getName(), ((AbstractSessionManagerStep)this.getStep()).getPrefix(), sessionId);
    }

    @Override
    protected NamespaceAction getNamespaceAction() {
        try {
            return new NamespaceAction((Run)this.getContext().get(Run.class));
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected URL toURL(String url) {
        if (Utils.isNullOrEmpty((String)url)) {
            return null;
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Specified url:[" + url + "] is malformed");
        }
    }

    protected List<URL> toURL(List<String> urls) {
        if (urls == null) {
            return null;
        }
        if (urls.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<URL> result = new ArrayList<URL>();
        urls.forEach(u -> result.add(this.toURL((String)u)));
        return result;
    }
}

