/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import com.cloudbees.hudson.plugins.folder.Folder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import hudson.BulkChange;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Saveable;
import hudson.util.XStream2;
import io.fabric8.jenkins.openshiftsync.CredentialsUtils;
import io.fabric8.jenkins.openshiftsync.GlobalPluginConfiguration;
import io.fabric8.jenkins.openshiftsync.NamespaceName;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerStatus;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.Version;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.informers.SharedInformerFactory;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildBuilder;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigSpec;
import io.fabric8.openshift.api.model.BuildFluent;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildStatus;
import io.fabric8.openshift.api.model.GitBuildSource;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.api.model.RouteSpec;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.OpenShiftConfigBuilder;
import io.fabric8.openshift.client.dsl.BuildResource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import okhttp3.Dispatcher;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.tools.ant.filters.StringInputStream;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class OpenShiftUtils {
    private static final Logger logger = Logger.getLogger(OpenShiftUtils.class.getName());
    private static OpenShiftClient openShiftClient;
    private static String jenkinsPodNamespace;
    private static final Jenkins JENKINS_INSTANCE;
    private static final DateTimeFormatter dateFormatter;

    public static synchronized void initializeOpenShiftClient(String serverUrl, int maxConnections) {
        if (openShiftClient != null) {
            logger.log(Level.INFO, "Closing already initialized openshift client");
            openShiftClient.close();
        }
        OpenShiftConfigBuilder configBuilder = new OpenShiftConfigBuilder();
        if (serverUrl != null && !serverUrl.isEmpty()) {
            configBuilder.withMasterUrl(serverUrl);
        }
        OpenShiftConfig config = configBuilder.build();
        logger.log(Level.INFO, "Current OpenShift Client Configuration: " + ReflectionToStringBuilder.toString((Object)config));
        String version = JENKINS_INSTANCE.getPluginManager().getPlugin("openshift-sync").getVersion();
        config.setUserAgent("openshift-sync-plugin-" + version + "/fabric8-" + Version.clientVersion());
        openShiftClient = new DefaultOpenShiftClient((Config)config);
        logger.log(Level.INFO, "New OpenShift client initialized: " + openShiftClient);
        DefaultOpenShiftClient defClient = (DefaultOpenShiftClient)openShiftClient;
        Dispatcher dispatcher = defClient.getHttpClient().dispatcher();
        dispatcher.setMaxRequestsPerHost(maxConnections);
        dispatcher.setMaxRequests(maxConnections);
    }

    public static synchronized OpenShiftClient getOpenShiftClient() {
        return openShiftClient;
    }

    public static synchronized OpenShiftClient getAuthenticatedOpenShiftClient() {
        String token;
        if (openShiftClient == null) {
            GlobalPluginConfiguration config = GlobalPluginConfiguration.get();
            OpenShiftUtils.initializeOpenShiftClient(config.getServer(), config.getMaxConnections());
        }
        if (openShiftClient != null && (token = CredentialsUtils.getCurrentToken()).length() > 0) {
            openShiftClient.getConfiguration().setOauthToken(token);
        }
        return openShiftClient;
    }

    public static SharedInformerFactory getInformerFactory() {
        return OpenShiftUtils.getAuthenticatedOpenShiftClient().informers();
    }

    public static synchronized void shutdownOpenShiftClient() {
        logger.info("Stopping openshift client: " + openShiftClient);
        if (openShiftClient != null) {
            openShiftClient.close();
            openShiftClient = null;
        }
    }

    public static boolean isPipelineStrategyBuildConfig(BuildConfig bc) {
        Map annotations;
        if ("JenkinsPipeline".equalsIgnoreCase(bc.getSpec().getStrategy().getType()) && bc.getSpec().getStrategy().getJenkinsPipelineStrategy() != null) {
            return true;
        }
        ObjectMeta metadata = bc.getMetadata();
        return metadata != null && (annotations = metadata.getAnnotations()) != null && annotations.get("fabric8.link.jenkins.job/label") != null;
    }

    public static boolean isPipelineStrategyBuild(Build b) {
        if (b.getSpec() == null) {
            logger.warning("bad input, null spec: " + b);
            return false;
        }
        if (b.getSpec().getStrategy() == null) {
            logger.warning("bad input, null strategy: " + b);
            return false;
        }
        return "JenkinsPipeline".equalsIgnoreCase(b.getSpec().getStrategy().getType()) && b.getSpec().getStrategy().getJenkinsPipelineStrategy() != null;
    }

    public static String jenkinsJobName(BuildConfig bc) {
        String namespace = bc.getMetadata().getNamespace();
        String name = bc.getMetadata().getName();
        return OpenShiftUtils.jenkinsJobName(namespace, name);
    }

    public static String jenkinsJobName(String namespace, String buildConfigName) {
        return namespace + "-" + buildConfigName;
    }

    public static String jenkinsJobFullName(BuildConfig bc) {
        String jobName = OpenShiftUtils.getAnnotation((HasMetadata)bc, "jenkins.openshift.io/job-path");
        if (StringUtils.isNotBlank((String)jobName)) {
            return jobName;
        }
        if (GlobalPluginConfiguration.get().getFoldersEnabled()) {
            return OpenShiftUtils.getNamespace((HasMetadata)bc) + "/" + OpenShiftUtils.jenkinsJobName(OpenShiftUtils.getNamespace((HasMetadata)bc), OpenShiftUtils.getName((HasMetadata)bc));
        }
        return OpenShiftUtils.getName((HasMetadata)bc);
    }

    public static ItemGroup getFullNameParent(Jenkins activeJenkins, String fullName, String namespace) {
        int idx = fullName.lastIndexOf(47);
        if (idx > 0) {
            String parentFullName = fullName.substring(0, idx);
            Item parent = activeJenkins.getItemByFullName(parentFullName);
            if (parent instanceof ItemGroup) {
                return (ItemGroup)parent;
            }
            if (parentFullName.equals(namespace)) {
                Folder folder = new Folder((ItemGroup)activeJenkins, namespace);
                try {
                    folder.setDescription("Folder for the OpenShift project: " + namespace);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                BulkChange bk = new BulkChange((Saveable)folder);
                StringInputStream jobStream = new StringInputStream(new XStream2().toXML((Object)folder));
                try {
                    activeJenkins.createProjectFromXML(namespace, (InputStream)jobStream).save();
                }
                catch (IOException e) {
                    logger.warning("Failed to create the Folder: " + namespace);
                }
                try {
                    bk.commit();
                }
                catch (IOException e) {
                    logger.warning("Failed to commit toe BulkChange for the Folder: " + namespace);
                }
                parent = activeJenkins.getItemByFullName(namespace);
                if (parent instanceof ItemGroup) {
                    return (ItemGroup)parent;
                }
            }
        }
        return activeJenkins;
    }

    public static String jenkinsJobDisplayName(BuildConfig bc) {
        String namespace = bc.getMetadata().getNamespace();
        String name = bc.getMetadata().getName();
        return OpenShiftUtils.jenkinsJobDisplayName(namespace, name);
    }

    public static String jenkinsJobDisplayName(String namespace, String buildConfigName) {
        return namespace + "/" + buildConfigName;
    }

    public static String[] getNamespaceOrUseDefault(String[] configuredNamespaces, OpenShiftClient client) {
        String[] namespaces = configuredNamespaces;
        if (namespaces != null) {
            for (int i = 0; i < namespaces.length; ++i) {
                if (!namespaces[i].startsWith("${") || !namespaces[i].endsWith("}")) continue;
                String envVar = namespaces[i].substring(2, namespaces[i].length() - 1);
                namespaces[i] = System.getenv(envVar);
                if (!StringUtils.isBlank((String)namespaces[i])) continue;
                logger.warning("No value defined for namespace environment variable `" + envVar + "`");
            }
        }
        if ((namespaces == null || namespaces.length == 0) && StringUtils.isBlank((String)(namespaces = new String[]{client.getNamespace()})[0])) {
            namespaces = new String[]{"default"};
        }
        return namespaces;
    }

    public static String getExternalServiceUrl(OpenShiftClient openShiftClient, String defaultProtocolText, String namespace, String serviceName) {
        if (namespace != null && serviceName != null) {
            try {
                RouteList routes = (RouteList)((NonNamespaceOperation)openShiftClient.routes().inNamespace(namespace)).list();
                for (Route route : routes.getItems()) {
                    String host;
                    RouteSpec spec = route.getSpec();
                    if (spec == null || spec.getTo() == null || !"Service".equalsIgnoreCase(spec.getTo().getKind()) || !serviceName.equalsIgnoreCase(spec.getTo().getName()) || (host = spec.getHost()) == null || host.length() <= 0) continue;
                    if (spec.getTls() != null) {
                        return "https://" + host;
                    }
                    return "http://" + host;
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not find Route for service " + namespace + "/" + serviceName + ". " + e, e);
            }
            try {
                String host;
                ServiceSpec spec;
                Service service = (Service)((ServiceResource)((NonNamespaceOperation)openShiftClient.services().inNamespace(namespace)).withName(serviceName)).get();
                if (service != null && (spec = service.getSpec()) != null && (host = spec.getClusterIP()) != null && host.length() > 0) {
                    return defaultProtocolText + host;
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not find Route for service " + namespace + "/" + serviceName + ". " + e, e);
            }
        }
        return defaultProtocolText + serviceName;
    }

    public static String getJenkinsURL(OpenShiftClient openShiftClient, String namespace) {
        String rootUrl = Jenkins.getInstance().getRootUrl();
        if (StringUtils.isNotEmpty((String)rootUrl)) {
            return rootUrl;
        }
        return OpenShiftUtils.getExternalServiceUrl(openShiftClient, "http://", namespace, "jenkins");
    }

    public static String getNamespacefromPodInputs() {
        return jenkinsPodNamespace;
    }

    public static void updateGitSourceUrl(BuildConfig buildConfig, String gitUrl, String ref) {
        BuildSource source;
        BuildConfigSpec spec = buildConfig.getSpec();
        if (spec == null) {
            spec = new BuildConfigSpec();
            buildConfig.setSpec(spec);
        }
        if ((source = spec.getSource()) == null) {
            source = new BuildSource();
            spec.setSource(source);
        }
        source.setType("Git");
        GitBuildSource gitSource = source.getGit();
        if (gitSource == null) {
            gitSource = new GitBuildSource();
            source.setGit(gitSource);
        }
        gitSource.setUri(gitUrl);
        gitSource.setRef(ref);
    }

    public static void updateOpenShiftBuildPhase(Build build, String phase) {
        String ns = build.getMetadata().getNamespace();
        String name = build.getMetadata().getName();
        logger.log(Level.FINE, "setting build to {0} in namespace {1}/{2}", new Object[]{phase, ns, name});
        BuildBuilder builder = (BuildBuilder)((BuildFluent.StatusNested)new BuildBuilder(build).editStatus().withPhase(phase)).endStatus();
        ((BuildResource)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().builds().inNamespace(ns)).withName(name)).edit(b -> builder.build());
    }

    public static NamespaceName buildConfigNameFromJenkinsJobName(String jobName, String namespace) {
        return new NamespaceName(namespace, jobName);
    }

    public static long parseResourceVersion(HasMetadata obj) {
        return OpenShiftUtils.parseResourceVersion(obj.getMetadata().getResourceVersion());
    }

    public static long parseResourceVersion(String resourceVersion) {
        try {
            return Long.parseLong(resourceVersion);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static String formatTimestamp(long timestamp) {
        return dateFormatter.print((ReadableInstant)new DateTime(timestamp));
    }

    public static long parseTimestamp(String timestamp) {
        return dateFormatter.parseMillis(timestamp);
    }

    public static boolean isResourceWithoutStateEqual(HasMetadata oldObj, HasMetadata newObj) {
        try {
            byte[] oldDigest = MessageDigest.getInstance("MD5").digest(OpenShiftUtils.dumpWithoutRuntimeStateAsYaml(oldObj).getBytes(StandardCharsets.UTF_8));
            byte[] newDigest = MessageDigest.getInstance("MD5").digest(OpenShiftUtils.dumpWithoutRuntimeStateAsYaml(newObj).getBytes(StandardCharsets.UTF_8));
            return Arrays.equals(oldDigest, newDigest);
        }
        catch (JsonProcessingException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String dumpWithoutRuntimeStateAsYaml(HasMetadata obj) throws JsonProcessingException {
        ObjectMapper statelessMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        statelessMapper.addMixInAnnotations(ObjectMeta.class, ObjectMetaMixIn.class);
        statelessMapper.addMixInAnnotations(ReplicationController.class, StatelessReplicationControllerMixIn.class);
        return statelessMapper.writeValueAsString((Object)obj);
    }

    public static boolean isCancellable(BuildStatus buildStatus) {
        String phase = buildStatus.getPhase();
        return phase.equals("New") || phase.equals("Pending") || phase.equals("Running");
    }

    public static boolean isNew(BuildStatus buildStatus) {
        return buildStatus.getPhase().equals("New");
    }

    public static boolean isCancelled(BuildStatus status) {
        return status != null && status.getCancelled() != null && Boolean.TRUE.equals(status.getCancelled());
    }

    static String convertNameToValidResourceName(String text) {
        String lower = text.toLowerCase();
        StringBuilder builder = new StringBuilder();
        boolean started = false;
        int lastCh = 32;
        int last = lower.length() - 1;
        for (int i = 0; i <= last; ++i) {
            int ch = lower.charAt(i);
            if (!(ch >= 97 && ch <= 122 || ch >= 48 && ch <= 57)) {
                if (ch == 47) {
                    ch = 46;
                } else if (ch != 46 && ch != 45) {
                    ch = 45;
                }
                if (!started || lastCh == 45 || lastCh == 46 || i == last) continue;
            }
            builder.append((char)ch);
            started = true;
            lastCh = ch;
        }
        return builder.toString();
    }

    public static String getLabel(HasMetadata resource, String name) {
        Map labels;
        ObjectMeta metadata = resource.getMetadata();
        if (metadata != null && (labels = metadata.getLabels()) != null) {
            return (String)labels.get(name);
        }
        return null;
    }

    public static String getAnnotation(HasMetadata resource, String name) {
        Map annotations;
        ObjectMeta metadata = resource.getMetadata();
        if (metadata != null && (annotations = metadata.getAnnotations()) != null) {
            return (String)annotations.get(name);
        }
        return null;
    }

    public static void addAnnotation(HasMetadata resource, String name, String value) {
        HashMap<String, String> annotations;
        ObjectMeta metadata = resource.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMeta();
            resource.setMetadata(metadata);
        }
        if ((annotations = metadata.getAnnotations()) == null) {
            annotations = new HashMap<String, String>();
            metadata.setAnnotations(annotations);
        }
        annotations.put(name, value);
    }

    public static String getNamespace(HasMetadata resource) {
        ObjectMeta metadata = resource.getMetadata();
        if (metadata != null) {
            return metadata.getNamespace();
        }
        return null;
    }

    public static String getName(HasMetadata resource) {
        ObjectMeta metadata = resource.getMetadata();
        if (metadata != null) {
            return metadata.getName();
        }
        return null;
    }

    protected static OpenShiftClient getOpenshiftClient() {
        return OpenShiftUtils.getAuthenticatedOpenShiftClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        jenkinsPodNamespace = null;
        JENKINS_INSTANCE = Jenkins.getInstanceOrNull();
        jenkinsPodNamespace = System.getProperty("PROJECT_NAME");
        if (jenkinsPodNamespace != null && jenkinsPodNamespace.trim().length() > 0) {
            jenkinsPodNamespace = jenkinsPodNamespace.trim();
        } else {
            File f = new File("/run/secrets/kubernetes.io/serviceaccount/namespace");
            if (f.exists()) {
                FileReader fr = null;
                BufferedReader br = null;
                try {
                    fr = new FileReader("/run/secrets/kubernetes.io/serviceaccount/namespace");
                    br = new BufferedReader(fr);
                    jenkinsPodNamespace = br.readLine();
                    if (jenkinsPodNamespace != null && jenkinsPodNamespace.trim().length() > 0) {
                        jenkinsPodNamespace = jenkinsPodNamespace.trim();
                    }
                }
                catch (FileNotFoundException e) {
                    logger.log(Level.FINE, "getNamespaceFromPodInputs", e);
                }
                catch (IOException e) {
                    logger.log(Level.FINE, "getNamespaceFromPodInputs", e);
                }
                finally {
                    try {
                        br.close();
                        fr.close();
                    }
                    catch (Throwable e) {
                        logger.log(Level.FINE, "getNamespaceFromPodInputs", e);
                    }
                }
            }
        }
        dateFormatter = ISODateTimeFormat.dateTimeNoMillis();
    }

    abstract class ObjectMetaMixIn
    extends ObjectMeta {
        @JsonIgnore
        private String creationTimestamp;
        @JsonIgnore
        private String deletionTimestamp;
        @JsonIgnore
        private Long generation;
        @JsonIgnore
        private String resourceVersion;
        @JsonIgnore
        private String selfLink;
        @JsonIgnore
        private String uid;

        ObjectMetaMixIn() {
        }

        @JsonIgnore
        public abstract String getCreationTimestamp();

        @JsonIgnore
        public abstract String getDeletionTimestamp();

        @JsonIgnore
        public abstract Long getGeneration();

        @JsonIgnore
        public abstract String getResourceVersion();

        @JsonIgnore
        public abstract String getSelfLink();

        @JsonIgnore
        public abstract String getUid();
    }

    abstract class StatelessReplicationControllerMixIn
    extends ReplicationController {
        @JsonIgnore
        private ReplicationControllerStatus status;

        StatelessReplicationControllerMixIn() {
        }

        @JsonIgnore
        public abstract ReplicationControllerStatus getStatus();
    }
}

