/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import io.fabric8.jenkins.openshiftsync.GlobalPluginConfiguration;
import io.fabric8.jenkins.openshiftsync.Lifecyclable;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.jenkins.openshiftsync.PodTemplateUtils;
import io.fabric8.jenkins.openshiftsync.Resyncable;
import io.fabric8.jenkins.openshiftsync.SecretInformer;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.SharedInformerFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMapInformer
implements ResourceEventHandler<ConfigMap>,
Lifecyclable,
Resyncable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SecretInformer.class.getName());
    private SharedIndexInformer<ConfigMap> informer;
    private String namespace;

    public ConfigMapInformer(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public long getResyncPeriodMilliseconds() {
        return 1000 * GlobalPluginConfiguration.get().getConfigMapListInterval();
    }

    @Override
    public void start() {
        LOGGER.info("Starting configMap informer for {} !!" + this.namespace);
        LOGGER.debug("listing ConfigMap resources");
        SharedInformerFactory factory = OpenShiftUtils.getInformerFactory().inNamespace(this.namespace);
        Map<String, String> labels = Collections.singletonMap("role", "jenkins-slave");
        OperationContext withLabels = new OperationContext().withLabels(labels);
        this.informer = factory.sharedIndexInformerFor(ConfigMap.class, withLabels, this.getResyncPeriodMilliseconds());
        this.informer.addEventHandler((ResourceEventHandler)this);
        factory.startAllRegisteredInformers();
        LOGGER.info("ConfigMap informer started for namespace: {}" + this.namespace);
    }

    @Override
    public void stop() {
        LOGGER.info("Stopping informer {} !!" + this.namespace);
        if (this.informer != null) {
            this.informer.stop();
        }
    }

    public void onAdd(ConfigMap obj) {
        LOGGER.debug("ConfigMap informer  received add event for: {}" + obj);
        if (obj != null) {
            ObjectMeta metadata = obj.getMetadata();
            String name = metadata.getName();
            LOGGER.info("ConfigMap informer received add event for: {}" + name);
            List<PodTemplate> podTemplates = PodTemplateUtils.podTemplatesFromConfigMap(obj);
            String uid = metadata.getUid();
            String namespace = metadata.getNamespace();
            PodTemplateUtils.addAgents(podTemplates, "ConfigMap", uid, name, namespace);
        }
    }

    public void onUpdate(ConfigMap oldObj, ConfigMap newObj) {
        LOGGER.debug("ConfigMap informer  received update event for: {} to: {}" + oldObj + newObj);
        if (oldObj != null) {
            String oldResourceVersion = oldObj.getMetadata() != null ? oldObj.getMetadata().getResourceVersion() : null;
            String newResourceVersion = newObj.getMetadata() != null ? newObj.getMetadata().getResourceVersion() : null;
            LOGGER.info("Update event received resource versions: {} to: {}" + oldResourceVersion + newResourceVersion);
            List<PodTemplate> podTemplates = PodTemplateUtils.podTemplatesFromConfigMap(newObj);
            ObjectMeta metadata = newObj.getMetadata();
            String uid = metadata.getUid();
            String name = metadata.getName();
            String namespace = metadata.getNamespace();
            LOGGER.info("ConfigMap informer received update event for: {}", (Object)name);
            PodTemplateUtils.updateAgents(podTemplates, "ConfigMap", uid, name, namespace);
        }
    }

    public void onDelete(ConfigMap obj, boolean deletedFinalStateUnknown) {
        LOGGER.debug("ConfigMap informer received delete event for: {}" + obj);
        if (obj != null) {
            List<PodTemplate> podTemplates = PodTemplateUtils.podTemplatesFromConfigMap(obj);
            ObjectMeta metadata = obj.getMetadata();
            String uid = metadata.getUid();
            String name = metadata.getName();
            String namespace = metadata.getNamespace();
            PodTemplateUtils.deleteAgents(podTemplates, "ConfigMap", uid, name, namespace);
        }
    }

    private void onInit(List<ConfigMap> list) {
        if (list != null) {
            for (ConfigMap configMap : list) {
                PodTemplateUtils.addPodTemplateFromConfigMap(configMap);
            }
        }
    }

    private void waitInformerSync(SharedIndexInformer<ConfigMap> informer) {
        while (!informer.hasSynced()) {
            LOGGER.info("Waiting informer to sync for " + this.namespace);
            try {
                TimeUnit.SECONDS.sleep(5L);
            }
            catch (InterruptedException e) {
                LOGGER.info("Interrupted waiting thread: " + e);
            }
        }
    }
}

