/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import io.fabric8.jenkins.openshiftsync.GlobalPluginConfiguration;
import io.fabric8.jenkins.openshiftsync.Lifecyclable;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.jenkins.openshiftsync.PodTemplateUtils;
import io.fabric8.jenkins.openshiftsync.SecretInformer;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.SharedInformerFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMapClusterInformer
implements ResourceEventHandler<ConfigMap>,
Lifecyclable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SecretInformer.class.getName());
    private SharedIndexInformer<ConfigMap> informer;
    private Set<String> namespaces;

    public ConfigMapClusterInformer(String[] namespaces) {
        this.namespaces = new HashSet<String>(Arrays.asList(namespaces));
    }

    public int getListIntervalInSeconds() {
        return 1000 * GlobalPluginConfiguration.get().getConfigMapListInterval();
    }

    @Override
    public void start() {
        LOGGER.info("Starting cluster wide configMap informer for {} !!" + this.namespaces);
        LOGGER.debug("listing ConfigMap resources");
        SharedInformerFactory factory = OpenShiftUtils.getInformerFactory();
        Map<String, String> labels = Collections.singletonMap("role", "jenkins-slave");
        OperationContext withLabels = new OperationContext().withLabels(labels);
        this.informer = factory.sharedIndexInformerFor(ConfigMap.class, withLabels, (long)this.getListIntervalInSeconds());
        this.informer.addEventHandler((ResourceEventHandler)this);
        factory.startAllRegisteredInformers();
        LOGGER.info("ConfigMap informer started for namespaces: {}" + this.namespaces);
    }

    @Override
    public void stop() {
        LOGGER.info("Stopping informer {} !!" + this.namespaces);
        if (this.informer != null) {
            this.informer.stop();
        }
    }

    public void onAdd(ConfigMap obj) {
        LOGGER.debug("ConfigMap informer received add event for: {}" + obj);
        if (obj != null) {
            ObjectMeta metadata = obj.getMetadata();
            String namespace = metadata.getNamespace();
            if (this.namespaces.contains(namespace)) {
                String name = metadata.getName();
                LOGGER.info("ConfigMap informer received add event for: {}" + name);
                List<PodTemplate> podTemplates = PodTemplateUtils.podTemplatesFromConfigMap(obj);
                String uid = metadata.getUid();
                PodTemplateUtils.addAgents(podTemplates, "ConfigMap", uid, name, namespace);
            } else {
                LOGGER.debug("Received event for a namespace we are not watching: {} ... ignoring", (Object)namespace);
            }
        }
    }

    public void onUpdate(ConfigMap oldObj, ConfigMap newObj) {
        LOGGER.debug("ConfigMap informer  received update event for: {} to: {}" + oldObj + newObj);
        if (oldObj != null) {
            ObjectMeta oldMetadata = oldObj.getMetadata();
            String namespace = oldMetadata.getNamespace();
            if (this.namespaces.contains(namespace)) {
                String oldRv = oldMetadata != null ? oldMetadata.getResourceVersion() : null;
                ObjectMeta newMetadata = newObj.getMetadata();
                String newResourceVersion = newMetadata != null ? newMetadata.getResourceVersion() : null;
                LOGGER.info("Update event received resource versions: {} to: {}" + oldRv + newResourceVersion);
                List<PodTemplate> podTemplates = PodTemplateUtils.podTemplatesFromConfigMap(newObj);
                ObjectMeta metadata = newMetadata;
                String uid = metadata.getUid();
                String name = metadata.getName();
                LOGGER.info("ConfigMap informer received update event for: {}", (Object)name);
                PodTemplateUtils.updateAgents(podTemplates, "ConfigMap", uid, name, namespace);
            } else {
                LOGGER.debug("Received event for a namespace we are not watching: {} ... ignoring", (Object)namespace);
            }
        }
    }

    public void onDelete(ConfigMap obj, boolean deletedFinalStateUnknown) {
        LOGGER.debug("ConfigMap informer received delete event for: {}" + obj);
        if (obj != null) {
            ObjectMeta metadata = obj.getMetadata();
            String namespace = metadata.getNamespace();
            if (this.namespaces.contains(namespace)) {
                List<PodTemplate> podTemplates = PodTemplateUtils.podTemplatesFromConfigMap(obj);
                String uid = metadata.getUid();
                String name = metadata.getName();
                PodTemplateUtils.deleteAgents(podTemplates, "ConfigMap", uid, name, namespace);
            } else {
                LOGGER.debug("Received event for a namespace we are not watching: {} ... ignoring", (Object)namespace);
            }
        }
    }

    private void onInit(List<ConfigMap> list) {
        if (list != null) {
            for (ConfigMap configMap : list) {
                PodTemplateUtils.addPodTemplateFromConfigMap(configMap);
            }
        }
    }

    private void waitInformerSync(SharedIndexInformer<ConfigMap> informer) {
        while (!informer.hasSynced()) {
            LOGGER.info("Waiting informer to sync for " + this.namespaces);
            try {
                TimeUnit.SECONDS.sleep(5L);
            }
            catch (InterruptedException e) {
                LOGGER.info("Interrupted waiting thread: " + e);
            }
        }
    }
}

