/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import hudson.model.CauseAction;
import hudson.model.ParametersAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BuildToActionMapper {
    private static Map<String, ParametersAction> buildToParametersMap = new ConcurrentHashMap<String, ParametersAction>();
    private static Map<String, CauseAction> buildToCauseMap = new ConcurrentHashMap<String, CauseAction>();

    private BuildToActionMapper() {
    }

    static synchronized void initialize() {
        if (buildToParametersMap == null) {
            buildToParametersMap = new ConcurrentHashMap<String, ParametersAction>();
        }
        if (buildToCauseMap == null) {
            buildToCauseMap = new ConcurrentHashMap<String, CauseAction>();
        }
    }

    static synchronized void addParameterAction(String buildId, ParametersAction params) {
        buildToParametersMap.put(buildId, params);
    }

    static synchronized ParametersAction removeParameterAction(String buildId) {
        return buildToParametersMap.remove(buildId);
    }

    static synchronized void addCauseAction(String buildId, CauseAction cause) {
        buildToCauseMap.put(buildId, cause);
    }

    static synchronized CauseAction removeCauseAction(String buildId) {
        return buildToCauseMap.remove(buildId);
    }
}

