/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

public class BuildName {
    private final String jobName;
    private final String buildName;

    public static BuildName parseBuildUrl(String url) {
        while (url.startsWith("/")) {
            url = url.substring(1);
        }
        String[] split = url.split("/");
        if (split.length < 3) {
            throw new IllegalArgumentException("Invalid build URL `" + url + " ` expecting at least 2 '/' characters!");
        }
        return new BuildName(split[1], split[2]);
    }

    public BuildName(String jobName, String buildName) {
        this.jobName = jobName;
        this.buildName = buildName;
    }

    public String toString() {
        return "BuildName{jobName='" + this.jobName + '\'' + ", buildName='" + this.buildName + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildName buildName1 = (BuildName)o;
        if (!this.jobName.equals(buildName1.jobName)) {
            return false;
        }
        return this.buildName.equals(buildName1.buildName);
    }

    public int hashCode() {
        int result = this.jobName.hashCode();
        result = 31 * result + this.buildName.hashCode();
        return result;
    }

    public String getBuildName() {
        return this.buildName;
    }

    public String getJobName() {
        return this.jobName;
    }
}

