/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import io.fabric8.jenkins.openshiftsync.BuildComparator;
import io.fabric8.jenkins.openshiftsync.BuildManager;
import io.fabric8.jenkins.openshiftsync.GlobalPluginConfiguration;
import io.fabric8.jenkins.openshiftsync.Lifecyclable;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.jenkins.openshiftsync.SecretInformer;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.SharedInformerFactory;
import io.fabric8.openshift.api.model.Build;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildInformer
implements ResourceEventHandler<Build>,
Lifecyclable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SecretInformer.class.getName());
    private static final BuildComparator BUILD_COMPARATOR = new BuildComparator();
    private SharedIndexInformer<Build> informer;
    private String namespace;

    public BuildInformer(String namespace) {
        this.namespace = namespace;
    }

    public int getResyncPeriodMilliseconds() {
        return 1000 * GlobalPluginConfiguration.get().getBuildListInterval();
    }

    @Override
    public void start() {
        LOGGER.info("Starting Build informer for {} !!" + this.namespace);
        LOGGER.debug("Listing Build resources");
        SharedInformerFactory factory = OpenShiftUtils.getInformerFactory().inNamespace(this.namespace);
        this.informer = factory.sharedIndexInformerFor(Build.class, (long)this.getResyncPeriodMilliseconds());
        this.informer.addEventHandler((ResourceEventHandler)this);
        factory.startAllRegisteredInformers();
        LOGGER.info("Build informer started for namespace: {}" + this.namespace);
    }

    @Override
    public void stop() {
        LOGGER.info("Stopping informer {} !!" + this.namespace);
        if (this.informer != null) {
            this.informer.stop();
        }
    }

    public void onAdd(Build obj) {
        LOGGER.debug("Build informer  received add event for: {}" + obj);
        if (obj != null) {
            ObjectMeta metadata = obj.getMetadata();
            String name = metadata.getName();
            LOGGER.info("Build informer received add event for: {}" + name);
            try {
                BuildManager.addEventToJenkinsJobRun(obj);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void onUpdate(Build oldObj, Build newObj) {
        LOGGER.debug("Build informer received update event for: {} to: {}" + oldObj + " " + newObj);
        if (newObj != null) {
            String oldRv = oldObj.getMetadata().getResourceVersion();
            String newRv = newObj.getMetadata().getResourceVersion();
            LOGGER.info("Build informer received update event for: {} to: {}" + oldRv + " " + newRv);
            BuildManager.modifyEventToJenkinsJobRun(newObj);
        }
    }

    public void onDelete(Build obj, boolean deletedFinalStateUnknown) {
        LOGGER.info("Build informer received delete event for: {}" + obj);
        if (obj != null) {
            try {
                BuildManager.deleteEventToJenkinsJobRun(obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

