/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import io.fabric8.jenkins.openshiftsync.BuildConfigManager;
import io.fabric8.jenkins.openshiftsync.BuildManager;
import io.fabric8.jenkins.openshiftsync.GlobalPluginConfiguration;
import io.fabric8.jenkins.openshiftsync.Lifecyclable;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.jenkins.openshiftsync.SecretInformer;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.SharedInformerFactory;
import io.fabric8.openshift.api.model.BuildConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildConfigInformer
implements ResourceEventHandler<BuildConfig>,
Lifecyclable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SecretInformer.class.getName());
    private SharedIndexInformer<BuildConfig> informer;
    private String namespace;

    public BuildConfigInformer(String namespace) {
        this.namespace = namespace;
    }

    public int getResyncPeriodMilliseconds() {
        return 1000 * GlobalPluginConfiguration.get().getBuildConfigListInterval();
    }

    @Override
    public void start() {
        LOGGER.info("Starting BuildConfig informer for {} !!" + this.namespace);
        LOGGER.debug("listing BuildConfig resources");
        SharedInformerFactory factory = OpenShiftUtils.getInformerFactory().inNamespace(this.namespace);
        this.informer = factory.sharedIndexInformerFor(BuildConfig.class, (long)this.getResyncPeriodMilliseconds());
        this.informer.addEventHandler((ResourceEventHandler)this);
        factory.startAllRegisteredInformers();
        LOGGER.info("BuildConfig informer started for namespace: {}" + this.namespace);
    }

    @Override
    public void stop() {
        LOGGER.info("Stopping informer {} !!" + this.namespace);
        if (this.informer != null) {
            this.informer.stop();
        }
    }

    public void onAdd(BuildConfig obj) {
        LOGGER.debug("BuildConfig informer  received add event for: {}" + obj);
        if (obj != null) {
            ObjectMeta metadata = obj.getMetadata();
            String name = metadata.getName();
            LOGGER.info("BuildConfig informer received add event for: {}" + name);
            try {
                BuildConfigManager.upsertJob(obj);
                BuildManager.flushBuildsWithNoBCList();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onUpdate(BuildConfig oldObj, BuildConfig newObj) {
        LOGGER.debug("BuildConfig informer received update event for: {} to: {}" + oldObj + " " + newObj);
        if (newObj != null) {
            String oldRv = oldObj.getMetadata().getResourceVersion();
            String newRv = newObj.getMetadata().getResourceVersion();
            LOGGER.info("BuildConfig informer received update event for: {} to: {}" + oldRv + " " + newRv);
            try {
                BuildConfigManager.modifyEventToJenkinsJob(newObj);
                BuildManager.flushBuildsWithNoBCList();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onDelete(BuildConfig obj, boolean deletedFinalStateUnknown) {
        LOGGER.info("BuildConfig informer received delete event for: {}" + obj);
        if (obj != null) {
            try {
                BuildConfigManager.deleteEventToJenkinsJob(obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

