/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import io.fabric8.jenkins.openshiftsync.CredentialsUtils;
import io.fabric8.jenkins.openshiftsync.GlobalPluginConfiguration;
import io.fabric8.jenkins.openshiftsync.Lifecyclable;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.jenkins.openshiftsync.SecretManager;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.SharedInformerFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretClusterInformer
implements ResourceEventHandler<Secret>,
Lifecyclable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SecretClusterInformer.class.getName());
    private static final ConcurrentHashMap<String, String> trackedSecrets = new ConcurrentHashMap();
    private SharedIndexInformer<Secret> informer;
    private Set<String> namespaces;

    public SecretClusterInformer(String[] namespaces) {
        this.namespaces = new HashSet<String>(Arrays.asList(namespaces));
    }

    public int getResyncPeriodMilliseconds() {
        return 1000 * GlobalPluginConfiguration.get().getSecretListInterval();
    }

    @Override
    public void start() {
        LOGGER.info("Starting cluster wide secret informer {} !!" + this.namespaces);
        LOGGER.debug("listing Secret resources");
        SharedInformerFactory factory = OpenShiftUtils.getInformerFactory();
        Map<String, String> labels = Collections.singletonMap("credential.sync.jenkins.openshift.io", "true");
        OperationContext withLabels = new OperationContext().withLabels(labels);
        this.informer = factory.sharedIndexInformerFor(Secret.class, withLabels, (long)this.getResyncPeriodMilliseconds());
        this.informer.addEventHandler((ResourceEventHandler)this);
        factory.startAllRegisteredInformers();
        LOGGER.info("Secret informer started for namespace: {}" + this.namespaces);
    }

    @Override
    public void stop() {
        LOGGER.info("Stopping informer {} !!" + this.namespaces);
        if (this.informer != null) {
            this.informer.stop();
        }
    }

    public void onAdd(Secret obj) {
        LOGGER.debug("Secret informer  received add event for: {}" + obj);
        if (obj != null) {
            ObjectMeta metadata = obj.getMetadata();
            String namespace = metadata.getNamespace();
            if (this.namespaces.contains(namespace)) {
                String name = metadata.getName();
                LOGGER.info("Secret informer received add event for: {}" + name);
                SecretManager.insertOrUpdateCredentialFromSecret(obj);
            } else {
                LOGGER.debug("Received event for a namespace we are not watching: {} ... ignoring", (Object)namespace);
            }
        }
    }

    public void onUpdate(Secret oldObj, Secret newObj) {
        LOGGER.debug("Secret informer received update event for: {} to: {}" + oldObj + newObj);
        if (oldObj != null) {
            ObjectMeta metadata = oldObj.getMetadata();
            String namespace = metadata.getNamespace();
            if (this.namespaces.contains(namespace)) {
                String name = metadata.getName();
                LOGGER.info("Secret informer received update event for: {}", (Object)name);
                SecretManager.updateCredential(newObj);
            } else {
                LOGGER.debug("Received event for a namespace we are not watching: {} ... ignoring", (Object)namespace);
            }
        }
    }

    public void onDelete(Secret obj, boolean deletedFinalStateUnknown) {
        LOGGER.debug("Secret informer received delete event for: {}", (Object)obj);
        if (obj != null) {
            ObjectMeta metadata = obj.getMetadata();
            String namespace = metadata.getNamespace();
            if (this.namespaces.contains(namespace)) {
                String name = obj.getMetadata().getName();
                LOGGER.info("Secret informer received delete event for: {}", (Object)name);
                CredentialsUtils.deleteCredential(obj);
            } else {
                LOGGER.debug("Received event for a namespace we are not watching: {} ... ignoring", (Object)namespace);
            }
        }
    }

    private void onInit(List<Secret> list) {
        for (Secret secret : list) {
            try {
                if (!SecretManager.validSecret(secret) || !SecretManager.shouldProcessSecret(secret)) continue;
                SecretManager.insertOrUpdateCredentialFromSecret(secret);
                trackedSecrets.put(secret.getMetadata().getUid(), secret.getMetadata().getResourceVersion());
            }
            catch (Exception e) {
                LOGGER.error("Failed to update secred", (Throwable)e);
            }
        }
    }
}

