/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import com.thoughtworks.xstream.XStreamException;
import hudson.util.XStream2;
import io.fabric8.jenkins.openshiftsync.JenkinsUtils;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.Image;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamStatus;
import io.fabric8.openshift.api.model.ImageStreamTag;
import io.fabric8.openshift.api.model.TagReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.csanchez.jenkins.plugins.kubernetes.ContainerTemplate;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;

public class PodTemplateUtils {
    private static final String MAVEN_POD_TEMPLATE_NAME = "maven";
    private static final String NODEJS_POD_TEMPLATE_NAME = "nodejs";
    protected static final String CONFIGMAP = "ConfigMap";
    protected static final String isType = "ImageStream";
    static final String IMAGESTREAM_TYPE = "ImageStream";
    private static final String PT_NAME_CLAIMED = "The event for %s | %s | %s that attempts to add the pod template %s was ignored because a %s previously created a pod template with the same name";
    private static final String PT_NOT_OWNED = "The event for %s | %s | %s that no longer includes the pod template %s was ignored because the type %s was associated with that pod template";
    private static final Logger LOGGER = Logger.getLogger(PodTemplateUtils.class.getName());
    private static final String PARAM_FROM_ENV_DESCRIPTION = "From OpenShift Build Environment Variable";
    static final String SLAVE_LABEL = "slave-label";
    private static final String SPECIAL_IST_PREFIX = "imagestreamtag:";
    private static final int SPECIAL_IST_PREFIX_IDX = "imagestreamtag:".length();
    protected static final ConcurrentHashMap<String, List<PodTemplate>> trackedPodTemplates = new ConcurrentHashMap();
    protected static ConcurrentHashMap<String, String> podTemplateToApiType = new ConcurrentHashMap();

    protected static boolean hasOneAndOnlyOneWithSomethingAfter(String str, String substr) {
        return str.contains(substr) && str.indexOf(substr) == str.lastIndexOf(substr) && str.indexOf(substr) < str.length();
    }

    public static PodTemplate podTemplateInit(String name, String image, String label) {
        Pod pod;
        LOGGER.info("Initializing PodTemplate: " + name);
        PodTemplate podTemplate = new PodTemplate(image, new ArrayList());
        ((ContainerTemplate)podTemplate.getContainers().get(0)).setName("jnlp");
        podTemplate.setName(name);
        podTemplate.setLabel(label);
        podTemplate.setAlwaysPullImage(true);
        podTemplate.setCommand("");
        podTemplate.setArgs("${computer.jnlpmac} ${computer.name}");
        podTemplate.setRemoteFs("/tmp");
        String podName = System.getenv().get("HOSTNAME");
        if (podName != null && (pod = (Pod)((PodResource)OpenShiftUtils.getAuthenticatedOpenShiftClient().pods().withName(podName)).get()) != null) {
            podTemplate.setServiceAccount(pod.getSpec().getServiceAccountName());
        }
        return podTemplate;
    }

    public static void removePodTemplate(PodTemplate podTemplate) {
        KubernetesCloud kubeCloud = JenkinsUtils.getKubernetesCloud();
        if (kubeCloud != null) {
            String name = podTemplate.getName();
            String namespace = podTemplate.getNamespace();
            LOGGER.info("Removing PodTemplate: " + name + " in namespace:  " + namespace);
            List list = kubeCloud.getTemplates();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                PodTemplate pt = (PodTemplate)iter.next();
                if (!pt.getName().equals(name)) continue;
                iter.remove();
            }
            kubeCloud.setTemplates(list);
            try {
                Jenkins jenkins = Jenkins.getInstance();
                if (jenkins != null) {
                    jenkins.save();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "removePodTemplate", e);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("PodTemplates now:");
                for (PodTemplate pt : kubeCloud.getTemplates()) {
                    LOGGER.fine(pt.getName());
                }
            }
        }
    }

    public static synchronized List<PodTemplate> getPodTemplates() {
        KubernetesCloud kubeCloud = JenkinsUtils.getKubernetesCloud();
        ArrayList<PodTemplate> list = new ArrayList<PodTemplate>();
        if (kubeCloud != null) {
            list.addAll(kubeCloud.getTemplates());
        }
        return list;
    }

    public static synchronized boolean hasPodTemplate(PodTemplate podTemplate) {
        KubernetesCloud kubeCloud;
        String name = podTemplate.getName();
        String image = podTemplate.getImage();
        if (name != null && image != null && (kubeCloud = JenkinsUtils.getKubernetesCloud()) != null) {
            List list = kubeCloud.getTemplates();
            for (PodTemplate pod : list) {
                if (!name.equals(pod.getName()) || !image.equals(pod.getImage())) continue;
                return true;
            }
        }
        return false;
    }

    public static synchronized void addPodTemplate(PodTemplate podTemplate) {
        PodTemplateUtils.removePodTemplate(podTemplate);
        KubernetesCloud kubeCloud = JenkinsUtils.getKubernetesCloud();
        if (kubeCloud != null) {
            LOGGER.info("Adding PodTemplate: " + podTemplate.getName());
            kubeCloud.addTemplate(podTemplate);
            try {
                Jenkins jenkins = Jenkins.getInstance();
                if (jenkins != null) {
                    jenkins.save();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "addPodTemplate", e);
            }
        }
    }

    protected static void purgeTemplates(String type, String uid, String apiObjName, String namespace) {
        LOGGER.info("Purging PodTemplates for from Configmap with Uid " + uid);
        for (PodTemplate podTemplate : trackedPodTemplates.get(uid)) {
            PodTemplateUtils.removePodTemplate(type, apiObjName, namespace, podTemplate);
        }
        trackedPodTemplates.remove(uid);
    }

    protected static void updateTrackedPodTemplatesMap(String uid, List<PodTemplate> finalSlaveList) {
        if (finalSlaveList != null && finalSlaveList.size() > 0) {
            trackedPodTemplates.put(uid, finalSlaveList);
        }
    }

    protected static void trackPodTemplates(String uid, List<PodTemplate> podTemplatesToTrack) {
        trackedPodTemplates.put(uid, podTemplatesToTrack);
    }

    protected static List<PodTemplate> onlyTrackPodTemplate(String type, String apiObjName, String namespace, List<PodTemplate> podTemplates, PodTemplate podTemplate) {
        String name = podTemplate.getName();
        if (PodTemplateUtils.isReservedPodTemplateName(name) && "ImageStream".equals(type)) {
            return null;
        }
        if (type.equals("ImageStream") && PodTemplateUtils.hasPodTemplate(podTemplate)) {
            return null;
        }
        String ret = podTemplateToApiType.putIfAbsent(name, type);
        if (ret == null || ret.equals(type)) {
            PodTemplateUtils.removePodTemplate(podTemplate);
            podTemplates.add(podTemplate);
        } else {
            LOGGER.info(String.format(PT_NAME_CLAIMED, type, apiObjName, namespace, name, ret));
        }
        return podTemplates;
    }

    protected static void addPodTemplate(String type, String apiObjName, String namespace, List<PodTemplate> podTemplates, PodTemplate podTemplate) {
        String name = podTemplate.getName();
        if (apiObjName != null && namespace != null && podTemplates != null) {
            if (PodTemplateUtils.isReservedPodTemplateName(name) && "ImageStream".equals(type)) {
                LOGGER.info("PodTemplate " + name + " cannot be added because it has a reserved name...ignoring");
                return;
            }
            String podTemplateAsXmlString = podTemplateToApiType.putIfAbsent(name, type);
            if (podTemplateAsXmlString == null || podTemplateAsXmlString.equals(type)) {
                PodTemplateUtils.addPodTemplate(podTemplate);
                podTemplates.add(podTemplate);
            } else {
                LOGGER.info(String.format(PT_NAME_CLAIMED, type, apiObjName, namespace, name, podTemplateAsXmlString));
            }
        } else {
            podTemplateToApiType.put(name, type);
            PodTemplateUtils.addPodTemplate(podTemplate);
        }
    }

    protected static void removePodTemplate(String type, String apiObjName, String namespace, PodTemplate podTemplate) {
        String name = podTemplate.getName();
        String t = podTemplateToApiType.get(name);
        if (t != null && t.equals(type)) {
            podTemplateToApiType.remove(name);
            PodTemplateUtils.removePodTemplate(podTemplate);
        } else {
            LOGGER.info(String.format(PT_NOT_OWNED, type, apiObjName, namespace, name, t));
        }
    }

    protected static boolean isReservedPodTemplateName(String name) {
        return name.equals(MAVEN_POD_TEMPLATE_NAME) || name.equals(NODEJS_POD_TEMPLATE_NAME);
    }

    protected static List<PodTemplate> getPodTemplatesListFromImageStreams(ImageStream imageStream) {
        ArrayList<PodTemplate> results = new ArrayList<PodTemplate>();
        if (imageStream != null) {
            ObjectMeta metadata = imageStream.getMetadata();
            String isName = metadata.getName();
            if (PodTemplateUtils.hasSlaveLabelOrAnnotation(metadata.getLabels())) {
                ImageStreamStatus status = imageStream.getStatus();
                String repository = status.getDockerImageRepository();
                Map annotations = metadata.getAnnotations();
                PodTemplate podTemplate = PodTemplateUtils.podTemplateFromData(isName, repository, annotations);
                results.add(podTemplate);
            }
            results.addAll(PodTemplateUtils.extractPodTemplatesFromImageStreamTags(imageStream));
        }
        return results;
    }

    protected static List<PodTemplate> extractPodTemplatesFromImageStreamTags(ImageStream imageStream) {
        ArrayList<PodTemplate> results = new ArrayList<PodTemplate>();
        List tags = imageStream.getSpec().getTags();
        for (TagReference tagRef : tags) {
            PodTemplateUtils.addPodTemplateFromImageStreamTag(results, imageStream, tagRef);
        }
        return results;
    }

    protected static void addPodTemplateFromImageStreamTag(List<PodTemplate> results, ImageStream imageStream, TagReference tagRef) {
        ObjectMeta metadata = imageStream.getMetadata();
        String ns = metadata.getNamespace();
        String isName = metadata.getName();
        ImageStreamTag tag = null;
        try {
            String tagName = isName + ":" + tagRef.getName();
            tag = (ImageStreamTag)((Resource)((NonNamespaceOperation)OpenShiftUtils.getOpenshiftClient().imageStreamTags().inNamespace(ns)).withName(tagName)).get();
        }
        catch (Throwable t) {
            LOGGER.log(Level.FINE, "addPodTemplateFromImageStreamTag", t);
        }
        if (tag != null) {
            ObjectMeta tagMetadata = tag.getMetadata();
            Map tagAnnotations = tagMetadata.getAnnotations();
            String tagName = tagMetadata.getName();
            String tagImageReference = tag.getImage().getDockerImageReference();
            if (PodTemplateUtils.hasSlaveLabelOrAnnotation(tagAnnotations)) {
                results.add(PodTemplateUtils.podTemplateFromData(tagName, tagImageReference, tagAnnotations));
            } else {
                Map tagLabels = tagMetadata.getLabels();
                if (PodTemplateUtils.hasSlaveLabelOrAnnotation(tagLabels)) {
                    results.add(PodTemplateUtils.podTemplateFromData(tagName, tagImageReference, tagLabels));
                }
            }
        }
    }

    protected static PodTemplate podTemplateFromData(String name, String image, Map<String, String> map) {
        String templateName = name.replaceAll(":", ".");
        String label = map != null && map.containsKey(SLAVE_LABEL) ? map.get(SLAVE_LABEL) : name;
        return PodTemplateUtils.podTemplateInit(templateName, image, label);
    }

    public static List<PodTemplate> podTemplatesFromConfigMap(ConfigMap configMap) {
        ArrayList<PodTemplate> results = new ArrayList<PodTemplate>();
        Map data = configMap.getData();
        if (!PodTemplateUtils.configMapContainsSlave(configMap)) {
            return results;
        }
        XStream2 xStream2 = new XStream2();
        for (Map.Entry entry : data.entrySet()) {
            try {
                Object podTemplate = xStream2.fromXML((String)entry.getValue());
                String warningPrefix = "Content of key '" + (String)entry.getKey() + "' in ConfigMap '" + configMap.getMetadata().getName();
                if (podTemplate instanceof PodTemplate) {
                    block17: {
                        PodTemplate pt = (PodTemplate)podTemplate;
                        String image = pt.getImage();
                        try {
                            if (image.startsWith(SPECIAL_IST_PREFIX)) {
                                if ((image = image.substring(SPECIAL_IST_PREFIX_IDX)).contains("@")) {
                                    LOGGER.warning(warningPrefix + " the presence of @ implies an image stream image, not an image stream tag,  so no ImageStreamTag to Docker image reference translation was performed.");
                                } else {
                                    boolean hasNamespace = PodTemplateUtils.hasOneAndOnlyOneWithSomethingAfter(image, "/");
                                    boolean hasTag = PodTemplateUtils.hasOneAndOnlyOneWithSomethingAfter(image, ":");
                                    String namespace = OpenShiftUtils.getAuthenticatedOpenShiftClient().getNamespace();
                                    String isName = image;
                                    String newImage = null;
                                    if (hasNamespace) {
                                        String[] parts = image.split("/");
                                        namespace = parts[0];
                                        isName = parts[1];
                                    }
                                    if (hasTag) {
                                        ImageStreamTag ist = (ImageStreamTag)((Resource)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().imageStreamTags().inNamespace(namespace)).withName(isName)).get();
                                        Image imageFromIst = ist.getImage();
                                        String dockerImageReference = imageFromIst.getDockerImageReference();
                                        if (ist != null && imageFromIst != null && dockerImageReference != null && dockerImageReference.length() > 0) {
                                            newImage = dockerImageReference;
                                            LOGGER.fine(String.format("Converting image ref %s as an imagestreamtag %s to fully qualified image %s", image, isName, newImage));
                                        } else {
                                            LOGGER.warning(warningPrefix + " used the 'imagestreamtag:' prefix in the image field, but the subsequent value, while a valid ImageStreamTag reference, produced no valid ImageStreaTag upon lookup, so no ImageStreamTag to Docker image reference translation was performed.");
                                        }
                                    } else {
                                        LOGGER.warning(warningPrefix + " used the 'imagestreamtag:' prefix in the image field, but the subsequent value had no tag indicator, so no ImageStreamTag to Docker image reference translation was performed.");
                                    }
                                    if (newImage != null) {
                                        LOGGER.fine("translated IST ref " + image + " to docker image ref " + newImage);
                                        ((ContainerTemplate)pt.getContainers().get(0)).setImage(newImage);
                                    }
                                }
                            }
                        }
                        catch (Throwable t) {
                            if (!LOGGER.isLoggable(Level.FINE)) break block17;
                            LOGGER.log(Level.FINE, "podTemplateFromConfigMap", t);
                        }
                    }
                    results.add((PodTemplate)podTemplate);
                    continue;
                }
                LOGGER.warning(warningPrefix + "' is not a PodTemplate");
            }
            catch (XStreamException xse) {
                LOGGER.warning(new IOException("Unable to read key '" + (String)entry.getKey() + "' from ConfigMap '" + configMap.getMetadata().getName() + "'", xse).getMessage());
            }
            catch (Error e) {
                LOGGER.warning(new IOException("Unable to read key '" + (String)entry.getKey() + "' from ConfigMap '" + configMap.getMetadata().getName() + "'", e).getMessage());
            }
        }
        return results;
    }

    protected static boolean configMapContainsSlave(ConfigMap configMap) {
        return PodTemplateUtils.hasSlaveLabelOrAnnotation(configMap.getMetadata().getLabels());
    }

    protected static boolean hasSlaveLabelOrAnnotation(Map<String, String> map) {
        return map != null && map.containsKey("role") && map.get("role").equals("jenkins-slave");
    }

    protected static void addAgents(List<PodTemplate> slaves, String type, String uid, String apiObjName, String namespace) {
        LOGGER.info("Adding PodTemplate(s) for " + namespace);
        ArrayList<PodTemplate> finalSlaveList = new ArrayList<PodTemplate>();
        for (PodTemplate podTemplate : slaves) {
            PodTemplateUtils.addPodTemplate(type, apiObjName, namespace, finalSlaveList, podTemplate);
        }
        PodTemplateUtils.updateTrackedPodTemplatesMap(uid, finalSlaveList);
    }

    protected static void updateAgents(List<PodTemplate> slaves, String type, String uid, String apiObjName, String namespace) {
        boolean hasSlaves;
        LOGGER.info("Modifying PodTemplates");
        boolean alreadyTracked = trackedPodTemplates.containsKey(uid);
        boolean bl = hasSlaves = slaves.size() > 0;
        if (alreadyTracked) {
            if (hasSlaves) {
                List<PodTemplate> podTemplatesToTrack = new ArrayList<PodTemplate>();
                PodTemplateUtils.purgeTemplates(type, uid, apiObjName, namespace);
                for (PodTemplate pt : slaves) {
                    podTemplatesToTrack = PodTemplateUtils.onlyTrackPodTemplate(type, apiObjName, namespace, podTemplatesToTrack, pt);
                }
                PodTemplateUtils.updateTrackedPodTemplatesMap(uid, podTemplatesToTrack);
                for (PodTemplate podTemplate : podTemplatesToTrack) {
                    PodTemplateUtils.addPodTemplate(type, null, null, null, podTemplate);
                }
            } else {
                PodTemplateUtils.purgeTemplates(type, uid, apiObjName, namespace);
            }
        } else if (hasSlaves) {
            ArrayList<PodTemplate> finalSlaveList = new ArrayList<PodTemplate>();
            for (PodTemplate podTemplate : slaves) {
                PodTemplateUtils.addPodTemplate(type, apiObjName, namespace, finalSlaveList, podTemplate);
            }
            PodTemplateUtils.updateTrackedPodTemplatesMap(uid, finalSlaveList);
        }
    }

    protected static void deleteAgents(List<PodTemplate> slaves, String type, String uid, String apiObjName, String namespace) {
        if (trackedPodTemplates.containsKey(uid)) {
            PodTemplateUtils.purgeTemplates(type, uid, apiObjName, namespace);
        }
    }

    protected static void addPodTemplateFromConfigMap(ConfigMap configMap) {
        try {
            String uid = configMap.getMetadata().getUid();
            if (PodTemplateUtils.configMapContainsSlave(configMap) && !trackedPodTemplates.containsKey(uid)) {
                List<PodTemplate> templates = PodTemplateUtils.podTemplatesFromConfigMap(configMap);
                trackedPodTemplates.put(uid, templates);
                for (PodTemplate podTemplate : templates) {
                    LOGGER.info("Adding PodTemplate {}" + podTemplate);
                    PodTemplateUtils.addPodTemplate(podTemplate);
                }
            }
        }
        catch (Exception e) {
            LOGGER.severe("Failed to update ConfigMap PodTemplates" + e);
        }
    }
}

