/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import com.cloudbees.hudson.plugins.folder.Folder;
import hudson.AbortException;
import hudson.BulkChange;
import hudson.model.Action;
import hudson.model.ItemGroup;
import hudson.model.JobProperty;
import hudson.model.ParameterDefinition;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.util.XStream2;
import io.fabric8.jenkins.openshiftsync.BuildConfigProjectProperty;
import io.fabric8.jenkins.openshiftsync.BuildConfigToJobMap;
import io.fabric8.jenkins.openshiftsync.BuildConfigToJobMapper;
import io.fabric8.jenkins.openshiftsync.JenkinsUtils;
import io.fabric8.jenkins.openshiftsync.NamespaceName;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.openshift.api.model.BuildConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.NotReallyRoleSensitiveCallable;
import org.apache.tools.ant.filters.StringInputStream;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

public class JobProcessor
extends NotReallyRoleSensitiveCallable<Void, Exception> {
    private final BuildConfig buildConfig;
    private static final Logger logger = Logger.getLogger(BuildConfigToJobMap.class.getName());

    public JobProcessor(BuildConfig buildConfig) {
        this.buildConfig = buildConfig;
    }

    public Void call() throws Exception {
        boolean newJob;
        Jenkins activeInstance;
        Jenkins parent = activeInstance = Jenkins.getActiveInstance();
        String jobName = OpenShiftUtils.jenkinsJobName(this.buildConfig);
        String jobFullName = OpenShiftUtils.jenkinsJobFullName(this.buildConfig);
        WorkflowJob job = BuildConfigToJobMap.getJobFromBuildConfig(this.buildConfig);
        if (job == null) {
            job = (WorkflowJob)activeInstance.getItemByFullName(jobFullName);
        }
        boolean bl = newJob = job == null;
        if (newJob) {
            String disableOn = OpenShiftUtils.getAnnotation((HasMetadata)this.buildConfig, "jenkins.openshift.io/disable-sync-create");
            if (disableOn != null && disableOn.length() > 0) {
                logger.fine("Not creating missing jenkins job " + jobFullName + " due to annotation: " + "jenkins.openshift.io/disable-sync-create");
                return null;
            }
            parent = OpenShiftUtils.getFullNameParent(activeInstance, jobFullName, OpenShiftUtils.getNamespace((HasMetadata)this.buildConfig));
            job = new WorkflowJob((ItemGroup)parent, jobName);
        }
        BulkChange bulkJob = new BulkChange((Saveable)job);
        job.setDisplayName(OpenShiftUtils.jenkinsJobDisplayName(this.buildConfig));
        FlowDefinition flowFromBuildConfig = BuildConfigToJobMapper.mapBuildConfigToFlow(this.buildConfig);
        if (flowFromBuildConfig == null) {
            return null;
        }
        Map<String, ParameterDefinition> paramMap = this.createOrUpdateJob(activeInstance, (ItemGroup)parent, jobName, job, newJob, flowFromBuildConfig);
        bulkJob.commit();
        this.populateNamespaceFolder(activeInstance, (ItemGroup)parent, jobName, job, paramMap);
        return null;
    }

    private void populateNamespaceFolder(Jenkins activeInstance, ItemGroup parent, String jobName, WorkflowJob job, Map<String, ParameterDefinition> paramMap) throws IOException, AbortException {
        String fullName = job.getFullName();
        WorkflowJob workflowJob = (WorkflowJob)activeInstance.getItemByFullName(fullName, WorkflowJob.class);
        if (workflowJob == null && parent instanceof Folder) {
            Folder folder = (Folder)parent;
            folder.add((TopLevelItem)job, jobName);
            workflowJob = (WorkflowJob)activeInstance.getItemByFullName(fullName, WorkflowJob.class);
        }
        if (workflowJob == null) {
            logger.warning("Could not find created job " + fullName + " for BuildConfig: " + OpenShiftUtils.getNamespace((HasMetadata)this.buildConfig) + "/" + OpenShiftUtils.getName((HasMetadata)this.buildConfig));
        } else {
            JenkinsUtils.verifyEnvVars(paramMap, workflowJob, this.buildConfig);
            BuildConfigToJobMap.putJobWithBuildConfig(workflowJob, this.buildConfig);
        }
    }

    private Map<String, ParameterDefinition> createOrUpdateJob(Jenkins activeInstance, ItemGroup parent, String jobName, WorkflowJob job, boolean newJob, FlowDefinition flowFromBuildConfig) throws IOException {
        job.setDefinition(flowFromBuildConfig);
        String existingBuildRunPolicy = null;
        BuildConfigProjectProperty buildConfigProjectProperty = (BuildConfigProjectProperty)job.getProperty(BuildConfigProjectProperty.class);
        existingBuildRunPolicy = this.populateBCProjectProperty(job, existingBuildRunPolicy, buildConfigProjectProperty);
        Map<String, ParameterDefinition> paramMap = JenkinsUtils.addJobParamForBuildEnvs(job, this.buildConfig.getSpec().getStrategy().getJenkinsPipelineStrategy(), true);
        job.setConcurrentBuild(!this.buildConfig.getSpec().getRunPolicy().equals("Serial") && !this.buildConfig.getSpec().getRunPolicy().equals("SerialLatestOnly"));
        StringInputStream jobStream = new StringInputStream(new XStream2().toXML((Object)job));
        if (newJob) {
            try {
                if (parent instanceof Folder) {
                    Folder folder = (Folder)parent;
                    folder.createProjectFromXML(jobName, (InputStream)jobStream).save();
                } else {
                    activeInstance.createProjectFromXML(jobName, (InputStream)jobStream).save();
                }
                logger.info("Created job " + jobName + " from BuildConfig " + NamespaceName.create((HasMetadata)this.buildConfig) + " with revision: " + this.buildConfig.getMetadata().getResourceVersion());
                String autostart = OpenShiftUtils.getAnnotation((HasMetadata)this.buildConfig, "jenkins.openshift.io/autostart");
                if (Boolean.parseBoolean(autostart)) {
                    logger.info("Automatically starting job " + jobName + " from BuildConfig " + NamespaceName.create((HasMetadata)this.buildConfig) + " with revision: " + this.buildConfig.getMetadata().getResourceVersion());
                    job.scheduleBuild2(0, new Action[0]);
                }
            }
            catch (IllegalArgumentException e) {
                JenkinsUtils.updateJob(job, (InputStream)jobStream, existingBuildRunPolicy, buildConfigProjectProperty);
                logger.info("Updated job " + jobName + " from BuildConfig " + NamespaceName.create((HasMetadata)this.buildConfig) + " with revision: " + this.buildConfig.getMetadata().getResourceVersion());
            }
        } else {
            JenkinsUtils.updateJob(job, (InputStream)jobStream, existingBuildRunPolicy, buildConfigProjectProperty);
            logger.info("Updated job " + jobName + " from BuildConfig " + NamespaceName.create((HasMetadata)this.buildConfig) + " with revision: " + this.buildConfig.getMetadata().getResourceVersion());
        }
        return paramMap;
    }

    private String populateBCProjectProperty(WorkflowJob job, String existingBuildRunPolicy, BuildConfigProjectProperty buildConfigProjectProperty) throws IOException {
        if (buildConfigProjectProperty != null) {
            existingBuildRunPolicy = buildConfigProjectProperty.getBuildRunPolicy();
            long updatedBCResourceVersion = OpenShiftUtils.parseResourceVersion((HasMetadata)this.buildConfig);
            long oldBCResourceVersion = OpenShiftUtils.parseResourceVersion(buildConfigProjectProperty.getResourceVersion());
            BuildConfigProjectProperty newProperty = new BuildConfigProjectProperty(this.buildConfig);
            if (updatedBCResourceVersion <= oldBCResourceVersion && newProperty.getUid().equals(buildConfigProjectProperty.getUid()) && newProperty.getNamespace().equals(buildConfigProjectProperty.getNamespace()) && newProperty.getName().equals(buildConfigProjectProperty.getName()) && newProperty.getBuildRunPolicy().equals(buildConfigProjectProperty.getBuildRunPolicy())) {
                return null;
            }
            buildConfigProjectProperty.setUid(newProperty.getUid());
            buildConfigProjectProperty.setNamespace(newProperty.getNamespace());
            buildConfigProjectProperty.setName(newProperty.getName());
            buildConfigProjectProperty.setResourceVersion(newProperty.getResourceVersion());
            buildConfigProjectProperty.setBuildRunPolicy(newProperty.getBuildRunPolicy());
        } else {
            job.addProperty((JobProperty)new BuildConfigProjectProperty(this.buildConfig));
        }
        return existingBuildRunPolicy;
    }
}

