/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import io.fabric8.jenkins.openshiftsync.GlobalPluginConfiguration;
import io.fabric8.jenkins.openshiftsync.Lifecyclable;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.jenkins.openshiftsync.PodTemplateUtils;
import io.fabric8.jenkins.openshiftsync.SecretInformer;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.SharedInformerFactory;
import io.fabric8.openshift.api.model.ImageStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageStreamInformer
implements ResourceEventHandler<ImageStream>,
Lifecyclable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SecretInformer.class.getName());
    private SharedIndexInformer<ImageStream> informer;
    private String namespace;

    public ImageStreamInformer(String namespace) {
        this.namespace = namespace;
    }

    public int getResyncPeriodMilliseconds() {
        return 1000 * GlobalPluginConfiguration.get().getImageStreamListInterval();
    }

    @Override
    public void start() {
        LOGGER.info("Starting ImageStream informer for {} !!" + this.namespace);
        LOGGER.debug("Listing ImageStream resources");
        SharedInformerFactory factory = OpenShiftUtils.getInformerFactory().inNamespace(this.namespace);
        Map<String, String> labels = Collections.singletonMap("role", "jenkins-slave");
        OperationContext withLabels = new OperationContext().withLabels(labels);
        this.informer = factory.sharedIndexInformerFor(ImageStream.class, withLabels, (long)this.getResyncPeriodMilliseconds());
        this.informer.addEventHandler((ResourceEventHandler)this);
        factory.startAllRegisteredInformers();
        LOGGER.info("ImageStream informer started for namespace: {}" + this.namespace);
    }

    @Override
    public void stop() {
        LOGGER.info("Stopping informer {} !!" + this.namespace);
        if (this.informer != null) {
            this.informer.stop();
        }
    }

    public void onAdd(ImageStream obj) {
        LOGGER.debug("ImageStream informer  received add event for: {}" + obj);
        if (obj != null) {
            ObjectMeta metadata = obj.getMetadata();
            String name = metadata.getName();
            String uid = metadata.getUid();
            LOGGER.info("ImageStream informer received add event for: {}" + name);
            List<PodTemplate> slaves = PodTemplateUtils.getPodTemplatesListFromImageStreams(obj);
            PodTemplateUtils.addAgents(slaves, "ImageStream", uid, name, this.namespace);
        }
    }

    public void onUpdate(ImageStream oldObj, ImageStream newObj) {
        LOGGER.info("ImageStream informer received update event for: {} to: {}" + oldObj + newObj);
        if (newObj != null) {
            List<PodTemplate> slaves = PodTemplateUtils.getPodTemplatesListFromImageStreams(newObj);
            ObjectMeta metadata = newObj.getMetadata();
            String uid = metadata.getUid();
            String name = metadata.getName();
            String namespace = metadata.getNamespace();
            PodTemplateUtils.updateAgents(slaves, "ImageStream", uid, name, namespace);
        }
    }

    public void onDelete(ImageStream obj, boolean deletedFinalStateUnknown) {
        LOGGER.info("ImageStream informer received delete event for: {}" + obj);
        if (obj != null) {
            List<PodTemplate> slaves = PodTemplateUtils.getPodTemplatesListFromImageStreams(obj);
            ObjectMeta metadata = obj.getMetadata();
            String uid = metadata.getUid();
            String name = metadata.getName();
            String namespace = metadata.getNamespace();
            PodTemplateUtils.deleteAgents(slaves, "ImageStream", uid, name, namespace);
        }
    }

    private void onInit(List<ImageStream> list) {
        for (ImageStream imageStream : list) {
            try {
                List<PodTemplate> agents = PodTemplateUtils.getPodTemplatesListFromImageStreams(imageStream);
                for (PodTemplate podTemplate : agents) {
                    if (PodTemplateUtils.hasPodTemplate(podTemplate)) continue;
                    PodTemplateUtils.addPodTemplate(podTemplate);
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to update job", (Throwable)e);
            }
        }
    }
}

