/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericEventHandler<T extends HasMetadata>
implements ResourceEventHandler<T> {
    private Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    public void onAdd(T obj) {
        String className = obj.getClass().getSimpleName();
        String name = obj.getMetadata().getName();
        this.logger.info("{}/{} added", (Object)className, (Object)name);
    }

    public void onUpdate(T oldObj, T newObj) {
        String className = oldObj.getClass().getSimpleName();
        String name = oldObj.getMetadata().getName();
        this.logger.info("{}/{} updated", (Object)className, (Object)name);
    }

    public void onDelete(T obj, boolean deletedFinalStateUnknown) {
        String className = obj.getClass().getSimpleName();
        String name = obj.getMetadata().getName();
        this.logger.info("{}/{} deleted", (Object)className, (Object)name);
    }
}

