/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import hudson.model.Cause;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildSpec;
import io.fabric8.openshift.api.model.GitBuildSource;
import io.fabric8.openshift.api.model.SourceRevision;
import org.apache.commons.lang.StringUtils;

public class BuildCause
extends Cause {
    private String uid;
    private String namespace;
    private String name;
    private String gitUri;
    private String commit;
    private String buildConfigUid;
    private int numStages = -1;
    private int numFlowNodes = -1;
    private long lastUpdateToOpenshift = -1L;

    public BuildCause(String uid, String namespace, String name, String gitUri, String commit, String buildConfigUid) {
        this.uid = uid;
        this.namespace = namespace;
        this.name = name;
        this.gitUri = gitUri;
        this.commit = commit;
        this.buildConfigUid = buildConfigUid;
    }

    public BuildCause(String uid, String namespace, String name, String gitUri, String commit, String buildConfigUid, int numStages, int numFlowNodes, long lastUpdateToOpenshift) {
        this(uid, namespace, name, gitUri, commit, buildConfigUid);
        this.numStages = numStages;
        this.numFlowNodes = numFlowNodes;
        this.lastUpdateToOpenshift = lastUpdateToOpenshift;
    }

    public BuildCause(Build build, String buildConfigUid) {
        this.buildConfigUid = buildConfigUid;
        if (build == null || build.getMetadata() == null) {
            return;
        }
        ObjectMeta meta = build.getMetadata();
        this.uid = meta.getUid();
        this.namespace = meta.getNamespace();
        this.name = meta.getName();
        BuildSpec spec = build.getSpec();
        if (spec != null) {
            SourceRevision revision;
            BuildSource source = spec.getSource();
            if (source != null && source.getGit() != null) {
                GitBuildSource git = source.getGit();
                this.gitUri = git.getUri();
            }
            if ((revision = spec.getRevision()) != null && revision.getGit() != null) {
                this.commit = revision.getGit().getCommit();
            }
        }
    }

    public String getShortDescription() {
        StringBuilder sb = new StringBuilder("OpenShift Build ").append(this.namespace).append("/").append(this.name);
        if (StringUtils.isNotBlank((String)this.gitUri)) {
            sb.append(" from ").append(this.gitUri);
            if (StringUtils.isNotBlank((String)this.commit)) {
                sb.append(", commit ").append(this.commit);
            }
        }
        return sb.toString();
    }

    public String getUid() {
        return this.uid;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getGitUri() {
        return this.gitUri;
    }

    public String getCommit() {
        return this.commit;
    }

    public String getBuildConfigUid() {
        return this.buildConfigUid;
    }

    public int getNumStages() {
        return this.numStages;
    }

    public void setNumStages(int numStages) {
        this.numStages = numStages;
    }

    public int getNumFlowNodes() {
        return this.numFlowNodes;
    }

    public void setNumFlowNodes(int numFlowNodes) {
        this.numFlowNodes = numFlowNodes;
    }

    public long getLastUpdateToOpenshift() {
        return this.lastUpdateToOpenshift;
    }

    public void setLastUpdateToOpenshift(long lastUpdateToOpenshift) {
        this.lastUpdateToOpenshift = lastUpdateToOpenshift;
    }
}

