/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import com.cloudbees.plugins.credentials.CredentialsParameterDefinition;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.model.Action;
import hudson.model.BooleanParameterDefinition;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.ChoiceParameterDefinition;
import hudson.model.FileParameterDefinition;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.PasswordParameterDefinition;
import hudson.model.Queue;
import hudson.model.RunParameterDefinition;
import hudson.model.StringParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.model.TopLevelItem;
import hudson.plugins.git.RevisionParameterAction;
import hudson.remoting.Callable;
import hudson.security.ACL;
import hudson.slaves.Cloud;
import hudson.triggers.SafeTimerTask;
import hudson.util.XStream2;
import io.fabric8.jenkins.openshiftsync.BuildCause;
import io.fabric8.jenkins.openshiftsync.BuildConfigProjectProperty;
import io.fabric8.jenkins.openshiftsync.BuildConfigToJobMap;
import io.fabric8.jenkins.openshiftsync.BuildToActionMapper;
import io.fabric8.jenkins.openshiftsync.BuildWatcher;
import io.fabric8.jenkins.openshiftsync.CredentialsUtils;
import io.fabric8.jenkins.openshiftsync.GlobalPluginConfiguration;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildBuilder;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildFluent;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.BuildSpec;
import io.fabric8.openshift.api.model.GitBuildSource;
import io.fabric8.openshift.api.model.GitSourceRevision;
import io.fabric8.openshift.api.model.JenkinsPipelineBuildStrategy;
import io.fabric8.openshift.api.model.SourceRevision;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import jenkins.model.Jenkins;
import jenkins.security.NotReallyRoleSensitiveCallable;
import jenkins.util.Timer;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.filters.StringInputStream;
import org.csanchez.jenkins.plugins.kubernetes.ContainerTemplate;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class JenkinsUtils {
    private static final Logger LOGGER = Logger.getLogger(JenkinsUtils.class.getName());
    private static final String PARAM_FROM_ENV_DESCRIPTION = "From OpenShift Build Environment Variable";

    public static Job getJob(String job) {
        TopLevelItem item = Jenkins.getActiveInstance().getItem(job);
        if (item instanceof Job) {
            return (Job)item;
        }
        return null;
    }

    public static String getRootUrl() {
        String root = Jenkins.getActiveInstance().getRootUrl();
        if (root == null || root.length() == 0) {
            root = "http://localhost:8080/";
        }
        return root;
    }

    public static void verifyEnvVars(final Map<String, ParameterDefinition> paramMap, final WorkflowJob workflowJob, BuildConfig buildConfig) throws AbortException {
        try {
            ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<Void, Exception>(){

                public Void call() throws Exception {
                    if (paramMap != null) {
                        String fullName = workflowJob.getFullName();
                        WorkflowJob job = null;
                        long now = System.currentTimeMillis();
                        boolean anyErrors = false;
                        do {
                            if ((job = (WorkflowJob)Jenkins.getActiveInstance().getItemByFullName(fullName, WorkflowJob.class)) != null) {
                                if (!anyErrors) break;
                                LOGGER.info("finally found workflow job for " + job.getFullName());
                                break;
                            }
                            anyErrors = true;
                            LOGGER.warning("A run of workflow job " + workflowJob.getName() + " via fullname " + workflowJob.getFullName() + " unexpectantly not saved to disk.");
                            List jobList = Jenkins.getActiveInstance().getAllItems(WorkflowJob.class);
                            String jobNames = "";
                            for (WorkflowJob j : jobList) {
                                jobNames = jobNames + j.getFullName();
                            }
                            LOGGER.warning("The current list of full job names: " + jobNames);
                            try {
                                Thread.sleep(50L);
                            }
                            catch (Throwable t) {
                                break;
                            }
                        } while (System.currentTimeMillis() - 5000L > now);
                        if (job == null) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (Throwable jobList) {
                                // empty catch block
                            }
                            throw new AbortException("workflow job " + workflowJob.getName() + " via fullname " + workflowJob.getFullName() + " could not be found ");
                        }
                        ParametersDefinitionProperty props = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class);
                        List names = props.getParameterDefinitionNames();
                        for (String name : names) {
                            if (paramMap.containsKey(name)) continue;
                            throw new AbortException("A run of workflow job " + job.getName() + " was expecting parameter " + name + ", but it is not in the parameter list");
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof AbortException) {
                throw (AbortException)e;
            }
            throw new AbortException(e.getMessage());
        }
    }

    public static Map<String, ParameterDefinition> addJobParamForBuildEnvs(WorkflowJob job, JenkinsPipelineBuildStrategy strat, boolean replaceExisting) throws IOException {
        List envs = strat.getEnv();
        HashMap<String, Object> paramMap = null;
        if (envs.size() > 0) {
            ArrayList<String> envKeys = new ArrayList<String>();
            for (EnvVar env : envs) {
                envKeys.add(env.getName());
            }
            ParametersDefinitionProperty params = (ParametersDefinitionProperty)job.removeProperty(ParametersDefinitionProperty.class);
            paramMap = new HashMap<String, Object>();
            if (params != null) {
                List existingParamList = params.getParameterDefinitions();
                Iterator iterator = existingParamList.iterator();
                while (iterator.hasNext()) {
                    ParameterDefinition param = (ParameterDefinition)iterator.next();
                    if (param.getDescription() == null || !param.getDescription().equals(PARAM_FROM_ENV_DESCRIPTION)) {
                        paramMap.put(param.getName(), param);
                        continue;
                    }
                    if (!envKeys.contains(param.getName())) continue;
                    paramMap.put(param.getName(), param);
                }
            }
            for (EnvVar env : envs) {
                StringParameterDefinition envVar;
                if (replaceExisting) {
                    envVar = new StringParameterDefinition(env.getName(), env.getValue() != null ? env.getValue() : "", PARAM_FROM_ENV_DESCRIPTION);
                    paramMap.put(env.getName(), envVar);
                    continue;
                }
                if (paramMap.containsKey(env.getName())) continue;
                envVar = new StringParameterDefinition(env.getName(), "", PARAM_FROM_ENV_DESCRIPTION);
                paramMap.put(env.getName(), envVar);
            }
            ArrayList newParamList = new ArrayList(paramMap.values());
            job.addProperty((JobProperty)new ParametersDefinitionProperty(newParamList));
        }
        StringInputStream jobStream = new StringInputStream(new XStream2().toXML((Object)job));
        JenkinsUtils.updateJob(job, (InputStream)jobStream, null, null);
        return paramMap;
    }

    public static List<Action> setJobRunParamsFromEnv(WorkflowJob job, JenkinsPipelineBuildStrategy strat, List<Action> buildActions) {
        ParametersDefinitionProperty params;
        List envs = strat.getEnv();
        ArrayList<String> envKeys = new ArrayList<String>();
        ArrayList<Object> envVarList = new ArrayList<Object>();
        if (envs.size() > 0) {
            for (EnvVar env : envs) {
                envKeys.add(env.getName());
                envVarList.add(new StringParameterValue(env.getName(), env.getValue() != null ? env.getValue() : ""));
            }
        }
        if ((params = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class)) != null) {
            List existingParamList = params.getParameterDefinitions();
            block19: for (ParameterDefinition param : existingParamList) {
                Object val;
                String type;
                if (envKeys.contains(param.getName())) continue;
                switch (type = param.getType()) {
                    case "BooleanParameterDefinition": {
                        BooleanParameterDefinition bpd = (BooleanParameterDefinition)param;
                        envVarList.add(bpd.getDefaultParameterValue());
                        continue block19;
                    }
                    case "ChoiceParameterDefinition": {
                        ChoiceParameterDefinition cpd = (ChoiceParameterDefinition)param;
                        envVarList.add(cpd.getDefaultParameterValue());
                        continue block19;
                    }
                    case "CredentialsParameterDefinition": {
                        CredentialsParameterDefinition crpd = (CredentialsParameterDefinition)param;
                        envVarList.add(crpd.getDefaultParameterValue());
                        continue block19;
                    }
                    case "FileParameterDefinition": {
                        FileParameterDefinition fpd = (FileParameterDefinition)param;
                        envVarList.add(fpd.getDefaultParameterValue());
                        continue block19;
                    }
                    case "PasswordParameterDefinition": {
                        PasswordParameterDefinition ppd = (PasswordParameterDefinition)param;
                        envVarList.add(ppd.getDefaultParameterValue());
                        continue block19;
                    }
                    case "RunParameterDefinition": {
                        RunParameterDefinition rpd = (RunParameterDefinition)param;
                        envVarList.add(rpd.getDefaultParameterValue());
                        continue block19;
                    }
                    case "StringParameterDefinition": {
                        StringParameterDefinition spd = (StringParameterDefinition)param;
                        envVarList.add(spd.getDefaultParameterValue());
                        continue block19;
                    }
                }
                ParameterValue pv = param.getDefaultParameterValue();
                if (pv == null || (val = pv.getValue()) == null) continue;
                envVarList.add(new StringParameterValue(param.getName(), val.toString()));
            }
        }
        if (envVarList.size() > 0) {
            buildActions.add((Action)new ParametersAction(envVarList));
        }
        return buildActions;
    }

    public static List<Action> setJobRunParamsFromEnvAndUIParams(WorkflowJob job, JenkinsPipelineBuildStrategy strat, List<Action> buildActions, ParametersAction params) {
        List envs = strat.getEnv();
        LinkedHashMap<String, Object> envVarMap = new LinkedHashMap<String, Object>(envs.size());
        if (envs.size() > 0) {
            for (EnvVar env : envs) {
                StringParameterValue param = new StringParameterValue(env.getName(), env.getValue() != null ? env.getValue() : "");
                envVarMap.put(env.getName(), param);
            }
        }
        if (params != null) {
            for (ParameterValue userParam : params.getParameters()) {
                envVarMap.put(userParam.getName(), userParam);
            }
        }
        if (envVarMap.size() > 0) {
            buildActions.add((Action)new ParametersAction(new ArrayList(envVarMap.values())));
        }
        return buildActions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean triggerJob(WorkflowJob job, Build build) throws IOException {
        String buildConfigName = build.getStatus().getConfig().getName();
        if (StringUtils.isBlank((String)buildConfigName)) {
            return false;
        }
        ObjectMeta meta = build.getMetadata();
        String namespace = meta.getNamespace();
        BuildConfig buildConfig = (BuildConfig)((BuildConfigResource)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().buildConfigs().inNamespace(namespace)).withName(buildConfigName)).get();
        if (buildConfig == null) {
            return false;
        }
        String string = buildConfig.getMetadata().getUid().intern();
        synchronized (string) {
            GitSourceRevision gitSourceRevision;
            if (JenkinsUtils.isAlreadyTriggered(job, build)) {
                return false;
            }
            BuildConfigProjectProperty buildConfigProject = (BuildConfigProjectProperty)job.getProperty(BuildConfigProjectProperty.class);
            if (buildConfigProject == null || buildConfigProject.getBuildRunPolicy() == null) {
                LOGGER.warning("aborting trigger of build " + build + "because of missing bc project property or run policy");
                return false;
            }
            switch (buildConfigProject.getBuildRunPolicy()) {
                case "SerialLatestOnly": {
                    JenkinsUtils.cancelQueuedBuilds(job, buildConfigProject.getUid());
                    if (!job.isBuilding()) break;
                    return false;
                }
                case "Serial": {
                    if (!job.isInQueue() && !job.isBuilding()) break;
                    return false;
                }
            }
            CredentialsUtils.updateSourceCredentials(buildConfig);
            ArrayList<BuildCause> newCauses = new ArrayList<BuildCause>();
            newCauses.add(new BuildCause(build, buildConfigProject.getUid()));
            CauseAction originalCauseAction = BuildToActionMapper.removeCauseAction(build.getMetadata().getName());
            if (originalCauseAction != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Adding existing causes...");
                    for (Cause cause : originalCauseAction.getCauses()) {
                        LOGGER.fine("original cause: " + cause.getShortDescription());
                    }
                }
                newCauses.addAll(originalCauseAction.getCauses());
                if (LOGGER.isLoggable(Level.FINE)) {
                    for (Cause cause : newCauses) {
                        LOGGER.fine("new cause: " + cause.getShortDescription());
                    }
                }
            }
            List<Action> buildActions = new ArrayList<Action>();
            CauseAction causeAction = new CauseAction(newCauses);
            buildActions.add((Action)causeAction);
            BuildSpec spec = build.getSpec();
            GitBuildSource gitBuildSource = spec.getSource().getGit();
            SourceRevision sourceRevision = spec.getRevision();
            if (gitBuildSource != null && sourceRevision != null && (gitSourceRevision = sourceRevision.getGit()) != null) {
                try {
                    URIish repoURL = new URIish(gitBuildSource.getUri());
                    buildActions.add((Action)new RevisionParameterAction(gitSourceRevision.getCommit(), repoURL));
                }
                catch (URISyntaxException e) {
                    LOGGER.log(Level.SEVERE, "Failed to parse git repo URL" + gitBuildSource.getUri(), e);
                }
            }
            ParametersAction userProvidedParams = BuildToActionMapper.removeParameterAction(build.getMetadata().getName());
            JenkinsPipelineBuildStrategy strat = spec.getStrategy().getJenkinsPipelineStrategy();
            Map<String, ParameterDefinition> paramMap = JenkinsUtils.addJobParamForBuildEnvs(job, strat, false);
            JenkinsUtils.verifyEnvVars(paramMap, job, buildConfig);
            if (userProvidedParams == null) {
                LOGGER.fine("setting all job run params since this was either started via oc, or started from the UI with no build parameters");
                buildActions = JenkinsUtils.setJobRunParamsFromEnv(job, strat, buildActions);
            } else {
                LOGGER.fine("setting job run params and since this is manually started from jenkins applying user provided parameters " + userProvidedParams + " along with any from bc's env vars");
                buildActions = JenkinsUtils.setJobRunParamsFromEnvAndUIParams(job, strat, buildActions, userProvidedParams);
            }
            BuildConfigToJobMap.putJobWithBuildConfig(job, buildConfig);
            if (job.scheduleBuild2(0, buildActions.toArray(new Action[buildActions.size()])) != null) {
                OpenShiftUtils.updateOpenShiftBuildPhase(build, "Pending");
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }
    }

    private static boolean isAlreadyTriggered(WorkflowJob job, Build build) {
        return JenkinsUtils.getRun(job, build) != null;
    }

    public static void cancelBuild(WorkflowJob job, Build build) {
        JenkinsUtils.cancelBuild(job, build, false);
    }

    public static void cancelBuild(WorkflowJob job, Build build, boolean deleted) {
        if (!JenkinsUtils.cancelQueuedBuild(job, build)) {
            JenkinsUtils.cancelRunningBuild(job, build);
        }
        if (deleted) {
            return;
        }
        OpenShiftUtils.updateOpenShiftBuildPhase(build, "Cancelled");
    }

    private static WorkflowRun getRun(WorkflowJob job, Build build) {
        if (build != null && build.getMetadata() != null) {
            return JenkinsUtils.getRun(job, build.getMetadata().getUid(), 0);
        }
        return null;
    }

    private static WorkflowRun getRun(WorkflowJob job, String buildUid, int retry) {
        try {
            for (WorkflowRun run : job.getBuilds()) {
                BuildCause cause = (BuildCause)run.getCause(BuildCause.class);
                if (cause == null || !cause.getUid().equals(buildUid)) continue;
                return run;
            }
        }
        catch (Throwable t) {
            if (retry == 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return JenkinsUtils.getRun(job, buildUid, 1);
            }
            LOGGER.log(Level.WARNING, "Jenkins unavailability accessing job run; have to assume it does not exist", t);
        }
        return null;
    }

    public static void deleteRun(WorkflowRun run) {
        try {
            LOGGER.info("Deleting run: " + run.toString());
            run.delete();
        }
        catch (IOException e) {
            LOGGER.warning("Unable to delete run " + run.toString() + ":" + e.getMessage());
        }
    }

    public static void deleteRun(WorkflowJob job, Build build) {
        WorkflowRun run = JenkinsUtils.getRun(job, build);
        JenkinsUtils.deleteRun(run);
    }

    private static boolean cancelRunningBuild(WorkflowJob job, Build build) {
        String buildUid = build.getMetadata().getUid();
        WorkflowRun run = JenkinsUtils.getRun(job, buildUid, 0);
        if (run != null && run.isBuilding()) {
            JenkinsUtils.terminateRun(run);
            return true;
        }
        return false;
    }

    private static boolean cancelNotYetStartedBuild(WorkflowJob job, Build build) {
        String buildUid = build.getMetadata().getUid();
        WorkflowRun run = JenkinsUtils.getRun(job, buildUid, 0);
        if (run != null && run.hasntStartedYet()) {
            JenkinsUtils.terminateRun(run);
            return true;
        }
        return false;
    }

    private static void cancelNotYetStartedBuilds(WorkflowJob job, String bcUid) {
        JenkinsUtils.cancelQueuedBuilds(job, bcUid);
        for (WorkflowRun run : job.getBuilds()) {
            BuildCause cause;
            if (run == null || !run.hasntStartedYet() || (cause = (BuildCause)run.getCause(BuildCause.class)) == null || !cause.getBuildConfigUid().equals(bcUid)) continue;
            JenkinsUtils.terminateRun(run);
        }
    }

    private static void terminateRun(final WorkflowRun run) {
        ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<Void, RuntimeException>(){

            public Void call() throws RuntimeException {
                run.doTerm();
                Timer.get().schedule((Runnable)new SafeTimerTask(){

                    public void doRun() {
                        ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<Void, RuntimeException>(){

                            public Void call() throws RuntimeException {
                                run.doKill();
                                return null;
                            }
                        });
                    }
                }, 5L, TimeUnit.SECONDS);
                return null;
            }
        });
    }

    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    public static boolean cancelQueuedBuild(WorkflowJob job, Build build) {
        String buildUid = build.getMetadata().getUid();
        final Queue buildQueue = Jenkins.getActiveInstance().getQueue();
        for (final Queue.Item item : buildQueue.getItems()) {
            for (Cause cause : item.getCauses()) {
                if (!(cause instanceof BuildCause) || !((BuildCause)cause).getUid().equals(buildUid)) continue;
                return (Boolean)ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<Boolean, RuntimeException>(){

                    public Boolean call() throws RuntimeException {
                        buildQueue.cancel(item);
                        return true;
                    }
                });
            }
        }
        return JenkinsUtils.cancelNotYetStartedBuild(job, build);
    }

    public static void cancelQueuedBuilds(WorkflowJob job, String bcUid) {
        Queue buildQueue = Jenkins.getActiveInstance().getQueue();
        for (Queue.Item item : buildQueue.getItems()) {
            for (Cause cause : item.getCauses()) {
                BuildCause buildCause;
                if (!(cause instanceof BuildCause) || !(buildCause = (BuildCause)cause).getBuildConfigUid().equals(bcUid)) continue;
                Build build = ((BuildBuilder)((BuildFluent.MetadataNested)((BuildFluent.MetadataNested)new BuildBuilder().withNewMetadata().withNamespace(buildCause.getNamespace())).withName(buildCause.getName())).and()).build();
                JenkinsUtils.cancelQueuedBuild(job, build);
            }
        }
    }

    public static WorkflowJob getJobFromBuild(Build build) {
        String buildConfigName = build.getStatus().getConfig().getName();
        if (StringUtils.isEmpty((String)buildConfigName)) {
            return null;
        }
        WorkflowJob job = BuildConfigToJobMap.getJobFromBuildConfigNameNamespace(buildConfigName, build.getMetadata().getNamespace());
        if (job != null) {
            return job;
        }
        BuildConfig buildConfig = (BuildConfig)((BuildConfigResource)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().buildConfigs().inNamespace(build.getMetadata().getNamespace())).withName(buildConfigName)).get();
        if (buildConfig == null) {
            return null;
        }
        return BuildConfigToJobMap.getJobFromBuildConfig(buildConfig);
    }

    public static void updateJob(final WorkflowJob job, final InputStream jobStream, final String existingBuildRunPolicy, final BuildConfigProjectProperty buildConfigProjectProperty) throws IOException {
        try {
            ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<Void, Exception>(){

                public Void call() throws Exception {
                    StreamSource source = new StreamSource(jobStream);
                    job.updateByXml((Source)source);
                    job.save();
                    if (existingBuildRunPolicy != null && buildConfigProjectProperty != null && !existingBuildRunPolicy.equals(buildConfigProjectProperty.getBuildRunPolicy())) {
                        JenkinsUtils.maybeScheduleNext(job);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static void maybeScheduleNext(WorkflowJob job) {
        BuildConfigProjectProperty bcp = (BuildConfigProjectProperty)job.getProperty(BuildConfigProjectProperty.class);
        if (bcp == null) {
            return;
        }
        List builds = ((BuildList)((FilterWatchListDeletable)((FilterWatchListDeletable)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().builds().inNamespace(bcp.getNamespace())).withField("status", "New")).withLabel("openshift.io/build-config.name", bcp.getName())).list()).getItems();
        JenkinsUtils.handleBuildList(job, builds, bcp);
    }

    public static void handleBuildList(WorkflowJob job, List<Build> builds, BuildConfigProjectProperty buildConfigProjectProperty) {
        if (builds.isEmpty()) {
            return;
        }
        boolean isSerialLatestOnly = "SerialLatestOnly".equals(buildConfigProjectProperty.getBuildRunPolicy());
        if (isSerialLatestOnly) {
            JenkinsUtils.cancelNotYetStartedBuilds(job, buildConfigProjectProperty.getUid());
        }
        Collections.sort(builds, new Comparator<Build>(){

            @Override
            public int compare(Build b1, Build b2) {
                Boolean b1Cancelled = b1.getStatus() != null && b1.getStatus().getCancelled() != null ? b1.getStatus().getCancelled() : false;
                Boolean b2Cancelled = b2.getStatus() != null && b2.getStatus().getCancelled() != null ? b2.getStatus().getCancelled() : false;
                int cancellationCompare = b2Cancelled.compareTo(b1Cancelled);
                if (cancellationCompare != 0) {
                    return cancellationCompare;
                }
                if (b1.getMetadata().getAnnotations() == null || b1.getMetadata().getAnnotations().get("openshift.io/build.number") == null) {
                    LOGGER.warning("cannot compare build " + b1.getMetadata().getName() + " from namespace " + b1.getMetadata().getNamespace() + ", has bad annotations: " + b1.getMetadata().getAnnotations());
                    return 0;
                }
                if (b2.getMetadata().getAnnotations() == null || b2.getMetadata().getAnnotations().get("openshift.io/build.number") == null) {
                    LOGGER.warning("cannot compare build " + b2.getMetadata().getName() + " from namespace " + b2.getMetadata().getNamespace() + ", has bad annotations: " + b2.getMetadata().getAnnotations());
                    return 0;
                }
                int rc = 0;
                try {
                    rc = Long.compare(Long.parseLong((String)b1.getMetadata().getAnnotations().get("openshift.io/build.number")), Long.parseLong((String)b2.getMetadata().getAnnotations().get("openshift.io/build.number")));
                }
                catch (Throwable t) {
                    LOGGER.log(Level.FINE, "handleBuildList", t);
                }
                return rc;
            }
        });
        boolean isSerial = "Serial".equals(buildConfigProjectProperty.getBuildRunPolicy());
        boolean jobIsBuilding = job.isBuilding();
        for (int i = 0; i < builds.size(); ++i) {
            Build b = builds.get(i);
            if (!OpenShiftUtils.isPipelineStrategyBuild(b)) continue;
            if (isSerialLatestOnly) {
                if (jobIsBuilding && !OpenShiftUtils.isCancelled(b.getStatus())) {
                    return;
                }
                if (i < builds.size() - 1) {
                    JenkinsUtils.cancelQueuedBuild(job, b);
                    OpenShiftUtils.updateOpenShiftBuildPhase(b, "Cancelled");
                    continue;
                }
            }
            boolean buildAdded = false;
            try {
                buildAdded = BuildWatcher.addEventToJenkinsJobRun(b);
            }
            catch (IOException e) {
                ObjectMeta meta = b.getMetadata();
                LOGGER.log(Level.WARNING, "Failed to add new build " + meta.getNamespace() + "/" + meta.getName(), e);
            }
            if (!isSerial || !buildAdded) continue;
            return;
        }
    }

    public static String getFullJobName(WorkflowJob job) {
        return job.getRelativeNameFrom((ItemGroup)Jenkins.getInstance());
    }

    public static String getBuildConfigName(WorkflowJob job) {
        String orgName;
        String name = JenkinsUtils.getFullJobName(job);
        GlobalPluginConfiguration config = GlobalPluginConfiguration.get();
        String[] paths = name.split("/");
        if (paths.length > 1 && StringUtils.isNotBlank((String)(orgName = paths[0])) && config != null) {
            String skipOrganizationPrefix = config.getSkipOrganizationPrefix();
            if (StringUtils.isEmpty((String)skipOrganizationPrefix)) {
                config.setSkipOrganizationPrefix(orgName);
                skipOrganizationPrefix = config.getSkipOrganizationPrefix();
            }
            int prefixLength = orgName.length() + 1;
            if (orgName.equals(skipOrganizationPrefix) && name.length() > prefixLength) {
                name = name.substring(prefixLength);
            }
        }
        String masterSuffix = "/master";
        if (config != null) {
            String skipBranchSuffix = config.getSkipBranchSuffix();
            if (StringUtils.isEmpty((String)skipBranchSuffix)) {
                config.setSkipBranchSuffix("master");
                skipBranchSuffix = config.getSkipBranchSuffix();
            }
            masterSuffix = "/" + skipBranchSuffix;
        }
        if (name.endsWith(masterSuffix) && name.length() > masterSuffix.length()) {
            name = name.substring(0, name.length() - masterSuffix.length());
        }
        return name;
    }

    public static void removePodTemplate(PodTemplate podTemplate) {
        KubernetesCloud kubeCloud = JenkinsUtils.getKubernetesCloud();
        if (kubeCloud != null) {
            LOGGER.info("Removing PodTemplate: " + podTemplate.getName());
            List list = kubeCloud.getTemplates();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                PodTemplate pt = (PodTemplate)iter.next();
                if (!pt.getName().equals(podTemplate.getName())) continue;
                iter.remove();
            }
            kubeCloud.setTemplates(list);
            try {
                Jenkins jenkins = Jenkins.getInstance();
                if (jenkins != null) {
                    jenkins.save();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "removePodTemplate", e);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("PodTemplates now:");
                for (PodTemplate pt : kubeCloud.getTemplates()) {
                    LOGGER.fine(pt.getName());
                }
            }
        }
    }

    public static synchronized List<PodTemplate> getPodTemplates() {
        KubernetesCloud kubeCloud = JenkinsUtils.getKubernetesCloud();
        if (kubeCloud != null) {
            ArrayList<PodTemplate> list = new ArrayList<PodTemplate>();
            list.addAll(kubeCloud.getTemplates());
            return list;
        }
        return null;
    }

    public static synchronized boolean hasPodTemplate(PodTemplate incomingPod) {
        String name = incomingPod.getName();
        if (name == null) {
            return false;
        }
        String image = incomingPod.getImage();
        if (image == null) {
            return false;
        }
        KubernetesCloud kubeCloud = JenkinsUtils.getKubernetesCloud();
        if (kubeCloud != null) {
            List list = kubeCloud.getTemplates();
            for (PodTemplate pod : list) {
                if (!name.equals(pod.getName()) || !image.equals(pod.getImage())) continue;
                return true;
            }
        }
        return false;
    }

    public static synchronized void addPodTemplate(PodTemplate podTemplate) {
        JenkinsUtils.removePodTemplate(podTemplate);
        KubernetesCloud kubeCloud = JenkinsUtils.getKubernetesCloud();
        if (kubeCloud != null) {
            LOGGER.info("Adding PodTemplate: " + podTemplate.getName());
            kubeCloud.addTemplate(podTemplate);
            try {
                Jenkins jenkins = Jenkins.getInstance();
                if (jenkins != null) {
                    jenkins.save();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "addPodTemplate", e);
            }
        }
    }

    public static KubernetesCloud getKubernetesCloud() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            return null;
        }
        Cloud openShiftCloud = jenkins.getCloud("openshift");
        if (openShiftCloud instanceof KubernetesCloud) {
            return (KubernetesCloud)openShiftCloud;
        }
        return null;
    }

    public static PodTemplate podTemplateInit(String name, String image, String label) {
        Pod pod;
        PodTemplate podTemplate = new PodTemplate(image, new ArrayList());
        ((ContainerTemplate)podTemplate.getContainers().get(0)).setName("jnlp");
        podTemplate.setName(name);
        podTemplate.setLabel(label);
        podTemplate.setAlwaysPullImage(true);
        podTemplate.setCommand("");
        podTemplate.setArgs("${computer.jnlpmac} ${computer.name}");
        podTemplate.setRemoteFs("/tmp");
        String podName = System.getenv().get("HOSTNAME");
        if (podName != null && (pod = (Pod)((PodResource)OpenShiftUtils.getAuthenticatedOpenShiftClient().pods().withName(podName)).get()) != null) {
            podTemplate.setServiceAccount(pod.getSpec().getServiceAccountName());
        }
        return podTemplate;
    }
}

