/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import com.cloudbees.workflow.rest.external.AtomFlowNodeExt;
import com.cloudbees.workflow.rest.external.FlowNodeExt;
import com.cloudbees.workflow.rest.external.PendingInputActionsExt;
import com.cloudbees.workflow.rest.external.RunExt;
import com.cloudbees.workflow.rest.external.StageNodeExt;
import com.cloudbees.workflow.rest.external.StatusExt;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.Extension;
import hudson.PluginManager;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.triggers.SafeTimerTask;
import io.fabric8.jenkins.openshiftsync.BuildCause;
import io.fabric8.jenkins.openshiftsync.GlobalPluginConfiguration;
import io.fabric8.jenkins.openshiftsync.JenkinsUtils;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.openshift.api.model.BuildFluent;
import io.fabric8.openshift.api.model.DoneableBuild;
import io.fabric8.openshift.client.dsl.BuildResource;
import io.jenkins.blueocean.rest.factory.BlueRunFactory;
import io.jenkins.blueocean.rest.model.BluePipelineNode;
import io.jenkins.blueocean.rest.model.BlueRun;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.util.Timer;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.support.steps.input.InputAction;
import org.jenkinsci.plugins.workflow.support.steps.input.InputStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

@Extension
public class BuildSyncRunListener
extends RunListener<Run> {
    private static final Logger logger = Logger.getLogger(BuildSyncRunListener.class.getName());
    private long pollPeriodMs = 5000L;
    private long delayPollPeriodMs = 1000L;
    private static final long maxDelay = 30000L;
    private transient ConcurrentLinkedQueue<Run> runsToPoll = new ConcurrentLinkedQueue();
    private transient AtomicBoolean timerStarted = new AtomicBoolean(false);

    public BuildSyncRunListener() {
    }

    @DataBoundConstructor
    public BuildSyncRunListener(long pollPeriodMs) {
        this.pollPeriodMs = pollPeriodMs;
    }

    public static String joinPaths(String ... strings) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            sb.append(strings[i]);
            if (i >= strings.length - 1) continue;
            sb.append("/");
        }
        String joined = sb.toString();
        return joined.replaceAll("/+", "/").replaceAll("/\\?", "?").replaceAll("/#", "#").replaceAll(":/", "://");
    }

    public void onStarted(Run run, TaskListener listener) {
        if (this.shouldPollRun(run)) {
            try {
                BuildCause cause = (BuildCause)run.getCause(BuildCause.class);
                if (cause != null) {
                    run.setDescription(cause.getShortDescription());
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Cannot set build description: " + e);
            }
            if (this.runsToPoll.add(run)) {
                logger.info("starting polling build " + run.getUrl());
            }
            this.checkTimerStarted();
        } else {
            logger.fine("not polling polling build " + run.getUrl() + " as its not a WorkflowJob");
        }
        super.onStarted(run, listener);
    }

    protected void checkTimerStarted() {
        if (this.timerStarted.compareAndSet(false, true)) {
            SafeTimerTask task = new SafeTimerTask(){

                protected void doRun() throws Exception {
                    BuildSyncRunListener.this.pollLoop();
                }
            };
            Timer.get().scheduleAtFixedRate((Runnable)task, this.delayPollPeriodMs, this.pollPeriodMs, TimeUnit.MILLISECONDS);
        }
    }

    public void onCompleted(Run run, @Nonnull TaskListener listener) {
        if (this.shouldPollRun(run)) {
            this.runsToPoll.remove(run);
            this.pollRun(run);
            logger.info("onCompleted " + run.getUrl());
            JenkinsUtils.maybeScheduleNext((WorkflowJob)((WorkflowRun)run).getParent());
        }
        super.onCompleted(run, listener);
    }

    public void onDeleted(Run run) {
        if (this.shouldPollRun(run)) {
            this.runsToPoll.remove(run);
            this.pollRun(run);
            logger.info("onDeleted " + run.getUrl());
            JenkinsUtils.maybeScheduleNext((WorkflowJob)((WorkflowRun)run).getParent());
        }
        super.onDeleted(run);
    }

    public void onFinalized(Run run) {
        if (this.shouldPollRun(run)) {
            this.runsToPoll.remove(run);
            this.pollRun(run);
            logger.info("onFinalized " + run.getUrl());
        }
        super.onFinalized(run);
    }

    protected void pollLoop() {
        Iterator<Run> iter = this.runsToPoll.iterator();
        while (iter.hasNext()) {
            this.pollRun(iter.next());
        }
    }

    protected void pollRun(Run run) {
        if (!(run instanceof WorkflowRun)) {
            throw new IllegalStateException("Cannot poll a non-workflow run");
        }
        RunExt wfRunExt = RunExt.create((WorkflowRun)((WorkflowRun)run));
        BlueRun blueRun = null;
        try {
            blueRun = BlueRunFactory.getRun((Run)run, null);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "pollRun", t);
        }
        try {
            this.upsertBuild(run, wfRunExt, blueRun);
        }
        catch (KubernetesClientException e) {
            if (e.getCode() == 422) {
                this.runsToPoll.remove(run);
                logger.log(Level.WARNING, "Cannot update status: {0}", e.getMessage());
                return;
            }
            throw e;
        }
    }

    private boolean shouldUpdateOpenShiftBuild(BuildCause cause, int latestStageNum, int latestNumFlowNodes, StatusExt status) {
        long currTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        logger.fine(String.format("shouldUpdateOpenShiftBuild curr time %s last update %s curr stage num %s last stage num %scurr flow num %s last flow num %s status %s", String.valueOf(currTime), String.valueOf(cause.getLastUpdateToOpenshift()), String.valueOf(latestStageNum), String.valueOf(cause.getNumStages()), String.valueOf(latestNumFlowNodes), String.valueOf(cause.getNumFlowNodes()), status.toString()));
        if (currTime > cause.getLastUpdateToOpenshift() + 30000L) {
            return true;
        }
        if (cause.getNumStages() != latestStageNum) {
            return true;
        }
        if (cause.getNumFlowNodes() != latestNumFlowNodes) {
            return true;
        }
        return status != StatusExt.IN_PROGRESS && status != StatusExt.PAUSED_PENDING_INPUT;
    }

    private void upsertBuild(Run run, RunExt wfRunExt, BlueRun blueRun) {
        String json;
        String logsBlueOceanUrl;
        String logsConsoleUrl;
        String logsUrl;
        String buildUrl;
        String rootUrl;
        BuildCause cause;
        block26: {
            if (run == null) {
                return;
            }
            cause = (BuildCause)run.getCause(BuildCause.class);
            if (cause == null) {
                return;
            }
            String namespace = OpenShiftUtils.getNamespacefromPodInputs();
            if (namespace == null) {
                namespace = cause.getNamespace();
            }
            rootUrl = OpenShiftUtils.getJenkinsURL(OpenShiftUtils.getAuthenticatedOpenShiftClient(), namespace);
            buildUrl = BuildSyncRunListener.joinPaths(rootUrl, run.getUrl());
            logsUrl = BuildSyncRunListener.joinPaths(buildUrl, "/consoleText");
            logsConsoleUrl = BuildSyncRunListener.joinPaths(buildUrl, "/console");
            logsBlueOceanUrl = null;
            try {
                ClassLoader cl;
                PluginManager pluginMgr;
                Jenkins jenkins = Jenkins.getInstance();
                if (jenkins != null && (pluginMgr = jenkins.getPluginManager()) != null && (cl = pluginMgr.uberClassLoader) != null) {
                    Class<?> weburlbldr = cl.loadClass("org.jenkinsci.plugins.blueoceandisplayurl.BlueOceanDisplayURLImpl");
                    Constructor<?> ctor = weburlbldr.getConstructor(new Class[0]);
                    Object displayURL = ctor.newInstance(new Object[0]);
                    Method getRunURLMethod = weburlbldr.getMethod("getRunURL", Run.class);
                    Object blueOceanURI = getRunURLMethod.invoke(displayURL, run);
                    logsBlueOceanUrl = blueOceanURI.toString();
                    logsBlueOceanUrl = (logsBlueOceanUrl = logsBlueOceanUrl.replaceAll("http://unconfigured-jenkins-location/", "")).startsWith("http://") || logsBlueOceanUrl.startsWith("https://") ? BuildSyncRunListener.joinPaths("", logsBlueOceanUrl) : BuildSyncRunListener.joinPaths(rootUrl, logsBlueOceanUrl);
                }
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.FINE)) break block26;
                logger.log(Level.FINE, "upsertBuild", t);
            }
        }
        HashMap<String, BlueRun.BlueRunResult> blueRunResults = new HashMap<String, BlueRun.BlueRunResult>();
        if (blueRun != null && blueRun.getNodes() != null) {
            for (BluePipelineNode node : blueRun.getNodes()) {
                if (node == null) continue;
                blueRunResults.put(node.getDisplayName(), node.getResult());
            }
        }
        boolean pendingInput = false;
        if (!wfRunExt.get_links().self.href.matches("^https?://.*$")) {
            wfRunExt.get_links().self.setHref(BuildSyncRunListener.joinPaths(rootUrl, wfRunExt.get_links().self.href));
        }
        int newNumStages = wfRunExt.getStages().size();
        int newNumFlowNodes = 0;
        ArrayList<StageNodeExt> validStageList = new ArrayList<StageNodeExt>();
        for (StageNodeExt stage : wfRunExt.getStages()) {
            BlueRun.BlueRunResult result = (BlueRun.BlueRunResult)blueRunResults.get(stage.getName());
            if (result != null && result == BlueRun.BlueRunResult.NOT_BUILT) {
                logger.info("skipping stage " + stage.getName() + " for the status JSON for pipeline run " + run.getDisplayName() + " because it was not executed (most likely because of a failure in another stage)");
                continue;
            }
            validStageList.add(stage);
            FlowNodeExt.FlowNodeLinks links = stage.get_links();
            if (!links.self.href.matches("^https?://.*$")) {
                links.self.setHref(BuildSyncRunListener.joinPaths(rootUrl, links.self.href));
            }
            if (links.getLog() != null && !links.getLog().href.matches("^https?://.*$")) {
                links.getLog().setHref(BuildSyncRunListener.joinPaths(rootUrl, links.getLog().href));
            }
            newNumFlowNodes += stage.getStageFlowNodes().size();
            for (AtomFlowNodeExt node : stage.getStageFlowNodes()) {
                FlowNodeExt.FlowNodeLinks nodeLinks = node.get_links();
                if (!nodeLinks.self.href.matches("^https?://.*$")) {
                    nodeLinks.self.setHref(BuildSyncRunListener.joinPaths(rootUrl, nodeLinks.self.href));
                }
                if (nodeLinks.getLog() == null || nodeLinks.getLog().href.matches("^https?://.*$")) continue;
                nodeLinks.getLog().setHref(BuildSyncRunListener.joinPaths(rootUrl, nodeLinks.getLog().href));
            }
            StatusExt status = stage.getStatus();
            if (status == null || !status.equals((Object)StatusExt.PAUSED_PENDING_INPUT)) continue;
            pendingInput = true;
        }
        wfRunExt.setStages(validStageList);
        boolean needToUpdate = this.shouldUpdateOpenShiftBuild(cause, newNumStages, newNumFlowNodes, wfRunExt.getStatus());
        if (!needToUpdate) {
            return;
        }
        try {
            json = new ObjectMapper().writeValueAsString((Object)wfRunExt);
        }
        catch (JsonProcessingException e) {
            logger.log(Level.SEVERE, "Failed to serialize workflow run. " + (Object)((Object)e), e);
            return;
        }
        String pendingActionsJson = null;
        if (pendingInput && run instanceof WorkflowRun) {
            pendingActionsJson = this.getPendingActionsJson((WorkflowRun)run);
        }
        String phase = this.runToBuildPhase(run);
        long started = this.getStartTime(run);
        String startTime = null;
        String completionTime = null;
        if (started > 0L) {
            startTime = OpenShiftUtils.formatTimestamp(started);
            long duration = this.getDuration(run);
            if (duration > 0L) {
                completionTime = OpenShiftUtils.formatTimestamp(started + duration);
            }
        }
        logger.log(Level.FINE, "Patching build {0}/{1}: setting phase to {2}", new Object[]{cause.getNamespace(), cause.getName(), phase});
        try {
            BuildFluent.MetadataNested builder = (BuildFluent.MetadataNested)((BuildFluent.MetadataNested)((BuildFluent.MetadataNested)((BuildFluent.MetadataNested)((BuildFluent.MetadataNested)((DoneableBuild)((BuildResource)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().builds().inNamespace(cause.getNamespace())).withName(cause.getName())).edit()).editMetadata().addToAnnotations("openshift.io/jenkins-status-json", json)).addToAnnotations("openshift.io/jenkins-build-uri", buildUrl)).addToAnnotations("openshift.io/jenkins-log-url", logsUrl)).addToAnnotations("openshift.io/jenkins-console-log-url", logsConsoleUrl)).addToAnnotations("openshift.io/jenkins-blueocean-log-url", logsBlueOceanUrl);
            String jenkinsNamespace = System.getenv("KUBERNETES_NAMESPACE");
            if (jenkinsNamespace != null && !jenkinsNamespace.isEmpty()) {
                builder.addToAnnotations("openshift.io/jenkins-namespace", jenkinsNamespace);
            }
            if (pendingActionsJson != null && !pendingActionsJson.isEmpty()) {
                builder.addToAnnotations("openshift.io/jenkins-pending-input-actions-json", pendingActionsJson);
            }
            ((DoneableBuild)((BuildFluent.StatusNested)((BuildFluent.StatusNested)((BuildFluent.StatusNested)((DoneableBuild)builder.endMetadata()).editStatus().withPhase(phase)).withStartTimestamp(startTime)).withCompletionTimestamp(completionTime)).endStatus()).done();
        }
        catch (KubernetesClientException e) {
            if (404 == e.getCode()) {
                this.runsToPoll.remove(run);
            }
            throw e;
        }
        cause.setNumFlowNodes(newNumFlowNodes);
        cause.setNumStages(newNumStages);
        cause.setLastUpdateToOpenshift(TimeUnit.NANOSECONDS.toMillis(System.nanoTime()));
    }

    private String getPendingActionsJson(WorkflowRun run) {
        List executions;
        ArrayList<PendingInputActionsExt> pendingInputActions = new ArrayList<PendingInputActionsExt>();
        InputAction inputAction = (InputAction)run.getAction(InputAction.class);
        if (inputAction != null && (executions = inputAction.getExecutions()) != null && !executions.isEmpty()) {
            for (InputStepExecution inputStepExecution : executions) {
                pendingInputActions.add(PendingInputActionsExt.create((InputStepExecution)inputStepExecution, (WorkflowRun)run));
            }
        }
        try {
            return new ObjectMapper().writeValueAsString(pendingInputActions);
        }
        catch (JsonProcessingException e) {
            logger.log(Level.SEVERE, "Failed to serialize pending actions. " + (Object)((Object)e), e);
            return null;
        }
    }

    private long getStartTime(Run run) {
        return run.getStartTimeInMillis();
    }

    private long getDuration(Run run) {
        return run.getDuration();
    }

    private String runToBuildPhase(Run run) {
        if (run != null && !run.hasntStartedYet()) {
            if (run.isBuilding()) {
                return "Running";
            }
            Result result = run.getResult();
            if (result != null) {
                if (result.equals(Result.SUCCESS)) {
                    return "Complete";
                }
                if (result.equals(Result.ABORTED)) {
                    return "Cancelled";
                }
                if (result.equals(Result.FAILURE)) {
                    return "Failed";
                }
                if (result.equals(Result.UNSTABLE)) {
                    return "Failed";
                }
                return "Pending";
            }
        }
        return "New";
    }

    protected boolean shouldPollRun(Run run) {
        return run instanceof WorkflowRun && run.getCause(BuildCause.class) != null && GlobalPluginConfiguration.get().isEnabled();
    }
}

