/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Job;
import hudson.remoting.Callable;
import hudson.security.ACL;
import hudson.triggers.SafeTimerTask;
import io.fabric8.jenkins.openshiftsync.BaseWatcher;
import io.fabric8.jenkins.openshiftsync.BuildConfigToJobMap;
import io.fabric8.jenkins.openshiftsync.BuildWatcher;
import io.fabric8.jenkins.openshiftsync.CredentialsUtils;
import io.fabric8.jenkins.openshiftsync.GlobalPluginConfiguration;
import io.fabric8.jenkins.openshiftsync.JobProcessor;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.jenkins.openshiftsync.WatcherCallback;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Watchable;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.NotReallyRoleSensitiveCallable;
import jenkins.util.Timer;
import org.acegisecurity.Authentication;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

public class BuildConfigWatcher
extends BaseWatcher {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final ConcurrentHashSet<String> deletesInProgress = new ConcurrentHashSet();

    public static void deleteInProgress(String bcName) {
        deletesInProgress.add((Object)bcName);
    }

    public static boolean isDeleteInProgress(String bcID) {
        return deletesInProgress.contains((Object)bcID);
    }

    public static void deleteCompleted(String bcID) {
        deletesInProgress.remove((Object)bcID);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public BuildConfigWatcher(String[] namespaces) {
        super(namespaces);
    }

    @Override
    public int getListIntervalInSeconds() {
        return GlobalPluginConfiguration.get().getBuildConfigListInterval();
    }

    @Override
    public Runnable getStartTimerTask() {
        return new SafeTimerTask(){

            public void doRun() {
                if (!CredentialsUtils.hasCredentials()) {
                    BuildConfigWatcher.this.logger.fine("No Openshift Token credential defined.");
                    return;
                }
                for (String namespace : BuildConfigWatcher.this.namespaces) {
                    BuildConfigList buildConfigs = null;
                    try {
                        BuildConfigWatcher.this.logger.fine("listing BuildConfigs resources");
                        buildConfigs = (BuildConfigList)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().buildConfigs().inNamespace(namespace)).list();
                        BuildConfigWatcher.this.onInitialBuildConfigs(buildConfigs);
                        BuildConfigWatcher.this.logger.fine("handled BuildConfigs resources");
                    }
                    catch (Exception e) {
                        BuildConfigWatcher.this.logger.log(Level.SEVERE, "Failed to load BuildConfigs: " + e, e);
                    }
                    try {
                        String resourceVersion = "0";
                        if (buildConfigs == null) {
                            BuildConfigWatcher.this.logger.warning("Unable to get build config list; impacts resource version used for watch");
                        } else {
                            resourceVersion = buildConfigs.getMetadata().getResourceVersion();
                        }
                        if (BuildConfigWatcher.this.watches.get(namespace) != null) continue;
                        BuildConfigWatcher.this.logger.info("creating BuildConfig watch for namespace " + namespace + " and resource version " + resourceVersion);
                        BuildConfigWatcher.this.addWatch(namespace, (Watch)((Watchable)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().buildConfigs().inNamespace(namespace)).withResourceVersion(resourceVersion)).watch(new WatcherCallback(BuildConfigWatcher.this, namespace)));
                    }
                    catch (Exception e) {
                        BuildConfigWatcher.this.logger.log(Level.SEVERE, "Failed to load BuildConfigs: " + e, e);
                    }
                }
                BuildWatcher.flushBuildsWithNoBCList();
            }
        };
    }

    @Override
    public void start() {
        BuildConfigToJobMap.initializeBuildConfigToJobMap();
        this.logger.info("Now handling startup build configs!!");
        super.start();
    }

    private void onInitialBuildConfigs(BuildConfigList buildConfigs) {
        if (buildConfigs == null) {
            return;
        }
        List items = buildConfigs.getItems();
        if (items != null) {
            for (BuildConfig buildConfig : items) {
                try {
                    this.upsertJob(buildConfig);
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "Failed to update job", e);
                }
            }
        }
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"})
    public void eventReceived(final Watcher.Action action, final BuildConfig buildConfig) {
        try {
            switch (action) {
                case ADDED: {
                    this.upsertJob(buildConfig);
                    break;
                }
                case DELETED: {
                    this.deleteEventToJenkinsJob(buildConfig);
                    break;
                }
                case MODIFIED: {
                    this.modifyEventToJenkinsJob(buildConfig);
                    break;
                }
                case ERROR: {
                    this.logger.warning("watch for buildconfig " + buildConfig.getMetadata().getName() + " received error event ");
                    break;
                }
                default: {
                    this.logger.warning("watch for buildconfig " + buildConfig.getMetadata().getName() + " received unknown event " + action);
                }
            }
            ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<Void, Exception>(){

                public Void call() throws Exception {
                    BuildWatcher.flushBuildsWithNoBCList();
                    if (action == Watcher.Action.ADDED) {
                        SafeTimerTask backupBuildQuery = new SafeTimerTask(){

                            public void doRun() {
                                if (!CredentialsUtils.hasCredentials()) {
                                    BuildConfigWatcher.this.logger.fine("No Openshift Token credential defined.");
                                    return;
                                }
                                BuildList buildList = (BuildList)((FilterWatchListDeletable)((FilterWatchListDeletable)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().builds().inNamespace(buildConfig.getMetadata().getNamespace())).withField("status", "New")).withLabel("openshift.io/build-config.name", buildConfig.getMetadata().getName())).list();
                                if (buildList.getItems().size() > 0) {
                                    BuildConfigWatcher.this.logger.info("build backup query for " + buildConfig.getMetadata().getName() + " found new builds");
                                    BuildWatcher.onInitialBuilds(buildList);
                                }
                            }
                        };
                        Timer.get().schedule((Runnable)backupBuildQuery, 10000L, TimeUnit.MILLISECONDS);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Caught: " + e, e);
        }
    }

    @Override
    public <T> void eventReceived(Watcher.Action action, T resource) {
        BuildConfig bc = (BuildConfig)resource;
        this.eventReceived(action, bc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upsertJob(BuildConfig buildConfig) throws Exception {
        if (OpenShiftUtils.isPipelineStrategyBuildConfig(buildConfig)) {
            String string = buildConfig.getMetadata().getUid().intern();
            synchronized (string) {
                ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new JobProcessor(this, buildConfig));
            }
        }
    }

    private void modifyEventToJenkinsJob(BuildConfig buildConfig) throws Exception {
        if (OpenShiftUtils.isPipelineStrategyBuildConfig(buildConfig)) {
            this.upsertJob(buildConfig);
            return;
        }
        this.deleteEventToJenkinsJob(buildConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerDeleteEventToJenkinsJob(final BuildConfig buildConfig) throws Exception {
        WorkflowJob job = BuildConfigToJobMap.getJobFromBuildConfig(buildConfig);
        if (job != null) {
            String string = buildConfig.getMetadata().getUid().intern();
            synchronized (string) {
                ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<Void, Exception>((Job)job){
                    final /* synthetic */ Job val$job;
                    {
                        this.val$job = job;
                    }

                    public Void call() throws Exception {
                        try {
                            BuildConfigWatcher.deleteInProgress(buildConfig.getMetadata().getNamespace() + buildConfig.getMetadata().getName());
                            this.val$job.delete();
                        }
                        finally {
                            BuildConfigToJobMap.removeJobWithBuildConfig(buildConfig);
                            Jenkins.getActiveInstance().rebuildDependencyGraphAsync();
                            BuildConfigWatcher.deleteCompleted(buildConfig.getMetadata().getNamespace() + buildConfig.getMetadata().getName());
                        }
                        return null;
                    }
                });
                CredentialsUtils.deleteSourceCredentials(buildConfig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteEventToJenkinsJob(BuildConfig buildConfig) throws Exception {
        String bcUid = buildConfig.getMetadata().getUid();
        if (bcUid != null && bcUid.length() > 0) {
            String string = bcUid = bcUid.intern();
            synchronized (string) {
                this.innerDeleteEventToJenkinsJob(buildConfig);
                return;
            }
        }
        this.innerDeleteEventToJenkinsJob(buildConfig);
    }
}

