/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.fabric8.jenkins.openshiftsync.JenkinsUtils;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import jenkins.util.Timer;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;

public abstract class BaseWatcher {
    private final Logger LOGGER = Logger.getLogger(BaseWatcher.class.getName());
    protected ScheduledFuture relister;
    protected final String[] namespaces;
    protected ConcurrentHashMap<String, Watch> watches;
    protected static ConcurrentHashMap<String, List<PodTemplate>> trackedPodTemplates = new ConcurrentHashMap();
    protected static ConcurrentHashMap<String, String> podTemplateToApiType = new ConcurrentHashMap();
    protected static final String cmType = "ConfigMap";
    protected static final String isType = "ImageStream";
    private final String PT_NAME_CLAIMED = "The event for %s | %s | %s that attempts to add the pod template %s was ignored because a %s previously created a pod template with the same name";
    private final String PT_NOT_OWNED = "The event for %s | %s | %s that no longer includes the pod template %s was ignored because the type %s was associated with that pod template";

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public BaseWatcher(String[] namespaces) {
        this.namespaces = namespaces;
        this.watches = new ConcurrentHashMap();
    }

    public abstract Runnable getStartTimerTask();

    public abstract int getListIntervalInSeconds();

    public abstract <T> void eventReceived(Watcher.Action var1, T var2);

    public synchronized void start() {
        Runnable task = this.getStartTimerTask();
        this.relister = Timer.get().scheduleAtFixedRate(task, 100L, this.getListIntervalInSeconds() * 1000, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.relister != null && !this.relister.isDone()) {
            this.relister.cancel(true);
            this.relister = null;
        }
        for (Map.Entry<String, Watch> entry : this.watches.entrySet()) {
            entry.getValue().close();
            this.watches.remove(entry.getKey());
        }
    }

    public void onClose(KubernetesClientException e, String namespace) {
        this.LOGGER.info("Watch for type " + this.getClass().getName() + " closed for one of the following namespaces: " + ((ConcurrentHashMap.CollectionView)((Object)this.watches.keySet())).toString());
        if (e != null) {
            this.LOGGER.warning(e.toString());
            if (e.getStatus() != null && e.getStatus().getCode() == 410) {
                this.stop();
                this.start();
            }
        }
        this.watches.remove(namespace);
    }

    public void addWatch(String key, Watch desiredWatch) {
        Watch watch = this.watches.putIfAbsent(key, desiredWatch);
        if (watch != null) {
            watch.close();
        }
    }

    protected boolean hasSlaveLabelOrAnnotation(Map<String, String> map) {
        if (map != null) {
            return map.containsKey("role") && map.get("role").equals("jenkins-slave");
        }
        return false;
    }

    protected boolean isReservedPodTemplateName(String name) {
        return name.equals("maven") || name.equals("nodejs");
    }

    protected void processSlavesForAddEvent(List<PodTemplate> slaves, String type, String uid, String apiObjName, String namespace) {
        ArrayList<PodTemplate> finalSlaveList = new ArrayList<PodTemplate>();
        for (PodTemplate podTemplate : slaves) {
            String name = podTemplate.getName();
            if (this.isReservedPodTemplateName(name) && isType.equals(type)) continue;
            String ret = podTemplateToApiType.putIfAbsent(name, type);
            if (ret == null || ret.equals(type)) {
                JenkinsUtils.addPodTemplate(podTemplate);
                finalSlaveList.add(podTemplate);
                continue;
            }
            this.LOGGER.info(String.format("The event for %s | %s | %s that attempts to add the pod template %s was ignored because a %s previously created a pod template with the same name", type, apiObjName, namespace, name, ret));
        }
        if (finalSlaveList.size() > 0) {
            trackedPodTemplates.put(uid, finalSlaveList);
        }
    }

    protected void processSlavesForModifyEvent(List<PodTemplate> slaves, String type, String uid, String apiObjName, String namespace) {
        boolean hasSlaves;
        boolean alreadyTracked = trackedPodTemplates.containsKey(uid);
        boolean bl = hasSlaves = slaves.size() > 0;
        if (alreadyTracked) {
            if (hasSlaves) {
                String name;
                ArrayList<PodTemplate> finalSlaveList = new ArrayList<PodTemplate>();
                for (PodTemplate podTemplate : trackedPodTemplates.get(uid)) {
                    name = podTemplate.getName();
                    if (this.isReservedPodTemplateName(name) && isType.equals(type) || type.equals(isType) && JenkinsUtils.hasPodTemplate(podTemplate)) continue;
                    String ret = podTemplateToApiType.putIfAbsent(name, type);
                    if (ret == null || ret.equals(type)) {
                        JenkinsUtils.removePodTemplate(podTemplate);
                        finalSlaveList.add(podTemplate);
                        continue;
                    }
                    this.LOGGER.info(String.format("The event for %s | %s | %s that attempts to add the pod template %s was ignored because a %s previously created a pod template with the same name", type, apiObjName, namespace, name, ret));
                }
                if (finalSlaveList.size() > 0) {
                    trackedPodTemplates.put(uid, finalSlaveList);
                }
                for (PodTemplate podTemplate : finalSlaveList) {
                    name = podTemplate.getName();
                    podTemplateToApiType.put(name, type);
                    JenkinsUtils.addPodTemplate(podTemplate);
                }
            } else {
                for (PodTemplate podTemplate : trackedPodTemplates.get(uid)) {
                    String name = podTemplate.getName();
                    String t = podTemplateToApiType.get(name);
                    if (t != null && t.equals(type)) {
                        podTemplateToApiType.remove(name);
                        JenkinsUtils.removePodTemplate(podTemplate);
                        continue;
                    }
                    this.LOGGER.info(String.format("The event for %s | %s | %s that no longer includes the pod template %s was ignored because the type %s was associated with that pod template", type, apiObjName, namespace, name, t));
                }
                trackedPodTemplates.remove(uid);
            }
        } else if (hasSlaves) {
            ArrayList<PodTemplate> finalSlaveList = new ArrayList<PodTemplate>();
            for (PodTemplate podTemplate : slaves) {
                String name = podTemplate.getName();
                if (this.isReservedPodTemplateName(name) && isType.equals(type)) continue;
                String ret = podTemplateToApiType.putIfAbsent(name, type);
                if (ret == null || ret.equals(type)) {
                    JenkinsUtils.addPodTemplate(podTemplate);
                    finalSlaveList.add(podTemplate);
                    continue;
                }
                this.LOGGER.info(String.format("The event for %s | %s | %s that attempts to add the pod template %s was ignored because a %s previously created a pod template with the same name", type, apiObjName, namespace, name, ret));
            }
            if (finalSlaveList.size() > 0) {
                trackedPodTemplates.put(uid, finalSlaveList);
            }
        }
    }

    protected void processSlavesForDeleteEvent(List<PodTemplate> slaves, String type, String uid, String apiObjName, String namespace) {
        if (!trackedPodTemplates.containsKey(uid)) {
            return;
        }
        for (PodTemplate podTemplate : trackedPodTemplates.get(uid)) {
            String name = podTemplate.getName();
            String t = podTemplateToApiType.get(name);
            if (t != null && t.equals(type)) {
                podTemplateToApiType.remove(name);
                JenkinsUtils.removePodTemplate(podTemplate);
                continue;
            }
            this.LOGGER.info(String.format("The event for %s | %s | %s that no longer includes the pod template %s was ignored because the type %s was associated with that pod template", type, apiObjName, namespace, name, t));
        }
        trackedPodTemplates.remove(uid);
    }
}

