/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import com.google.common.base.Objects;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.listeners.ItemListener;
import io.fabric8.jenkins.openshiftsync.BuildConfigProjectProperty;
import io.fabric8.jenkins.openshiftsync.BuildConfigToJobMap;
import io.fabric8.jenkins.openshiftsync.BuildConfigToJobMapper;
import io.fabric8.jenkins.openshiftsync.GlobalPluginConfiguration;
import io.fabric8.jenkins.openshiftsync.JenkinsUtils;
import io.fabric8.jenkins.openshiftsync.NamespaceName;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigSpec;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildStrategy;
import io.fabric8.openshift.api.model.GitBuildSource;
import io.fabric8.openshift.api.model.JenkinsPipelineBuildStrategy;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.kohsuke.stapler.DataBoundConstructor;

@Extension
public class PipelineJobListener
extends ItemListener {
    private static final Logger logger = Logger.getLogger(PipelineJobListener.class.getName());
    private String server;
    private String[] namespaces;
    private String jobNamePattern;

    public PipelineJobListener() {
        this.init();
    }

    @DataBoundConstructor
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public PipelineJobListener(String server, String[] namespaces, String jobNamePattern) {
        this.server = server;
        this.namespaces = namespaces;
        this.jobNamePattern = jobNamePattern;
        this.init();
    }

    public String toString() {
        return "PipelineJobListener{server='" + this.server + '\'' + ", namespace='" + this.namespaces + '\'' + ", jobNamePattern='" + this.jobNamePattern + '\'' + '}';
    }

    private void init() {
        this.namespaces = OpenShiftUtils.getNamespaceOrUseDefault(this.namespaces, OpenShiftUtils.getOpenShiftClient());
    }

    public void onCreated(Item item) {
        if (!GlobalPluginConfiguration.get().isEnabled()) {
            return;
        }
        this.reconfigure();
        super.onCreated(item);
        this.upsertItem(item);
    }

    public void onUpdated(Item item) {
        if (!GlobalPluginConfiguration.get().isEnabled()) {
            return;
        }
        this.reconfigure();
        super.onUpdated(item);
        this.upsertItem(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDeleted(Item item) {
        WorkflowJob job;
        BuildConfigProjectProperty property;
        if (!GlobalPluginConfiguration.get().isEnabled()) {
            return;
        }
        this.reconfigure();
        super.onDeleted(item);
        if (item instanceof WorkflowJob && (property = this.buildConfigProjectForJob(job = (WorkflowJob)item)) != null) {
            logger.info("Deleting BuildConfig " + property.getNamespace() + "/" + property.getName());
            NamespaceName buildName = OpenShiftUtils.buildConfigNameFromJenkinsJobName(job.getName(), ((BuildConfigProjectProperty)job.getProperty(BuildConfigProjectProperty.class)).getNamespace());
            String namespace = buildName.getNamespace();
            String buildConfigName = buildName.getName();
            BuildConfig buildConfig = (BuildConfig)((BuildConfigResource)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().buildConfigs().inNamespace(namespace)).withName(buildConfigName)).get();
            if (buildConfig != null) {
                try {
                    ((BuildConfigResource)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().buildConfigs().inNamespace(namespace)).withName(buildConfigName)).delete();
                }
                catch (KubernetesClientException e) {
                    if (404 != e.getCode()) {
                        logger.log(Level.WARNING, "Failed to delete BuildConfig in namespace: " + namespace + " for name: " + buildConfigName, e);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to delete BuildConfig in namespace: " + namespace + " for name: " + buildConfigName, e);
                }
                finally {
                    BuildConfigToJobMap.removeJobWithBuildConfig(buildConfig);
                }
            }
        }
    }

    public void upsertItem(Item item) {
        if (item instanceof WorkflowJob) {
            this.upsertWorkflowJob((WorkflowJob)item);
        } else if (item instanceof ItemGroup) {
            this.upsertItemGroup((ItemGroup)item);
        }
    }

    private void upsertItemGroup(ItemGroup itemGroup) {
        Collection items = itemGroup.getItems();
        if (items != null) {
            for (Object child : items) {
                if (child instanceof WorkflowJob) {
                    this.upsertWorkflowJob((WorkflowJob)child);
                    continue;
                }
                if (!(child instanceof ItemGroup)) continue;
                this.upsertItemGroup((ItemGroup)child);
            }
        }
    }

    private void upsertWorkflowJob(WorkflowJob job) {
        BuildConfigProjectProperty property = this.buildConfigProjectForJob(job);
        if (property != null) {
            logger.info("Upsert WorkflowJob " + job.getName() + " to BuildConfig: " + property.getNamespace() + "/" + property.getName() + " in OpenShift");
            this.upsertBuildConfigForJob(job, property);
        }
    }

    private BuildConfigProjectProperty buildConfigProjectForJob(WorkflowJob job) {
        BuildConfigProjectProperty property = (BuildConfigProjectProperty)job.getProperty(BuildConfigProjectProperty.class);
        if (property != null && StringUtils.isNotBlank((String)property.getNamespace()) && StringUtils.isNotBlank((String)property.getName())) {
            logger.info("Found BuildConfigProjectProperty for namespace: " + property.getNamespace() + " name: " + property.getName());
            return property;
        }
        String patternRegex = this.jobNamePattern;
        String jobName = JenkinsUtils.getFullJobName(job);
        if (StringUtils.isNotEmpty((String)jobName) && StringUtils.isNotEmpty((String)patternRegex) && jobName.matches(patternRegex)) {
            String buildConfigName = OpenShiftUtils.convertNameToValidResourceName(JenkinsUtils.getBuildConfigName(job));
            String uuid = null;
            String resourceVersion = null;
            String buildRunPolicy = "Serial";
            int n = 0;
            String[] stringArray = this.namespaces;
            int n2 = stringArray.length;
            if (n < n2) {
                String namespace = stringArray[n];
                logger.info("Creating BuildConfigProjectProperty for namespace: " + namespace + " name: " + buildConfigName);
                if (property != null) {
                    property.setNamespace(namespace);
                    property.setName(buildConfigName);
                    if (!StringUtils.isNotBlank((String)property.getBuildRunPolicy())) {
                        property.setBuildRunPolicy(buildRunPolicy);
                    }
                    return property;
                }
                return new BuildConfigProjectProperty(namespace, buildConfigName, uuid, resourceVersion, buildRunPolicy);
            }
        }
        return null;
    }

    private void upsertBuildConfigForJob(WorkflowJob job, BuildConfigProjectProperty buildConfigProjectProperty) {
        String uid;
        boolean create = false;
        BuildConfig jobBuildConfig = (BuildConfig)((BuildConfigResource)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().buildConfigs().inNamespace(buildConfigProjectProperty.getNamespace())).withName(buildConfigProjectProperty.getName())).get();
        if (jobBuildConfig == null) {
            create = true;
            jobBuildConfig = ((BuildConfigBuilder)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.StrategyNested)((BuildConfigSpecFluent.StrategyNested)((BuildConfigBuilder)((BuildConfigFluent.MetadataNested)((BuildConfigFluent.MetadataNested)((BuildConfigFluent.MetadataNested)new BuildConfigBuilder().withNewMetadata().withName(buildConfigProjectProperty.getName())).withNamespace(buildConfigProjectProperty.getNamespace())).addToAnnotations("jenkins.openshift.io/generated-by", "jenkins")).endMetadata()).withNewSpec().withNewStrategy().withType("JenkinsPipeline")).withNewJenkinsPipelineStrategy().endJenkinsPipelineStrategy()).endStrategy()).endSpec()).build();
        } else {
            ObjectMeta metadata = jobBuildConfig.getMetadata();
            uid = buildConfigProjectProperty.getUid();
            if (metadata != null && StringUtils.isEmpty((String)uid)) {
                buildConfigProjectProperty.setUid(metadata.getUid());
            } else if (metadata != null && !Objects.equal((Object)uid, (Object)metadata.getUid())) {
                return;
            }
        }
        BuildConfigToJobMapper.updateBuildConfigFromJob(job, jobBuildConfig);
        if (!this.hasEmbeddedPipelineOrValidSource(jobBuildConfig)) {
            return;
        }
        if (create) {
            OpenShiftUtils.addAnnotation((HasMetadata)jobBuildConfig, "jenkins.openshift.io/job-path", JenkinsUtils.getFullJobName(job));
        }
        if (create) {
            try {
                BuildConfig bc = (BuildConfig)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().buildConfigs().inNamespace(jobBuildConfig.getMetadata().getNamespace())).create((Object[])new BuildConfig[]{jobBuildConfig});
                uid = bc.getMetadata().getUid();
                buildConfigProjectProperty.setUid(uid);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to create BuildConfig: " + NamespaceName.create((HasMetadata)jobBuildConfig) + ". " + e, e);
            }
        } else {
            try {
                ((EditReplacePatchDeletable)((BuildConfigResource)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().buildConfigs().inNamespace(jobBuildConfig.getMetadata().getNamespace())).withName(jobBuildConfig.getMetadata().getName())).cascading(false)).replace((Object)jobBuildConfig);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to update BuildConfig: " + NamespaceName.create((HasMetadata)jobBuildConfig) + ". " + e, e);
            }
        }
    }

    private boolean hasEmbeddedPipelineOrValidSource(BuildConfig buildConfig) {
        JenkinsPipelineBuildStrategy jenkinsPipelineStrategy;
        BuildStrategy strategy;
        BuildConfigSpec spec = buildConfig.getSpec();
        if (spec != null && (strategy = spec.getStrategy()) != null && (jenkinsPipelineStrategy = strategy.getJenkinsPipelineStrategy()) != null) {
            GitBuildSource git;
            BuildSource source;
            if (StringUtils.isNotBlank((String)jenkinsPipelineStrategy.getJenkinsfile())) {
                return true;
            }
            if (StringUtils.isNotBlank((String)jenkinsPipelineStrategy.getJenkinsfilePath()) && (source = spec.getSource()) != null && (git = source.getGit()) != null && StringUtils.isNotBlank((String)git.getUri())) {
                return true;
            }
        }
        return false;
    }

    private void reconfigure() {
        GlobalPluginConfiguration config = GlobalPluginConfiguration.get();
        if (config != null) {
            this.jobNamePattern = config.getJobNamePattern();
            this.namespaces = config.getNamespace().split(" ");
            this.server = config.getServer();
        }
    }
}

