/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import io.fabric8.jenkins.openshiftsync.BuildConfigProjectProperty;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.openshift.api.model.BuildConfig;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

public class BuildConfigToJobMap {
    private static Map<String, WorkflowJob> buildConfigToJobMap;

    private BuildConfigToJobMap() {
    }

    static synchronized void initializeBuildConfigToJobMap() {
        if (buildConfigToJobMap == null) {
            List jobs = Jenkins.getActiveInstance().getAllItems(WorkflowJob.class);
            buildConfigToJobMap = new ConcurrentHashMap<String, WorkflowJob>(jobs.size());
            for (WorkflowJob job : jobs) {
                String bcUid;
                BuildConfigProjectProperty buildConfigProjectProperty = (BuildConfigProjectProperty)job.getProperty(BuildConfigProjectProperty.class);
                if (buildConfigProjectProperty == null || !StringUtils.isNotBlank((String)(bcUid = buildConfigProjectProperty.getUid()))) continue;
                buildConfigToJobMap.put(bcUid, job);
            }
        }
    }

    static synchronized WorkflowJob getJobFromBuildConfig(BuildConfig buildConfig) {
        ObjectMeta meta = buildConfig.getMetadata();
        if (meta == null) {
            return null;
        }
        return BuildConfigToJobMap.getJobFromBuildConfigUid(meta.getUid());
    }

    static synchronized WorkflowJob getJobFromBuildConfigUid(String uid) {
        if (StringUtils.isBlank((String)uid)) {
            return null;
        }
        return buildConfigToJobMap.get(uid);
    }

    static synchronized void putJobWithBuildConfig(WorkflowJob job, BuildConfig buildConfig) {
        if (buildConfig == null) {
            throw new IllegalArgumentException("BuildConfig cannot be null");
        }
        if (job == null) {
            throw new IllegalArgumentException("Job cannot be null");
        }
        ObjectMeta meta = buildConfig.getMetadata();
        if (meta == null) {
            throw new IllegalArgumentException("BuildConfig must contain valid metadata");
        }
        BuildConfigToJobMap.putJobWithBuildConfigUid(job, meta.getUid());
    }

    static synchronized void putJobWithBuildConfigUid(WorkflowJob job, String uid) {
        if (StringUtils.isBlank((String)uid)) {
            throw new IllegalArgumentException("BuildConfig uid must not be blank");
        }
        buildConfigToJobMap.put(uid, job);
    }

    static synchronized void removeJobWithBuildConfig(BuildConfig buildConfig) {
        if (buildConfig == null) {
            throw new IllegalArgumentException("BuildConfig cannot be null");
        }
        ObjectMeta meta = buildConfig.getMetadata();
        if (meta == null) {
            throw new IllegalArgumentException("BuildConfig must contain valid metadata");
        }
        BuildConfigToJobMap.removeJobWithBuildConfigUid(meta.getUid());
    }

    static synchronized void removeJobWithBuildConfigUid(String uid) {
        if (StringUtils.isBlank((String)uid)) {
            throw new IllegalArgumentException("BuildConfig uid must not be blank");
        }
        buildConfigToJobMap.remove(uid);
    }
}

