/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import jenkins.util.Timer;

public abstract class BaseWatcher {
    private final Logger LOGGER = Logger.getLogger(BaseWatcher.class.getName());
    protected ScheduledFuture relister;
    protected final String[] namespaces;
    protected Map<String, Watch> watches;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public BaseWatcher(String[] namespaces) {
        this.namespaces = namespaces;
        this.watches = new HashMap<String, Watch>();
    }

    public abstract Runnable getStartTimerTask();

    public synchronized void start() {
        Runnable task = this.getStartTimerTask();
        this.relister = Timer.get().scheduleAtFixedRate(task, 100L, 300000L, TimeUnit.MILLISECONDS);
    }

    public synchronized void stop() {
        if (this.relister != null && !this.relister.isDone()) {
            this.relister.cancel(true);
            this.relister = null;
        }
        for (Map.Entry<String, Watch> entry : this.watches.entrySet()) {
            entry.getValue().close();
            this.watches.remove(entry.getKey());
        }
    }

    public synchronized void onClose(KubernetesClientException e) {
        if (e != null) {
            this.LOGGER.warning(e.toString());
            if (e.getStatus() != null && e.getStatus().getCode() == 410) {
                this.stop();
                this.start();
            }
        }
    }

    protected boolean hasSlaveLabelOrAnnotation(Map<String, String> map) {
        if (map != null) {
            return map.containsKey("role") && map.get("role").equals("jenkins-slave");
        }
        return false;
    }
}

