/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.SecretBytes;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.impl.CertificateCredentialsImpl;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.openshift.jenkins.plugins.OpenShiftTokenCredentials;
import hudson.Util;
import hudson.model.Fingerprint;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.remoting.Base64;
import hudson.security.ACL;
import hudson.util.Secret;
import io.fabric8.jenkins.openshiftsync.BuildConfigSecretToCredentialsMap;
import io.fabric8.jenkins.openshiftsync.GlobalPluginConfiguration;
import io.fabric8.jenkins.openshiftsync.NamespaceName;
import io.fabric8.jenkins.openshiftsync.OpenShiftToken;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.BuildConfig;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.plaincredentials.impl.FileCredentialsImpl;
import org.jenkinsci.plugins.plaincredentials.impl.StringCredentialsImpl;

public class CredentialsUtils {
    private static final Logger logger = Logger.getLogger(CredentialsUtils.class.getName());

    public static synchronized io.fabric8.kubernetes.api.model.Secret getSourceCredentials(BuildConfig buildConfig) {
        if (buildConfig.getSpec() != null && buildConfig.getSpec().getSource() != null && buildConfig.getSpec().getSource().getSourceSecret() != null && !buildConfig.getSpec().getSource().getSourceSecret().getName().isEmpty()) {
            io.fabric8.kubernetes.api.model.Secret sourceSecret = (io.fabric8.kubernetes.api.model.Secret)((Resource)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().secrets().inNamespace(buildConfig.getMetadata().getNamespace())).withName(buildConfig.getSpec().getSource().getSourceSecret().getName())).get();
            return sourceSecret;
        }
        return null;
    }

    public static synchronized String updateSourceCredentials(BuildConfig buildConfig) throws IOException {
        io.fabric8.kubernetes.api.model.Secret sourceSecret = CredentialsUtils.getSourceCredentials(buildConfig);
        String credID = null;
        if (sourceSecret != null) {
            credID = CredentialsUtils.upsertCredential(sourceSecret, sourceSecret.getMetadata().getNamespace(), sourceSecret.getMetadata().getName());
            if (credID != null) {
                BuildConfigSecretToCredentialsMap.linkBCSecretToCredential(NamespaceName.create((HasMetadata)buildConfig).toString(), credID);
            }
        } else {
            credID = BuildConfigSecretToCredentialsMap.unlinkBCSecretToCrendential(NamespaceName.create((HasMetadata)buildConfig).toString());
            if (credID != null) {
                CredentialsUtils.deleteCredential(credID, NamespaceName.create((HasMetadata)buildConfig), buildConfig.getMetadata().getResourceVersion());
            }
        }
        return credID;
    }

    public static synchronized void deleteSourceCredentials(BuildConfig buildConfig) throws IOException {
        io.fabric8.kubernetes.api.model.Secret sourceSecret = CredentialsUtils.getSourceCredentials(buildConfig);
        if (sourceSecret != null) {
            boolean watching;
            String labelValue = (String)sourceSecret.getMetadata().getLabels().get("credential.sync.jenkins.openshift.io");
            boolean bl = watching = labelValue != null && labelValue.equalsIgnoreCase("true");
            if (watching) {
                return;
            }
            CredentialsUtils.deleteCredential(sourceSecret);
        }
    }

    private static String getCustomName(io.fabric8.kubernetes.api.model.Secret secret) {
        Map annotations;
        ObjectMeta metadata = secret.getMetadata();
        if (metadata != null && (annotations = metadata.getAnnotations()) != null) {
            return (String)annotations.get("jenkins.openshift.io/secret.name");
        }
        return null;
    }

    public static synchronized String upsertCredential(io.fabric8.kubernetes.api.model.Secret secret) throws IOException {
        ObjectMeta metadata;
        if (secret != null && (metadata = secret.getMetadata()) != null) {
            return CredentialsUtils.upsertCredential(secret, metadata.getNamespace(), metadata.getName());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String upsertCredential(io.fabric8.kubernetes.api.model.Secret secret, String namespace, String secretName) throws IOException {
        String id = null;
        String customSecretName = CredentialsUtils.getCustomName(secret);
        if (secret != null) {
            Credentials creds = CredentialsUtils.secretToCredentials(secret);
            if (creds == null) {
                return null;
            }
            id = CredentialsUtils.secretName(namespace, secretName, customSecretName);
            Credentials existingCreds = CredentialsUtils.lookupCredentials(id);
            SecurityContext previousContext = ACL.impersonate((Authentication)ACL.SYSTEM);
            try {
                CredentialsStore s = (CredentialsStore)CredentialsProvider.lookupStores((ModelObject)Jenkins.getActiveInstance()).iterator().next();
                if (existingCreds != null) {
                    s.updateCredentials(Domain.global(), existingCreds, creds);
                    logger.info("Updated credential " + id + " from Secret " + NamespaceName.create((HasMetadata)secret) + " with revision: " + secret.getMetadata().getResourceVersion());
                } else {
                    s.addCredentials(Domain.global(), creds);
                    logger.info("Created credential " + id + " from Secret " + NamespaceName.create((HasMetadata)secret) + " with revision: " + secret.getMetadata().getResourceVersion());
                }
                s.save();
            }
            finally {
                SecurityContextHolder.setContext((SecurityContext)previousContext);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteCredential(String id, NamespaceName name, String resourceRevision) throws IOException {
        Credentials existingCred = CredentialsUtils.lookupCredentials(id);
        if (existingCred != null) {
            SecurityContext previousContext = ACL.impersonate((Authentication)ACL.SYSTEM);
            try {
                Fingerprint fp = CredentialsProvider.getFingerprintOf((Credentials)existingCred);
                if (fp != null && fp.getJobs().size() > 0) {
                    StringBuffer sb = new StringBuffer();
                    for (String job : fp.getJobs()) {
                        sb.append(job).append(" ");
                    }
                    logger.info("About to delete credential " + id + "which is referenced by jobs: " + sb.toString());
                }
                CredentialsStore s = (CredentialsStore)CredentialsProvider.lookupStores((ModelObject)Jenkins.getActiveInstance()).iterator().next();
                s.removeCredentials(Domain.global(), existingCred);
                logger.info("Deleted credential " + id + " from Secret " + name + " with revision: " + resourceRevision);
                s.save();
            }
            finally {
                SecurityContextHolder.setContext((SecurityContext)previousContext);
            }
        }
    }

    public static void deleteCredential(io.fabric8.kubernetes.api.model.Secret secret) throws IOException {
        if (secret != null) {
            String id = CredentialsUtils.secretName(secret.getMetadata().getNamespace(), secret.getMetadata().getName(), CredentialsUtils.getCustomName(secret));
            CredentialsUtils.deleteCredential(id, NamespaceName.create((HasMetadata)secret), secret.getMetadata().getResourceVersion());
        }
    }

    public static String getCurrentToken() {
        String credentialsId = GlobalPluginConfiguration.get().getCredentialsId();
        if (credentialsId.equals("")) {
            return "";
        }
        OpenShiftToken token = (OpenShiftToken)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(OpenShiftToken.class, (ItemGroup)Jenkins.getActiveInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        if (token != null) {
            return token.getToken();
        }
        return "";
    }

    private static Credentials lookupCredentials(String id) {
        return CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(Credentials.class, (ItemGroup)Jenkins.getActiveInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)id));
    }

    private static String secretName(String namespace, String name, String customName) {
        return customName == null ? namespace + "-" + name : customName;
    }

    private static Credentials arbitraryKeyValueTextCredential(Map<String, String> data, String secretName) {
        String text = "";
        if (data != null && data.size() > 0) {
            try {
                text = new ObjectMapper().writeValueAsString(data);
            }
            catch (JsonProcessingException e) {
                logger.log(Level.WARNING, "Arbitrary opaque secret " + secretName + " had issue converting json", e);
            }
        }
        if (StringUtils.isBlank((String)text)) {
            logger.log(Level.WARNING, "Opaque secret {0} did not provide any data that could be processed into a Jenkins credential", new Object[]{secretName});
            return null;
        }
        return CredentialsUtils.newSecretTextCredential(secretName, new String(Base64.encode((byte[])text.getBytes())));
    }

    private static Credentials secretToCredentials(io.fabric8.kubernetes.api.model.Secret secret) {
        String namespace = secret.getMetadata().getNamespace();
        String name = secret.getMetadata().getName();
        Map data = secret.getData();
        if (data == null) {
            logger.log(Level.WARNING, "An OpenShift secret was marked for import, but it has no secret data.  No credential will be created.");
            return null;
        }
        String secretName = CredentialsUtils.secretName(namespace, name, CredentialsUtils.getCustomName(secret));
        switch (secret.getType()) {
            case "Opaque": {
                String usernameData = (String)data.get("username");
                String passwordData = (String)data.get("password");
                if (StringUtils.isNotBlank((String)usernameData) && StringUtils.isNotBlank((String)passwordData)) {
                    return CredentialsUtils.newUsernamePasswordCredentials(secretName, usernameData, passwordData);
                }
                String sshKeyData = (String)data.get("ssh-privatekey");
                if (StringUtils.isNotBlank((String)sshKeyData)) {
                    return CredentialsUtils.newSSHUserCredential(secretName, (String)data.get("username"), sshKeyData);
                }
                String fileData = (String)data.get("filename");
                if (StringUtils.isNotBlank((String)fileData)) {
                    return CredentialsUtils.newSecretFileCredential(secretName, fileData);
                }
                String certificateDate = (String)data.get("certificate");
                if (StringUtils.isNotBlank((String)certificateDate)) {
                    return CredentialsUtils.newCertificateCredential(secretName, passwordData, certificateDate);
                }
                String secretTextData = (String)data.get("secrettext");
                if (StringUtils.isNotBlank((String)secretTextData)) {
                    return CredentialsUtils.newSecretTextCredential(secretName, secretTextData);
                }
                String openshiftTokenData = (String)data.get("openshift-client-token");
                if (StringUtils.isNotBlank((String)openshiftTokenData)) {
                    return CredentialsUtils.newOpenshiftTokenCredentials(secretName, openshiftTokenData);
                }
                return CredentialsUtils.arbitraryKeyValueTextCredential(data, secretName);
            }
            case "kubernetes.io/basic-auth": {
                return CredentialsUtils.newUsernamePasswordCredentials(secretName, (String)data.get("username"), (String)data.get("password"));
            }
            case "kubernetes.io/ssh-auth": {
                return CredentialsUtils.newSSHUserCredential(secretName, (String)data.get("username"), (String)data.get("ssh-privatekey"));
            }
        }
        return CredentialsUtils.arbitraryKeyValueTextCredential(data, secretName);
    }

    private static Credentials newOpenshiftTokenCredentials(String secretName, String secretText) {
        if (secretName == null || secretName.length() == 0 || secretText == null || secretText.length() == 0) {
            logger.log(Level.WARNING, "Invalid secret data, secretName: " + secretName + " secretText is null: " + (secretText == null) + " secretText is empty: " + (secretText != null ? secretText.length() == 0 : false));
            return null;
        }
        return new OpenShiftTokenCredentials(CredentialsScope.GLOBAL, secretName, secretName, Secret.fromString((String)new String(Base64.decode((String)secretText), StandardCharsets.UTF_8)));
    }

    private static Credentials newSecretFileCredential(String secretName, String fileData) {
        if (secretName == null || secretName.length() == 0 || fileData == null || fileData.length() == 0) {
            logger.log(Level.WARNING, "Invalid secret data, secretName: " + secretName + " filename is null: " + (fileData == null) + " filename is empty: " + (fileData != null ? fileData.length() == 0 : false));
            return null;
        }
        return new FileCredentialsImpl(CredentialsScope.GLOBAL, secretName, secretName, secretName, SecretBytes.fromString((String)fileData));
    }

    private static Credentials newSecretTextCredential(String secretName, String secretText) {
        if (secretName == null || secretName.length() == 0 || secretText == null || secretText.length() == 0) {
            logger.log(Level.WARNING, "Invalid secret data, secretName: " + secretName + " secretText is null: " + (secretText == null) + " secretText is empty: " + (secretText != null ? secretText.length() == 0 : false));
            return null;
        }
        return new StringCredentialsImpl(CredentialsScope.GLOBAL, secretName, secretName, Secret.fromString((String)new String(Base64.decode((String)secretText), StandardCharsets.UTF_8)));
    }

    private static Credentials newCertificateCredential(String secretName, String passwordData, String certificateData) {
        if (secretName == null || secretName.length() == 0 || certificateData == null || certificateData.length() == 0) {
            logger.log(Level.WARNING, "Invalid secret data, secretName: " + secretName + " certificate is null: " + (certificateData == null) + " certificate is empty: " + (certificateData != null ? certificateData.length() == 0 : false));
            return null;
        }
        String certificatePassword = passwordData != null ? new String(Base64.decode((String)passwordData)) : null;
        return new CertificateCredentialsImpl(CredentialsScope.GLOBAL, secretName, secretName, certificatePassword, (CertificateCredentialsImpl.KeyStoreSource)new CertificateCredentialsImpl.UploadedKeyStoreSource(SecretBytes.fromString((String)certificateData)));
    }

    private static Credentials newSSHUserCredential(String secretName, String username, String sshKeyData) {
        if (secretName == null || secretName.length() == 0 || sshKeyData == null || sshKeyData.length() == 0) {
            logger.log(Level.WARNING, "Invalid secret data, secretName: " + secretName + " sshKeyData is null: " + (sshKeyData == null) + " sshKeyData is empty: " + (sshKeyData != null ? sshKeyData.length() == 0 : false));
            return null;
        }
        return new BasicSSHUserPrivateKey(CredentialsScope.GLOBAL, secretName, Util.fixNull((String)username).isEmpty() ? "" : new String(Base64.decode((String)username), StandardCharsets.UTF_8), (BasicSSHUserPrivateKey.PrivateKeySource)new BasicSSHUserPrivateKey.DirectEntryPrivateKeySource(new String(Base64.decode((String)sshKeyData), StandardCharsets.UTF_8)), null, secretName);
    }

    private static Credentials newUsernamePasswordCredentials(String secretName, String usernameData, String passwordData) {
        if (secretName == null || secretName.length() == 0 || usernameData == null || usernameData.length() == 0 || passwordData == null || passwordData.length() == 0) {
            logger.log(Level.WARNING, "Invalid secret data, secretName: " + secretName + " usernameData is null: " + (usernameData == null) + " usernameData is empty: " + (usernameData != null ? usernameData.length() == 0 : false) + " passwordData is null: " + (passwordData == null) + " passwordData is empty: " + (passwordData != null ? passwordData.length() == 0 : false));
            return null;
        }
        return new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, secretName, secretName, new String(Base64.decode((String)usernameData), StandardCharsets.UTF_8), new String(Base64.decode((String)passwordData), StandardCharsets.UTF_8));
    }

    public static boolean hasCredentials() {
        return !StringUtils.isEmpty((String)OpenShiftUtils.getAuthenticatedOpenShiftClient().getConfiguration().getOauthToken());
    }
}

