/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import com.cloudbees.hudson.plugins.folder.Folder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.BulkChange;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.ParameterDefinition;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.remoting.Callable;
import hudson.security.ACL;
import hudson.triggers.SafeTimerTask;
import hudson.util.XStream2;
import io.fabric8.jenkins.openshiftsync.BaseWatcher;
import io.fabric8.jenkins.openshiftsync.BuildConfigProjectProperty;
import io.fabric8.jenkins.openshiftsync.BuildConfigToJobMap;
import io.fabric8.jenkins.openshiftsync.BuildConfigToJobMapper;
import io.fabric8.jenkins.openshiftsync.BuildWatcher;
import io.fabric8.jenkins.openshiftsync.CredentialsUtils;
import io.fabric8.jenkins.openshiftsync.GlobalPluginConfiguration;
import io.fabric8.jenkins.openshiftsync.JenkinsUtils;
import io.fabric8.jenkins.openshiftsync.NamespaceName;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.jenkins.openshiftsync.WatcherCallback;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Watchable;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildList;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.NotReallyRoleSensitiveCallable;
import jenkins.util.Timer;
import org.acegisecurity.Authentication;
import org.apache.tools.ant.filters.StringInputStream;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

public class BuildConfigWatcher
extends BaseWatcher {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final ConcurrentHashSet<String> deletesInProgress = new ConcurrentHashSet();

    public static void deleteInProgress(String bcName) {
        deletesInProgress.add((Object)bcName);
    }

    public static boolean isDeleteInProgress(String bcID) {
        return deletesInProgress.contains((Object)bcID);
    }

    public static void deleteCompleted(String bcID) {
        deletesInProgress.remove((Object)bcID);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public BuildConfigWatcher(String[] namespaces) {
        super(namespaces);
    }

    @Override
    public int getListIntervalInSeconds() {
        return GlobalPluginConfiguration.get().getBuildConfigListInterval();
    }

    @Override
    public Runnable getStartTimerTask() {
        return new SafeTimerTask(){

            public void doRun() {
                if (!CredentialsUtils.hasCredentials()) {
                    BuildConfigWatcher.this.logger.fine("No Openshift Token credential defined.");
                    return;
                }
                for (String namespace : BuildConfigWatcher.this.namespaces) {
                    BuildConfigList buildConfigs = null;
                    try {
                        BuildConfigWatcher.this.logger.fine("listing BuildConfigs resources");
                        buildConfigs = (BuildConfigList)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().buildConfigs().inNamespace(namespace)).list();
                        BuildConfigWatcher.this.onInitialBuildConfigs(buildConfigs);
                        BuildConfigWatcher.this.logger.fine("handled BuildConfigs resources");
                    }
                    catch (Exception e) {
                        BuildConfigWatcher.this.logger.log(Level.SEVERE, "Failed to load BuildConfigs: " + e, e);
                    }
                    try {
                        String resourceVersion = "0";
                        if (buildConfigs == null) {
                            BuildConfigWatcher.this.logger.warning("Unable to get build config list; impacts resource version used for watch");
                        } else {
                            resourceVersion = buildConfigs.getMetadata().getResourceVersion();
                        }
                        if (BuildConfigWatcher.this.watches.get(namespace) != null) continue;
                        BuildConfigWatcher.this.logger.info("creating BuildConfig watch for namespace " + namespace + " and resource version " + resourceVersion);
                        BuildConfigWatcher.this.addWatch(namespace, (Watch)((Watchable)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().buildConfigs().inNamespace(namespace)).withResourceVersion(resourceVersion)).watch(new WatcherCallback(BuildConfigWatcher.this, namespace)));
                    }
                    catch (Exception e) {
                        BuildConfigWatcher.this.logger.log(Level.SEVERE, "Failed to load BuildConfigs: " + e, e);
                    }
                }
                BuildWatcher.flushBuildsWithNoBCList();
            }
        };
    }

    @Override
    public void start() {
        BuildConfigToJobMap.initializeBuildConfigToJobMap();
        this.logger.info("Now handling startup build configs!!");
        super.start();
    }

    private void onInitialBuildConfigs(BuildConfigList buildConfigs) {
        if (buildConfigs == null) {
            return;
        }
        List items = buildConfigs.getItems();
        if (items != null) {
            for (BuildConfig buildConfig : items) {
                try {
                    this.upsertJob(buildConfig);
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "Failed to update job", e);
                }
            }
        }
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"})
    public void eventReceived(final Watcher.Action action, final BuildConfig buildConfig) {
        try {
            switch (action) {
                case ADDED: {
                    this.upsertJob(buildConfig);
                    break;
                }
                case DELETED: {
                    this.deleteEventToJenkinsJob(buildConfig);
                    break;
                }
                case MODIFIED: {
                    this.modifyEventToJenkinsJob(buildConfig);
                    break;
                }
                case ERROR: {
                    this.logger.warning("watch for buildconfig " + buildConfig.getMetadata().getName() + " received error event ");
                    break;
                }
                default: {
                    this.logger.warning("watch for buildconfig " + buildConfig.getMetadata().getName() + " received unknown event " + action);
                }
            }
            ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<Void, Exception>(){

                public Void call() throws Exception {
                    BuildWatcher.flushBuildsWithNoBCList();
                    if (action == Watcher.Action.ADDED) {
                        SafeTimerTask backupBuildQuery = new SafeTimerTask(){

                            public void doRun() {
                                if (!CredentialsUtils.hasCredentials()) {
                                    BuildConfigWatcher.this.logger.fine("No Openshift Token credential defined.");
                                    return;
                                }
                                BuildList buildList = (BuildList)((FilterWatchListDeletable)((FilterWatchListDeletable)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().builds().inNamespace(buildConfig.getMetadata().getNamespace())).withField("status", "New")).withLabel("openshift.io/build-config.name", buildConfig.getMetadata().getName())).list();
                                if (buildList.getItems().size() > 0) {
                                    BuildConfigWatcher.this.logger.info("build backup query for " + buildConfig.getMetadata().getName() + " found new builds");
                                    BuildWatcher.onInitialBuilds(buildList);
                                }
                            }
                        };
                        Timer.get().schedule((Runnable)backupBuildQuery, 10000L, TimeUnit.MILLISECONDS);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Caught: " + e, e);
        }
    }

    @Override
    public <T> void eventReceived(Watcher.Action action, T resource) {
        BuildConfig bc = (BuildConfig)resource;
        this.eventReceived(action, bc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upsertJob(final BuildConfig buildConfig) throws Exception {
        if (OpenShiftUtils.isPipelineStrategyBuildConfig(buildConfig)) {
            String string = buildConfig.getMetadata().getUid().intern();
            synchronized (string) {
                ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<Void, Exception>(){

                    public Void call() throws Exception {
                        boolean newJob;
                        Jenkins activeInstance;
                        String jobName = OpenShiftUtils.jenkinsJobName(buildConfig);
                        String jobFullName = OpenShiftUtils.jenkinsJobFullName(buildConfig);
                        WorkflowJob job = BuildConfigToJobMap.getJobFromBuildConfig(buildConfig);
                        Jenkins parent = activeInstance = Jenkins.getActiveInstance();
                        if (job == null) {
                            job = (WorkflowJob)activeInstance.getItemByFullName(jobFullName);
                        }
                        boolean bl = newJob = job == null;
                        if (newJob) {
                            String disableOn = OpenShiftUtils.getAnnotation((HasMetadata)buildConfig, "jenkins.openshift.io/disable-sync-create");
                            if (disableOn != null && disableOn.length() > 0) {
                                BuildConfigWatcher.this.logger.fine("Not creating missing jenkins job " + jobFullName + " due to annotation: " + "jenkins.openshift.io/disable-sync-create");
                                return null;
                            }
                            parent = OpenShiftUtils.getFullNameParent(activeInstance, jobFullName, OpenShiftUtils.getNamespace((HasMetadata)buildConfig));
                            job = new WorkflowJob((ItemGroup)parent, jobName);
                        }
                        BulkChange bk = new BulkChange((Saveable)job);
                        job.setDisplayName(OpenShiftUtils.jenkinsJobDisplayName(buildConfig));
                        FlowDefinition flowFromBuildConfig = BuildConfigToJobMapper.mapBuildConfigToFlow(buildConfig);
                        if (flowFromBuildConfig == null) {
                            return null;
                        }
                        job.setDefinition(flowFromBuildConfig);
                        String existingBuildRunPolicy = null;
                        BuildConfigProjectProperty buildConfigProjectProperty = (BuildConfigProjectProperty)job.getProperty(BuildConfigProjectProperty.class);
                        if (buildConfigProjectProperty != null) {
                            existingBuildRunPolicy = buildConfigProjectProperty.getBuildRunPolicy();
                            long updatedBCResourceVersion = OpenShiftUtils.parseResourceVersion((HasMetadata)buildConfig);
                            long oldBCResourceVersion = OpenShiftUtils.parseResourceVersion(buildConfigProjectProperty.getResourceVersion());
                            BuildConfigProjectProperty newProperty = new BuildConfigProjectProperty(buildConfig);
                            if (updatedBCResourceVersion <= oldBCResourceVersion && newProperty.getUid().equals(buildConfigProjectProperty.getUid()) && newProperty.getNamespace().equals(buildConfigProjectProperty.getNamespace()) && newProperty.getName().equals(buildConfigProjectProperty.getName()) && newProperty.getBuildRunPolicy().equals(buildConfigProjectProperty.getBuildRunPolicy())) {
                                return null;
                            }
                            buildConfigProjectProperty.setUid(newProperty.getUid());
                            buildConfigProjectProperty.setNamespace(newProperty.getNamespace());
                            buildConfigProjectProperty.setName(newProperty.getName());
                            buildConfigProjectProperty.setResourceVersion(newProperty.getResourceVersion());
                            buildConfigProjectProperty.setBuildRunPolicy(newProperty.getBuildRunPolicy());
                        } else {
                            job.addProperty((JobProperty)new BuildConfigProjectProperty(buildConfig));
                        }
                        Map<String, ParameterDefinition> paramMap = JenkinsUtils.addJobParamForBuildEnvs(job, buildConfig.getSpec().getStrategy().getJenkinsPipelineStrategy(), true);
                        job.setConcurrentBuild(!buildConfig.getSpec().getRunPolicy().equals("Serial") && !buildConfig.getSpec().getRunPolicy().equals("SerialLatestOnly"));
                        StringInputStream jobStream = new StringInputStream(new XStream2().toXML((Object)job));
                        if (newJob) {
                            try {
                                if (parent instanceof Folder) {
                                    Folder folder = (Folder)parent;
                                    folder.createProjectFromXML(jobName, (InputStream)jobStream).save();
                                } else {
                                    activeInstance.createProjectFromXML(jobName, (InputStream)jobStream).save();
                                }
                                BuildConfigWatcher.this.logger.info("Created job " + jobName + " from BuildConfig " + NamespaceName.create((HasMetadata)buildConfig) + " with revision: " + buildConfig.getMetadata().getResourceVersion());
                            }
                            catch (IllegalArgumentException e) {
                                JenkinsUtils.updateJob(job, (InputStream)jobStream, existingBuildRunPolicy, buildConfigProjectProperty);
                                BuildConfigWatcher.this.logger.info("Updated job " + jobName + " from BuildConfig " + NamespaceName.create((HasMetadata)buildConfig) + " with revision: " + buildConfig.getMetadata().getResourceVersion());
                            }
                        } else {
                            JenkinsUtils.updateJob(job, (InputStream)jobStream, existingBuildRunPolicy, buildConfigProjectProperty);
                            BuildConfigWatcher.this.logger.info("Updated job " + jobName + " from BuildConfig " + NamespaceName.create((HasMetadata)buildConfig) + " with revision: " + buildConfig.getMetadata().getResourceVersion());
                        }
                        bk.commit();
                        String fullName = job.getFullName();
                        WorkflowJob workflowJob = (WorkflowJob)activeInstance.getItemByFullName(fullName, WorkflowJob.class);
                        if (workflowJob == null && parent instanceof Folder) {
                            Folder folder = (Folder)parent;
                            folder.add((TopLevelItem)job, jobName);
                            workflowJob = (WorkflowJob)activeInstance.getItemByFullName(fullName, WorkflowJob.class);
                        }
                        if (workflowJob == null) {
                            BuildConfigWatcher.this.logger.warning("Could not find created job " + fullName + " for BuildConfig: " + OpenShiftUtils.getNamespace((HasMetadata)buildConfig) + "/" + OpenShiftUtils.getName((HasMetadata)buildConfig));
                        } else {
                            JenkinsUtils.verifyEnvVars(paramMap, workflowJob, buildConfig);
                            BuildConfigToJobMap.putJobWithBuildConfig(workflowJob, buildConfig);
                        }
                        return null;
                    }
                });
            }
        }
    }

    private void modifyEventToJenkinsJob(BuildConfig buildConfig) throws Exception {
        if (OpenShiftUtils.isPipelineStrategyBuildConfig(buildConfig)) {
            this.upsertJob(buildConfig);
            return;
        }
        this.deleteEventToJenkinsJob(buildConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerDeleteEventToJenkinsJob(final BuildConfig buildConfig) throws Exception {
        WorkflowJob job = BuildConfigToJobMap.getJobFromBuildConfig(buildConfig);
        if (job != null) {
            String string = buildConfig.getMetadata().getUid().intern();
            synchronized (string) {
                ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<Void, Exception>((Job)job){
                    final /* synthetic */ Job val$job;
                    {
                        this.val$job = job;
                    }

                    public Void call() throws Exception {
                        try {
                            BuildConfigWatcher.deleteInProgress(buildConfig.getMetadata().getNamespace() + buildConfig.getMetadata().getName());
                            this.val$job.delete();
                        }
                        finally {
                            BuildConfigToJobMap.removeJobWithBuildConfig(buildConfig);
                            Jenkins.getActiveInstance().rebuildDependencyGraphAsync();
                            BuildConfigWatcher.deleteCompleted(buildConfig.getMetadata().getNamespace() + buildConfig.getMetadata().getName());
                        }
                        return null;
                    }
                });
                CredentialsUtils.deleteSourceCredentials(buildConfig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteEventToJenkinsJob(BuildConfig buildConfig) throws Exception {
        String bcUid = buildConfig.getMetadata().getUid();
        if (bcUid != null && bcUid.length() > 0) {
            String string = bcUid = bcUid.intern();
            synchronized (string) {
                this.innerDeleteEventToJenkinsJob(buildConfig);
                return;
            }
        }
        this.innerDeleteEventToJenkinsJob(buildConfig);
    }
}

