/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.scm.SCM;
import io.fabric8.jenkins.openshiftsync.CredentialsUtils;
import io.fabric8.jenkins.openshiftsync.NamespaceName;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigSpec;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildStrategy;
import io.fabric8.openshift.api.model.GitBuildSource;
import io.fabric8.openshift.api.model.JenkinsPipelineBuildStrategy;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.branch.Branch;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.BranchJobProperty;

public class BuildConfigToJobMapper {
    public static final String JENKINS_PIPELINE_BUILD_STRATEGY = "JenkinsPipeline";
    public static final String DEFAULT_JENKINS_FILEPATH = "Jenkinsfile";
    private static final Logger LOGGER = Logger.getLogger(BuildConfigToJobMapper.class.getName());

    public static FlowDefinition mapBuildConfigToFlow(BuildConfig bc) throws IOException {
        if (!OpenShiftUtils.isPipelineStrategyBuildConfig(bc)) {
            return null;
        }
        BuildConfigSpec spec = bc.getSpec();
        BuildSource source = null;
        String jenkinsfile = null;
        String jenkinsfilePath = null;
        if (spec != null) {
            JenkinsPipelineBuildStrategy jenkinsPipelineStrategy;
            source = spec.getSource();
            BuildStrategy strategy = spec.getStrategy();
            if (strategy != null && (jenkinsPipelineStrategy = strategy.getJenkinsPipelineStrategy()) != null) {
                jenkinsfile = jenkinsPipelineStrategy.getJenkinsfile();
                jenkinsfilePath = jenkinsPipelineStrategy.getJenkinsfilePath();
            }
        }
        if (jenkinsfile == null) {
            if (source != null && source.getGit() != null && source.getGit().getUri() != null) {
                if (jenkinsfilePath == null) {
                    jenkinsfilePath = DEFAULT_JENKINS_FILEPATH;
                }
                if (!StringUtils.isEmpty((String)source.getContextDir())) {
                    jenkinsfilePath = new File(source.getContextDir(), jenkinsfilePath).getPath();
                }
                GitBuildSource gitSource = source.getGit();
                String branchRef = gitSource.getRef();
                List<Object> branchSpecs = Collections.emptyList();
                if (StringUtils.isNotBlank((String)branchRef)) {
                    branchSpecs = Collections.singletonList(new BranchSpec(branchRef));
                }
                String credentialsId = CredentialsUtils.updateSourceCredentials(bc);
                GitSCM scm = new GitSCM(Collections.singletonList(new UserRemoteConfig(gitSource.getUri(), null, null, credentialsId)), branchSpecs, Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
                return new CpsScmFlowDefinition((SCM)scm, jenkinsfilePath);
            }
            LOGGER.warning("BuildConfig does not contain source repository information - cannot map BuildConfig to Jenkins job");
            return null;
        }
        return new CpsFlowDefinition(jenkinsfile, true);
    }

    public static boolean updateBuildConfigFromJob(WorkflowJob job, BuildConfig buildConfig) {
        Branch branch;
        BuildStrategy strategy;
        NamespaceName namespaceName = NamespaceName.create((HasMetadata)buildConfig);
        JenkinsPipelineBuildStrategy jenkinsPipelineStrategy = null;
        BuildConfigSpec spec = buildConfig.getSpec();
        if (spec != null && (strategy = spec.getStrategy()) != null) {
            jenkinsPipelineStrategy = strategy.getJenkinsPipelineStrategy();
        }
        if (jenkinsPipelineStrategy == null) {
            LOGGER.warning("No jenkinsPipelineStrategy available in the BuildConfig " + namespaceName);
            return false;
        }
        FlowDefinition definition = job.getDefinition();
        if (definition instanceof CpsScmFlowDefinition) {
            CpsScmFlowDefinition cpsScmFlowDefinition = (CpsScmFlowDefinition)definition;
            String scriptPath = cpsScmFlowDefinition.getScriptPath();
            if (scriptPath != null && scriptPath.trim().length() > 0) {
                SCM scm;
                boolean rc = false;
                BuildSource source = BuildConfigToJobMapper.getOrCreateBuildSource(spec);
                String bcContextDir = source.getContextDir();
                if (StringUtils.isNotBlank((String)bcContextDir) && scriptPath.startsWith(bcContextDir)) {
                    scriptPath = scriptPath.replaceFirst("^" + bcContextDir + "/?", "");
                }
                if (!scriptPath.equals(jenkinsPipelineStrategy.getJenkinsfilePath())) {
                    LOGGER.log(Level.FINE, "updating bc " + namespaceName + " jenkinsfile path to " + scriptPath + " from ");
                    rc = true;
                    jenkinsPipelineStrategy.setJenkinsfilePath(scriptPath);
                }
                if ((scm = cpsScmFlowDefinition.getScm()) instanceof GitSCM) {
                    BuildConfigToJobMapper.populateFromGitSCM(buildConfig, source, (GitSCM)scm, null);
                    LOGGER.log(Level.FINE, "updating bc " + namespaceName);
                    rc = true;
                }
                return rc;
            }
            return false;
        }
        if (definition instanceof CpsFlowDefinition) {
            CpsFlowDefinition cpsFlowDefinition = (CpsFlowDefinition)definition;
            String jenkinsfile = cpsFlowDefinition.getScript();
            if (jenkinsfile != null && jenkinsfile.trim().length() > 0 && !jenkinsfile.equals(jenkinsPipelineStrategy.getJenkinsfile())) {
                LOGGER.log(Level.FINE, "updating bc " + namespaceName + " jenkinsfile to " + jenkinsfile + " where old jenkinsfile was " + jenkinsPipelineStrategy.getJenkinsfile());
                jenkinsPipelineStrategy.setJenkinsfile(jenkinsfile);
                return true;
            }
            return false;
        }
        BranchJobProperty property = (BranchJobProperty)job.getProperty(BranchJobProperty.class);
        if (property != null && (branch = property.getBranch()) != null) {
            String ref = branch.getName();
            SCM scm = branch.getScm();
            BuildSource source = BuildConfigToJobMapper.getOrCreateBuildSource(spec);
            if (scm instanceof GitSCM && BuildConfigToJobMapper.populateFromGitSCM(buildConfig, source, (GitSCM)scm, ref)) {
                if (StringUtils.isEmpty((String)jenkinsPipelineStrategy.getJenkinsfilePath())) {
                    jenkinsPipelineStrategy.setJenkinsfilePath(DEFAULT_JENKINS_FILEPATH);
                }
                return true;
            }
        }
        LOGGER.warning("Cannot update BuildConfig " + namespaceName + " as the definition is of class " + (definition == null ? "null" : definition.getClass().getName()));
        return false;
    }

    private static boolean populateFromGitSCM(BuildConfig buildConfig, BuildSource source, GitSCM gitSCM, String ref) {
        URIish urIish;
        String gitUrl;
        RemoteConfig remoteConfig;
        List urIs;
        source.setType("Git");
        List repositories = gitSCM.getRepositories();
        if (repositories != null && repositories.size() > 0 && (urIs = (remoteConfig = (RemoteConfig)repositories.get(0)).getURIs()) != null && urIs.size() > 0 && (gitUrl = (urIish = (URIish)urIs.get(0)).toString()) != null && gitUrl.length() > 0) {
            List branches;
            if (StringUtils.isEmpty((String)ref) && (branches = gitSCM.getBranches()) != null && branches.size() > 0) {
                BranchSpec branchSpec = (BranchSpec)branches.get(0);
                String branch = branchSpec.getName();
                while (branch.startsWith("*") || branch.startsWith("/")) {
                    branch = branch.substring(1);
                }
                if (!branch.isEmpty()) {
                    ref = branch;
                }
            }
            OpenShiftUtils.updateGitSourceUrl(buildConfig, gitUrl, ref);
            return true;
        }
        return false;
    }

    private static BuildSource getOrCreateBuildSource(BuildConfigSpec spec) {
        BuildSource source = spec.getSource();
        if (source == null) {
            source = new BuildSource();
            spec.setSource(source);
        }
        return source;
    }
}

