/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import io.fabric8.jenkins.openshiftsync.BuildConfigProjectProperty;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.openshift.api.model.BuildConfig;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

public class BuildConfigToJobMap {
    private static final Logger logger = Logger.getLogger(BuildConfigToJobMap.class.getName());
    private static ConcurrentHashMap<String, WorkflowJob> buildConfigToJobMap;

    private BuildConfigToJobMap() {
    }

    static synchronized void initializeBuildConfigToJobMap() {
        if (buildConfigToJobMap == null) {
            List jobs = Jenkins.getActiveInstance().getAllItems(WorkflowJob.class);
            buildConfigToJobMap = new ConcurrentHashMap(jobs.size());
            for (WorkflowJob job : jobs) {
                BuildConfigProjectProperty buildConfigProjectProperty = (BuildConfigProjectProperty)job.getProperty(BuildConfigProjectProperty.class);
                if (buildConfigProjectProperty == null) continue;
                String namespace = buildConfigProjectProperty.getNamespace();
                String name = buildConfigProjectProperty.getName();
                if (!StringUtils.isNotBlank((String)namespace) || !StringUtils.isNotBlank((String)name)) continue;
                buildConfigToJobMap.put(OpenShiftUtils.jenkinsJobName(namespace, name), job);
            }
        }
    }

    static WorkflowJob getJobFromBuildConfig(BuildConfig buildConfig) {
        ObjectMeta meta = buildConfig.getMetadata();
        if (meta == null) {
            return null;
        }
        return BuildConfigToJobMap.getJobFromBuildConfigNameNamespace(meta.getName(), meta.getNamespace());
    }

    static WorkflowJob getJobFromBuildConfigNameNamespace(String name, String namespace) {
        if (StringUtils.isBlank((String)name) || StringUtils.isBlank((String)namespace)) {
            return null;
        }
        return buildConfigToJobMap.get(OpenShiftUtils.jenkinsJobName(namespace, name));
    }

    static void putJobWithBuildConfig(WorkflowJob job, BuildConfig buildConfig) {
        if (buildConfig == null) {
            throw new IllegalArgumentException("BuildConfig cannot be null");
        }
        if (job == null) {
            throw new IllegalArgumentException("Job cannot be null");
        }
        ObjectMeta meta = buildConfig.getMetadata();
        if (meta == null) {
            throw new IllegalArgumentException("BuildConfig must contain valid metadata");
        }
        BuildConfigToJobMap.putJobWithBuildConfigNameNamespace(job, meta.getName(), meta.getNamespace());
    }

    static void putJobWithBuildConfigNameNamespace(WorkflowJob job, String name, String namespace) {
        if (StringUtils.isBlank((String)name) || StringUtils.isBlank((String)namespace)) {
            throw new IllegalArgumentException("BuildConfig name and namespace must not be blank");
        }
        buildConfigToJobMap.put(OpenShiftUtils.jenkinsJobName(namespace, name), job);
    }

    static void removeJobWithBuildConfig(BuildConfig buildConfig) {
        if (buildConfig == null) {
            throw new IllegalArgumentException("BuildConfig cannot be null");
        }
        ObjectMeta meta = buildConfig.getMetadata();
        if (meta == null) {
            throw new IllegalArgumentException("BuildConfig must contain valid metadata");
        }
        BuildConfigToJobMap.removeJobWithBuildConfigNameNamespace(meta.getName(), meta.getNamespace());
    }

    static void removeJobWithBuildConfigNameNamespace(String name, String namespace) {
        if (StringUtils.isBlank((String)name) || StringUtils.isBlank((String)namespace)) {
            throw new IllegalArgumentException("BuildConfig name/namepsace must not be blank");
        }
        buildConfigToJobMap.remove(OpenShiftUtils.jenkinsJobName(namespace, name));
    }
}

