/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.triggers.SafeTimerTask;
import io.fabric8.jenkins.openshiftsync.BaseWatcher;
import io.fabric8.jenkins.openshiftsync.CredentialsUtils;
import io.fabric8.jenkins.openshiftsync.GlobalPluginConfiguration;
import io.fabric8.jenkins.openshiftsync.JenkinsUtils;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.jenkins.openshiftsync.WatcherCallback;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.Watchable;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamList;
import io.fabric8.openshift.api.model.ImageStreamTag;
import io.fabric8.openshift.api.model.TagReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;

public class ImageStreamWatcher
extends BaseWatcher {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final List<String> predefinedOpenShiftSlaves = new ArrayList<String>();

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ImageStreamWatcher(String[] namespaces) {
        super(namespaces);
        this.predefinedOpenShiftSlaves.add("maven");
        this.predefinedOpenShiftSlaves.add("nodejs");
    }

    @Override
    public int getListIntervalInSeconds() {
        return GlobalPluginConfiguration.get().getImageStreamListInterval();
    }

    @Override
    public Runnable getStartTimerTask() {
        return new SafeTimerTask(){

            public void doRun() {
                if (!CredentialsUtils.hasCredentials()) {
                    ImageStreamWatcher.this.logger.fine("No Openshift Token credential defined.");
                    return;
                }
                for (String namespace : ImageStreamWatcher.this.namespaces) {
                    ImageStreamList imageStreams = null;
                    try {
                        ImageStreamWatcher.this.logger.fine("listing ImageStream resources");
                        imageStreams = (ImageStreamList)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().imageStreams().inNamespace(namespace)).list();
                        ImageStreamWatcher.this.onInitialImageStream(imageStreams);
                        ImageStreamWatcher.this.logger.fine("handled ImageStream resources");
                    }
                    catch (Exception e) {
                        ImageStreamWatcher.this.logger.log(Level.SEVERE, "Failed to load ImageStreams: " + e, e);
                    }
                    try {
                        String resourceVersion = "0";
                        if (imageStreams == null) {
                            ImageStreamWatcher.this.logger.warning("Unable to get image stream list; impacts resource version used for watch");
                        } else {
                            resourceVersion = imageStreams.getMetadata().getResourceVersion();
                        }
                        if (ImageStreamWatcher.this.watches.get(namespace) != null) continue;
                        ImageStreamWatcher.this.logger.info("creating ImageStream watch for namespace " + namespace + " and resource version " + resourceVersion);
                        ImageStreamWatcher.this.addWatch(namespace, (Watch)((Watchable)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().imageStreams().inNamespace(namespace)).withResourceVersion(resourceVersion)).watch(new WatcherCallback(ImageStreamWatcher.this, namespace)));
                    }
                    catch (Exception e) {
                        ImageStreamWatcher.this.logger.log(Level.SEVERE, "Failed to load ImageStreams: " + e, e);
                    }
                }
            }
        };
    }

    @Override
    public void start() {
        this.logger.info("Now handling startup image streams!!");
        super.start();
    }

    public void eventReceived(Watcher.Action action, ImageStream imageStream) {
        try {
            List<PodTemplate> slavesFromIS = this.podTemplates(imageStream);
            String isname = imageStream.getMetadata().getName();
            switch (action) {
                case ADDED: {
                    for (PodTemplate entry : slavesFromIS) {
                        if (JenkinsUtils.hasPodTemplate(entry) || this.predefinedOpenShiftSlaves.contains(entry.getName())) continue;
                        JenkinsUtils.addPodTemplate(entry);
                    }
                    break;
                }
                case MODIFIED: {
                    for (PodTemplate entry : slavesFromIS) {
                        if (this.predefinedOpenShiftSlaves.contains(entry.getName()) || JenkinsUtils.hasPodTemplate(entry)) continue;
                        JenkinsUtils.addPodTemplate(entry);
                    }
                    for (PodTemplate podTemplate : JenkinsUtils.getPodTemplates()) {
                        if (!podTemplate.getName().equals(isname) && !podTemplate.getName().startsWith(isname + ".") || this.predefinedOpenShiftSlaves.contains(podTemplate.getName())) continue;
                        boolean keep = false;
                        for (PodTemplate entry : slavesFromIS) {
                            if (!entry.getName().equals(podTemplate.getName())) continue;
                            keep = true;
                            break;
                        }
                        if (keep) continue;
                        JenkinsUtils.removePodTemplate(podTemplate);
                    }
                    break;
                }
                case DELETED: {
                    for (PodTemplate podTemplate : JenkinsUtils.getPodTemplates()) {
                        if (!podTemplate.getName().equals(isname) && !podTemplate.getName().startsWith(isname + ".") || this.predefinedOpenShiftSlaves.contains(podTemplate.getName())) continue;
                        JenkinsUtils.removePodTemplate(podTemplate);
                    }
                    break;
                }
                case ERROR: {
                    this.logger.warning("watch for imageStream " + imageStream.getMetadata().getName() + " received error event ");
                    break;
                }
                default: {
                    this.logger.warning("watch for imageStream " + imageStream.getMetadata().getName() + " received unknown event " + action);
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Caught: " + e, e);
        }
    }

    @Override
    public <T> void eventReceived(Watcher.Action action, T resource) {
        ImageStream imageStream = (ImageStream)resource;
        this.eventReceived(action, imageStream);
    }

    private synchronized void onInitialImageStream(ImageStreamList imageStreams) {
        if (imageStreams == null) {
            return;
        }
        List items = imageStreams.getItems();
        if (items != null) {
            for (ImageStream imageStream : items) {
                try {
                    List<PodTemplate> slavesFromIS = this.podTemplates(imageStream);
                    for (PodTemplate entry : slavesFromIS) {
                        if (JenkinsUtils.hasPodTemplate(entry)) continue;
                        JenkinsUtils.addPodTemplate(entry);
                    }
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "Failed to update job", e);
                }
            }
        }
    }

    private List<PodTemplate> podTemplates(ImageStream imageStream) {
        ArrayList<PodTemplate> results = new ArrayList<PodTemplate>();
        if (this.hasSlaveLabelOrAnnotation(imageStream.getMetadata().getLabels())) {
            results.add(this.podTemplateFromData(imageStream.getMetadata().getName(), imageStream.getStatus().getDockerImageRepository(), imageStream.getMetadata().getAnnotations()));
        }
        String namespace = imageStream.getMetadata().getNamespace();
        for (TagReference tagRef : imageStream.getSpec().getTags()) {
            ImageStreamTag ist = null;
            try {
                ist = (ImageStreamTag)((Resource)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().imageStreamTags().inNamespace(namespace)).withName(imageStream.getMetadata().getName() + ":" + tagRef.getName())).get();
            }
            catch (Throwable t) {
                this.logger.log(Level.FINE, "podTemplates", t);
            }
            if (ist == null || !this.hasSlaveLabelOrAnnotation(ist.getMetadata().getAnnotations())) continue;
            results.add(this.podTemplateFromData(ist.getMetadata().getName().replaceAll(":", "."), ist.getImage().getDockerImageReference(), ist.getMetadata().getAnnotations()));
        }
        return results;
    }

    private PodTemplate podTemplateFromData(String name, String image, Map<String, String> map) {
        String label = null;
        label = map != null && map.containsKey("slave-label") ? map.get("slave-label") : name;
        PodTemplate result = JenkinsUtils.podTemplateInit(name, image, label);
        return result;
    }
}

