/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.Callable;
import hudson.security.ACL;
import hudson.triggers.SafeTimerTask;
import io.fabric8.jenkins.openshiftsync.BaseWatcher;
import io.fabric8.jenkins.openshiftsync.BuildCause;
import io.fabric8.jenkins.openshiftsync.BuildConfigProjectProperty;
import io.fabric8.jenkins.openshiftsync.BuildConfigToJobMap;
import io.fabric8.jenkins.openshiftsync.BuildToActionMapper;
import io.fabric8.jenkins.openshiftsync.CredentialsUtils;
import io.fabric8.jenkins.openshiftsync.GlobalPluginConfiguration;
import io.fabric8.jenkins.openshiftsync.JenkinsUtils;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.jenkins.openshiftsync.WatcherCallback;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Watchable;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.BuildStatus;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.NotReallyRoleSensitiveCallable;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class BuildWatcher
extends BaseWatcher {
    private static final Logger logger = Logger.getLogger(BuildWatcher.class.getName());
    private static final ConcurrentHashMap<String, Build> buildsWithNoBCList = new ConcurrentHashMap();

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public BuildWatcher(String[] namespaces) {
        super(namespaces);
    }

    @Override
    public int getListIntervalInSeconds() {
        return GlobalPluginConfiguration.get().getBuildListInterval();
    }

    @Override
    public Runnable getStartTimerTask() {
        return new SafeTimerTask(){

            public void doRun() {
                if (!CredentialsUtils.hasCredentials()) {
                    logger.fine("No Openshift Token credential defined.");
                    return;
                }
                BuildWatcher.flushBuildsWithNoBCList();
                for (String namespace : BuildWatcher.this.namespaces) {
                    BuildList newBuilds = null;
                    try {
                        logger.fine("listing Build resources");
                        newBuilds = (BuildList)((FilterWatchListDeletable)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().builds().inNamespace(namespace)).withField("status", "New")).list();
                        BuildWatcher.onInitialBuilds(newBuilds);
                        logger.fine("handled Build resources");
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to load initial Builds: " + e, e);
                    }
                    try {
                        String resourceVersion = "0";
                        if (newBuilds == null) {
                            logger.warning("Unable to get build list; impacts resource version used for watch");
                        } else {
                            resourceVersion = newBuilds.getMetadata().getResourceVersion();
                        }
                        if (BuildWatcher.this.watches.get(namespace) != null) continue;
                        logger.info("creating Build watch for namespace " + namespace + " and resource version " + resourceVersion);
                        BuildWatcher.this.addWatch(namespace, (Watch)((Watchable)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().builds().inNamespace(namespace)).withResourceVersion(resourceVersion)).watch(new WatcherCallback(BuildWatcher.this, namespace)));
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to load initial Builds: " + e, e);
                    }
                }
                BuildWatcher.reconcileRunsAndBuilds();
            }
        };
    }

    @Override
    public void start() {
        BuildToActionMapper.initialize();
        super.start();
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"})
    public void eventReceived(Watcher.Action action, Build build) {
        if (!OpenShiftUtils.isPipelineStrategyBuild(build)) {
            return;
        }
        try {
            switch (action) {
                case ADDED: {
                    BuildWatcher.addEventToJenkinsJobRun(build);
                    break;
                }
                case MODIFIED: {
                    BuildWatcher.modifyEventToJenkinsJobRun(build);
                    break;
                }
                case DELETED: {
                    BuildWatcher.deleteEventToJenkinsJobRun(build);
                    break;
                }
                case ERROR: {
                    logger.warning("watch for build " + build.getMetadata().getName() + " received error event ");
                    break;
                }
                default: {
                    logger.warning("watch for build " + build.getMetadata().getName() + " received unknown event " + action);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Caught: " + e, e);
        }
    }

    @Override
    public <T> void eventReceived(Watcher.Action action, T resource) {
        Build build = (Build)resource;
        this.eventReceived(action, build);
    }

    public static void onInitialBuilds(BuildList buildList) {
        if (buildList == null) {
            return;
        }
        List items = buildList.getItems();
        if (items != null) {
            Collections.sort(items, new Comparator<Build>(){

                @Override
                public int compare(Build b1, Build b2) {
                    if (b1.getMetadata().getAnnotations() == null || b1.getMetadata().getAnnotations().get("openshift.io/build.number") == null) {
                        logger.warning("cannot compare build " + b1.getMetadata().getName() + " from namespace " + b1.getMetadata().getNamespace() + ", has bad annotations: " + b1.getMetadata().getAnnotations());
                        return 0;
                    }
                    if (b2.getMetadata().getAnnotations() == null || b2.getMetadata().getAnnotations().get("openshift.io/build.number") == null) {
                        logger.warning("cannot compare build " + b2.getMetadata().getName() + " from namespace " + b2.getMetadata().getNamespace() + ", has bad annotations: " + b2.getMetadata().getAnnotations());
                        return 0;
                    }
                    int rc = 0;
                    try {
                        rc = Long.compare(Long.parseLong((String)b1.getMetadata().getAnnotations().get("openshift.io/build.number")), Long.parseLong((String)b2.getMetadata().getAnnotations().get("openshift.io/build.number")));
                    }
                    catch (Throwable t) {
                        logger.log(Level.FINE, "onInitialBuilds", t);
                    }
                    return rc;
                }
            });
            HashMap<String, BuildConfig> buildConfigMap = new HashMap<String, BuildConfig>();
            HashMap<BuildConfig, ArrayList<Build>> buildConfigBuildMap = new HashMap<BuildConfig, ArrayList<Build>>(items.size());
            for (Build build : items) {
                ArrayList<Build> bcBuilds;
                String buildConfigName;
                if (!OpenShiftUtils.isPipelineStrategyBuild(build) || StringUtils.isEmpty((String)(buildConfigName = build.getStatus().getConfig().getName()))) continue;
                String namespace = build.getMetadata().getNamespace();
                String bcMapKey = namespace + "/" + buildConfigName;
                BuildConfig bc = (BuildConfig)buildConfigMap.get(bcMapKey);
                if (bc == null) {
                    bc = (BuildConfig)((BuildConfigResource)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().buildConfigs().inNamespace(namespace)).withName(buildConfigName)).get();
                    if (bc == null) continue;
                    buildConfigMap.put(bcMapKey, bc);
                }
                if ((bcBuilds = (ArrayList<Build>)buildConfigBuildMap.get(bc)) == null) {
                    bcBuilds = new ArrayList<Build>();
                    buildConfigBuildMap.put(bc, bcBuilds);
                }
                bcBuilds.add(build);
            }
            for (Map.Entry entry : buildConfigBuildMap.entrySet()) {
                List builds;
                BuildConfig bc = (BuildConfig)entry.getKey();
                if (bc.getMetadata() == null) continue;
                WorkflowJob job = BuildConfigToJobMap.getJobFromBuildConfig(bc);
                if (job == null) {
                    List builds2 = (List)entry.getValue();
                    for (Build b : builds2) {
                        logger.info("skipping listed new build " + b.getMetadata().getName() + " no job at this time");
                        BuildWatcher.addBuildToNoBCList(b);
                    }
                    continue;
                }
                BuildConfigProjectProperty bcp = (BuildConfigProjectProperty)job.getProperty(BuildConfigProjectProperty.class);
                if (bcp == null) {
                    builds = (List)entry.getValue();
                    for (Build b : builds) {
                        logger.info("skipping listed new build " + b.getMetadata().getName() + " no prop at this time");
                        BuildWatcher.addBuildToNoBCList(b);
                    }
                    continue;
                }
                builds = (List)entry.getValue();
                JenkinsUtils.handleBuildList(job, builds, bcp);
            }
        }
    }

    private static void modifyEventToJenkinsJobRun(Build build) {
        BuildStatus status = build.getStatus();
        if (status != null && OpenShiftUtils.isCancellable(status) && OpenShiftUtils.isCancelled(status)) {
            WorkflowJob job = JenkinsUtils.getJobFromBuild(build);
            if (job != null) {
                JenkinsUtils.cancelBuild(job, build);
            } else {
                BuildWatcher.removeBuildFromNoBCList(build);
            }
        } else {
            BuildWatcher.flushBuildsWithNoBCList();
        }
    }

    public static boolean addEventToJenkinsJobRun(Build build) throws IOException {
        WorkflowJob job;
        if (!OpenShiftUtils.isPipelineStrategyBuild(build)) {
            return false;
        }
        BuildStatus status = build.getStatus();
        if (status != null) {
            if (OpenShiftUtils.isCancelled(status)) {
                OpenShiftUtils.updateOpenShiftBuildPhase(build, "Cancelled");
                return false;
            }
            if (!OpenShiftUtils.isNew(status)) {
                return false;
            }
        }
        if ((job = JenkinsUtils.getJobFromBuild(build)) != null) {
            return JenkinsUtils.triggerJob(job, build);
        }
        logger.info("skipping watch event for build " + build.getMetadata().getName() + " no job at this time");
        BuildWatcher.addBuildToNoBCList(build);
        return false;
    }

    private static void addBuildToNoBCList(Build build) {
        if (!OpenShiftUtils.isPipelineStrategyBuild(build)) {
            return;
        }
        try {
            buildsWithNoBCList.put(build.getMetadata().getNamespace() + build.getMetadata().getName(), build);
        }
        catch (IllegalArgumentException | NullPointerException | UnsupportedOperationException | ConcurrentModificationException e) {
            logger.log(Level.WARNING, "Failed to add item " + build.getMetadata().getName(), e);
        }
    }

    private static void removeBuildFromNoBCList(Build build) {
        buildsWithNoBCList.remove(build.getMetadata().getNamespace() + build.getMetadata().getName());
    }

    public static synchronized void flushBuildsWithNoBCList() {
        boolean anyRemoveFailures = false;
        for (Build build : buildsWithNoBCList.values()) {
            WorkflowJob job = JenkinsUtils.getJobFromBuild(build);
            if (job == null) continue;
            try {
                logger.info("triggering job run for previously skipped build " + build.getMetadata().getName());
                JenkinsUtils.triggerJob(job, build);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "flushBuildsWithNoBCList", e);
            }
            try {
                BuildWatcher.removeBuildFromNoBCList(build);
            }
            catch (Throwable t) {
                anyRemoveFailures = true;
                logger.log(Level.WARNING, "flushBuildsWithNoBCList", t);
            }
        }
        if (anyRemoveFailures && buildsWithNoBCList.size() > 0) {
            buildsWithNoBCList.clear();
        }
    }

    private static void innerDeleteEventToJenkinsJobRun(final Build build) throws Exception {
        final WorkflowJob job = JenkinsUtils.getJobFromBuild(build);
        if (job != null) {
            ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<Void, Exception>(){

                public Void call() throws Exception {
                    JenkinsUtils.cancelBuild(job, build, true);
                    return null;
                }
            });
        } else {
            BuildWatcher.removeBuildFromNoBCList(build);
        }
        JenkinsUtils.deleteRun(job, build);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteEventToJenkinsJobRun(Build build) throws Exception {
        List ownerRefs = build.getMetadata().getOwnerReferences();
        String bcUid = null;
        for (OwnerReference ref : ownerRefs) {
            if (!"BuildConfig".equals(ref.getKind()) || ref.getUid() == null || ref.getUid().length() <= 0) continue;
            String string = bcUid = ref.getUid().intern();
            synchronized (string) {
                if (BuildConfigToJobMap.getJobFromBuildConfigNameNamespace(OpenShiftUtils.getAnnotation((HasMetadata)build, "openshift.io/build-config.name"), build.getMetadata().getNamespace()) == null) {
                    return;
                }
                BuildWatcher.innerDeleteEventToJenkinsJobRun(build);
                return;
            }
        }
        BuildWatcher.innerDeleteEventToJenkinsJobRun(build);
    }

    private static void reconcileRunsAndBuilds() {
        logger.info("Reconciling job runs and builds");
        List jobs = Jenkins.getActiveInstance().getAllItems(WorkflowJob.class);
        for (WorkflowJob job : jobs) {
            BuildConfigProjectProperty property = (BuildConfigProjectProperty)job.getProperty(BuildConfigProjectProperty.class);
            if (property == null || StringUtils.isBlank((String)property.getNamespace()) || StringUtils.isBlank((String)property.getName())) continue;
            logger.info("Checking job " + job.toString() + " runs for BuildConfig " + property.getNamespace() + "/" + property.getName());
            BuildList buildList = (BuildList)((FilterWatchListDeletable)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().builds().inNamespace(property.getNamespace())).withLabel("buildconfig=" + property.getName())).list();
            for (WorkflowRun run : job.getBuilds()) {
                boolean found = false;
                BuildCause cause = (BuildCause)run.getCause(BuildCause.class);
                for (Build build : buildList.getItems()) {
                    if (cause == null || !cause.getUid().equals(build.getMetadata().getUid())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                JenkinsUtils.deleteRun(run);
            }
        }
    }
}

