/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import jenkins.util.Timer;

public abstract class BaseWatcher {
    private final Logger LOGGER = Logger.getLogger(BaseWatcher.class.getName());
    protected ScheduledFuture relister;
    protected final String[] namespaces;
    protected ConcurrentHashMap<String, Watch> watches;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public BaseWatcher(String[] namespaces) {
        this.namespaces = namespaces;
        this.watches = new ConcurrentHashMap();
    }

    public abstract Runnable getStartTimerTask();

    public abstract int getListIntervalInSeconds();

    public abstract <T> void eventReceived(Watcher.Action var1, T var2);

    public synchronized void start() {
        Runnable task = this.getStartTimerTask();
        this.relister = Timer.get().scheduleAtFixedRate(task, 100L, this.getListIntervalInSeconds() * 1000, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.relister != null && !this.relister.isDone()) {
            this.relister.cancel(true);
            this.relister = null;
        }
        for (Map.Entry<String, Watch> entry : this.watches.entrySet()) {
            entry.getValue().close();
            this.watches.remove(entry.getKey());
        }
    }

    public void onClose(KubernetesClientException e, String namespace) {
        this.LOGGER.info("Watch for type " + this.getClass().getName() + " closed for one of the following namespaces: " + ((ConcurrentHashMap.CollectionView)((Object)this.watches.keySet())).toString());
        if (e != null) {
            this.LOGGER.warning(e.toString());
            if (e.getStatus() != null && e.getStatus().getCode() == 410) {
                this.stop();
                this.start();
            }
        }
        this.watches.remove(namespace);
    }

    protected boolean hasSlaveLabelOrAnnotation(Map<String, String> map) {
        if (map != null) {
            return map.containsKey("role") && map.get("role").equals("jenkins-slave");
        }
        return false;
    }

    public void addWatch(String key, Watch desiredWatch) {
        Watch watch = this.watches.putIfAbsent(key, desiredWatch);
        if (watch != null) {
            watch.close();
        }
    }
}

