/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.watcher;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import io.alauda.devops.client.AlaudaDevOpsClient;
import io.alauda.jenkins.devops.sync.AlaudaSyncGlobalConfiguration;
import io.alauda.jenkins.devops.sync.WatcherCallback;
import io.alauda.jenkins.devops.sync.util.AlaudaUtils;
import io.alauda.jenkins.devops.sync.util.CredentialsUtils;
import io.alauda.jenkins.devops.sync.watcher.AbstractWatcher;
import io.alauda.jenkins.devops.sync.watcher.BaseWatcher;
import io.alauda.jenkins.devops.sync.watcher.ResourcesCache;
import io.alauda.kubernetes.api.model.ObjectMeta;
import io.alauda.kubernetes.api.model.Secret;
import io.alauda.kubernetes.api.model.SecretList;
import io.alauda.kubernetes.client.Watch;
import io.alauda.kubernetes.client.Watcher;
import io.alauda.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.alauda.kubernetes.client.dsl.Watchable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension
public class SecretWatcher
extends AbstractWatcher
implements BaseWatcher {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private Set<String> namespaceSet;
    private Map<String, String> trackedSecrets;
    private WatcherCallback<Secret> watcherCallback;

    @Override
    public void watch() {
        AlaudaDevOpsClient client = AlaudaUtils.getAuthenticatedAlaudaClient();
        if (client == null) {
            this.stop();
            this.logger.severe("client is null, when watch Secret");
            return;
        }
        String resourceVersion = "0";
        SecretList secrets = (SecretList)((FilterWatchListMultiDeletable)client.secrets().inAnyNamespace()).list();
        if (secrets != null) {
            resourceVersion = secrets.getMetadata().getResourceVersion();
        }
        this.watcherCallback = new WatcherCallback(this, null);
        this.setWatcher((Watch)((Watchable)((FilterWatchListMultiDeletable)client.secrets().inAnyNamespace()).withResourceVersion(resourceVersion)).watch(this.watcherCallback));
    }

    @Override
    public WatcherCallback getWatcherCallback() {
        return this.watcherCallback;
    }

    @Override
    public void init(String[] namespaces) {
        AlaudaDevOpsClient client;
        if (this.trackedSecrets == null) {
            this.trackedSecrets = new ConcurrentHashMap<String, String>();
        }
        if ((client = AlaudaUtils.getAuthenticatedAlaudaClient()) == null) {
            return;
        }
        SecretList secrets = (SecretList)((FilterWatchListMultiDeletable)client.secrets().inAnyNamespace()).list();
        if (secrets == null || secrets.getItems() == null) {
            return;
        }
        this.namespaceSet = new HashSet<String>(Arrays.asList(namespaces));
        this.namespaceSet.add(AlaudaSyncGlobalConfiguration.get().getSharedNamespace());
        secrets.getItems().stream().filter(item -> {
            String ns = item.getMetadata().getNamespace();
            return this.namespaceSet.contains(ns);
        }).forEach(secret -> {
            try {
                if (this.validSecret((Secret)secret) && this.shouldProcessSecret((Secret)secret)) {
                    this.upsertCredential((Secret)secret);
                    this.trackedSecrets.put(secret.getMetadata().getUid(), secret.getMetadata().getResourceVersion());
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to update job", e);
            }
        });
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"})
    public synchronized void eventReceived(Watcher.Action action, Secret secret) {
        this.logger.log(Level.FINE, "Got secret event", action);
        this.logger.log(Level.FINE, "Got secret object", secret);
        if (!this.validSecret(secret)) {
            this.logger.log(Level.WARNING, "Got invalid secret object", secret);
            return;
        }
        if (!ResourcesCache.getInstance().isBinding(secret)) {
            this.logger.log(Level.WARNING, "Secret is not in namespace list", secret);
            return;
        }
        try {
            switch (action) {
                case ADDED: {
                    this.upsertCredential(secret);
                    break;
                }
                case DELETED: {
                    this.deleteCredential(secret);
                    break;
                }
                case MODIFIED: {
                    this.modifyCredential(secret);
                    break;
                }
                case ERROR: {
                    this.logger.warning("watch for secret " + secret.getMetadata().getName() + " received error event ");
                    break;
                }
                default: {
                    this.logger.warning("watch for secret " + secret.getMetadata().getName() + " received unknown event " + action);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Caught: " + e, e);
        }
    }

    @Override
    public <T> void eventReceived(Watcher.Action action, T resource) {
        Secret secret = (Secret)resource;
        this.eventReceived(action, secret);
    }

    private void upsertCredential(Secret secret) throws Exception {
        if (this.validSecret(secret)) {
            CredentialsUtils.upsertCredential(secret);
            this.trackedSecrets.put(secret.getMetadata().getUid(), secret.getMetadata().getResourceVersion());
        }
    }

    private void modifyCredential(Secret secret) throws Exception {
        if (this.validSecret(secret) && this.shouldProcessSecret(secret)) {
            CredentialsUtils.upsertCredential(secret);
            this.trackedSecrets.put(secret.getMetadata().getUid(), secret.getMetadata().getResourceVersion());
        }
    }

    private boolean validSecret(Secret secret) {
        if (secret == null) {
            return false;
        }
        ObjectMeta metadata = secret.getMetadata();
        if (metadata != null) {
            String name = metadata.getName();
            String namespace = metadata.getNamespace();
            return name != null && !name.isEmpty() && namespace != null && !namespace.isEmpty();
        }
        return false;
    }

    private boolean shouldProcessSecret(Secret secret) {
        String uid = secret.getMetadata().getUid();
        String rv = secret.getMetadata().getResourceVersion();
        String savedRV = this.trackedSecrets.get(uid);
        return savedRV == null || !savedRV.equals(rv);
    }

    private void deleteCredential(Secret secret) throws Exception {
        this.trackedSecrets.remove(secret.getMetadata().getUid());
        CredentialsUtils.deleteCredential(secret);
    }

    @Override
    public final String getName() {
        return "SecretWatcher";
    }
}

