/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.watcher;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.remoting.Callable;
import hudson.security.ACL;
import io.alauda.devops.client.AlaudaDevOpsClient;
import io.alauda.devops.client.dsl.PipelineConfigResource;
import io.alauda.jenkins.devops.sync.JenkinsPipelineCause;
import io.alauda.jenkins.devops.sync.PipelineConfigProjectProperty;
import io.alauda.jenkins.devops.sync.PipelineNumComparator;
import io.alauda.jenkins.devops.sync.WatcherCallback;
import io.alauda.jenkins.devops.sync.util.AlaudaUtils;
import io.alauda.jenkins.devops.sync.util.JenkinsUtils;
import io.alauda.jenkins.devops.sync.util.PipelineConfigToJobMap;
import io.alauda.jenkins.devops.sync.watcher.AbstractWatcher;
import io.alauda.jenkins.devops.sync.watcher.BaseWatcher;
import io.alauda.jenkins.devops.sync.watcher.ResourcesCache;
import io.alauda.kubernetes.api.model.OwnerReference;
import io.alauda.kubernetes.api.model.Pipeline;
import io.alauda.kubernetes.api.model.PipelineConfig;
import io.alauda.kubernetes.api.model.PipelineList;
import io.alauda.kubernetes.api.model.PipelineStatus;
import io.alauda.kubernetes.client.Watch;
import io.alauda.kubernetes.client.Watcher;
import io.alauda.kubernetes.client.dsl.FilterWatchListDeletable;
import io.alauda.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.alauda.kubernetes.client.dsl.NonNamespaceOperation;
import io.alauda.kubernetes.client.dsl.Watchable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.NotReallyRoleSensitiveCallable;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

@Extension
public class PipelineWatcher
extends AbstractWatcher
implements BaseWatcher {
    private static final Logger logger = Logger.getLogger(PipelineWatcher.class.getName());
    private static final HashSet<Pipeline> pipelinesWithNoPCList = new HashSet();
    private WatcherCallback<Pipeline> watcherCallback;

    @Override
    public void watch() {
        AlaudaDevOpsClient client = AlaudaUtils.getAuthenticatedAlaudaClient();
        if (client == null) {
            this.stop();
            logger.severe("client is null, when watch Pipeline");
            return;
        }
        PipelineList list = (PipelineList)((FilterWatchListMultiDeletable)client.pipelines().inAnyNamespace()).list();
        String ver = "0";
        if (list != null) {
            ver = list.getMetadata().getResourceVersion();
        }
        this.watcherCallback = new WatcherCallback(this, null);
        this.setWatcher((Watch)((Watchable)((FilterWatchListMultiDeletable)client.pipelines().inAnyNamespace()).withResourceVersion(ver)).watch(this.watcherCallback));
    }

    @Override
    public WatcherCallback getWatcherCallback() {
        return this.watcherCallback;
    }

    @Override
    public void init(String[] namespaces) {
        PipelineConfigToJobMap.initializePipelineConfigToJobMap();
        PipelineWatcher.flushPipelinesWithNoPCList();
        for (String namespace : namespaces) {
            try {
                logger.fine("listing Pipeline resources");
                PipelineList newPipelines = this.filterNew((PipelineList)((NonNamespaceOperation)AlaudaUtils.getAuthenticatedAlaudaClient().pipelines().inNamespace(namespace)).list());
                if (newPipelines == null || newPipelines.getItems() == null || newPipelines.getItems().size() == 0) continue;
                PipelineWatcher.onInitialPipelines(newPipelines);
                logger.fine("handled Pipeline resources");
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to load initial Builds: " + e, e);
            }
        }
        PipelineWatcher.reconcileRunsAndPipelines();
    }

    private PipelineList filterNew(PipelineList list) {
        return JenkinsUtils.filterNew(list);
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"})
    public synchronized void eventReceived(Watcher.Action action, Pipeline pipeline) {
        String pipelineName = pipeline.getMetadata().getName();
        logger.info(() -> "Pipeline event: " + action + " - pipeline " + pipelineName);
        if (!AlaudaUtils.isPipelineStrategyPipeline(pipeline)) {
            logger.warning(() -> "Pipeline " + pipelineName + " is not Alauda pipeline strategy.");
            return;
        }
        if (!ResourcesCache.getInstance().isBinding(pipeline)) {
            logger.warning(() -> "Pipeline " + pipelineName + " is not binding to current jenkins " + ResourcesCache.getInstance().getJenkinsService());
            return;
        }
        try {
            switch (action) {
                case ADDED: {
                    PipelineWatcher.addEventToJenkinsJobRun(pipeline);
                    break;
                }
                case MODIFIED: {
                    PipelineWatcher.modifyEventToJenkinsJobRun(pipeline);
                    break;
                }
                case DELETED: {
                    PipelineWatcher.deleteEventToJenkinsJobRun(pipeline);
                    break;
                }
                case ERROR: {
                    logger.warning("watch for pipeline " + pipelineName + " received error event ");
                    break;
                }
                default: {
                    logger.warning("watch for pipeline " + pipelineName + " received unknown event " + action);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, String.format("Caught exception when %s", action), e);
        }
    }

    @Override
    public <T> void eventReceived(Watcher.Action action, T resource) {
        Pipeline pipeline = (Pipeline)resource;
        this.eventReceived(action, pipeline);
    }

    public static synchronized void onInitialPipelines(PipelineList pipelineList) {
        List items = pipelineList.getItems();
        Collections.sort(items, new PipelineNumComparator());
        HashMap<String, PipelineConfig> pipelineConfigMap = new HashMap<String, PipelineConfig>();
        HashMap<PipelineConfig, ArrayList<Pipeline>> pipelineConfigBuildMap = new HashMap<PipelineConfig, ArrayList<Pipeline>>(items.size());
        for (Pipeline pipeline : items) {
            ArrayList<Pipeline> pcPipelines;
            String pipelineConfigName;
            if (!AlaudaUtils.isPipelineStrategyPipeline(pipeline) || !ResourcesCache.getInstance().isBinding(pipeline) || StringUtils.isEmpty((String)(pipelineConfigName = pipeline.getSpec().getPipelineConfig().getName()))) continue;
            String namespace = pipeline.getMetadata().getNamespace();
            String configMapKey = namespace + "/" + pipelineConfigName;
            PipelineConfig pc = (PipelineConfig)pipelineConfigMap.get(configMapKey);
            if (pc == null) {
                pc = (PipelineConfig)((PipelineConfigResource)((NonNamespaceOperation)AlaudaUtils.getAuthenticatedAlaudaClient().pipelineConfigs().inNamespace(namespace)).withName(pipelineConfigName)).get();
                if (pc == null) continue;
                pipelineConfigMap.put(configMapKey, pc);
            }
            if ((pcPipelines = (ArrayList<Pipeline>)pipelineConfigBuildMap.get(pc)) == null) {
                pcPipelines = new ArrayList<Pipeline>();
                pipelineConfigBuildMap.put(pc, pcPipelines);
            }
            pcPipelines.add(pipeline);
        }
        for (Map.Entry entry : pipelineConfigBuildMap.entrySet()) {
            List pipelines;
            PipelineConfig pc = (PipelineConfig)entry.getKey();
            if (pc.getMetadata() == null) continue;
            WorkflowJob job = PipelineConfigToJobMap.getJobFromPipelineConfig(pc);
            if (job == null) {
                List pipelines2 = (List)entry.getValue();
                for (Pipeline p : pipelines2) {
                    logger.info("skipping listed new pipeline " + p.getMetadata().getName() + " no job at this time");
                    PipelineWatcher.addPipelineToNoPCList(p);
                }
                continue;
            }
            PipelineConfigProjectProperty bcp = (PipelineConfigProjectProperty)job.getProperty(PipelineConfigProjectProperty.class);
            if (bcp == null) {
                pipelines = (List)entry.getValue();
                for (Pipeline pipe : pipelines) {
                    logger.info("skipping listed new pipeline " + pipe.getMetadata().getName() + " no prop at this time");
                    PipelineWatcher.addPipelineToNoPCList(pipe);
                }
                continue;
            }
            pipelines = (List)entry.getValue();
            JenkinsUtils.handlePipelineList(job, pipelines);
        }
    }

    private static void modifyEventToJenkinsJobRun(Pipeline pipeline) {
        PipelineStatus status = pipeline.getStatus();
        logger.info("Modified pipeline " + pipeline.getMetadata().getName());
        if (status != null && AlaudaUtils.isCancellable(status) && AlaudaUtils.isCancelled(status)) {
            logger.info("Pipeline was cancelled " + pipeline.getMetadata().getName());
            WorkflowJob job = JenkinsUtils.getJobFromPipeline(pipeline);
            if (job != null) {
                JenkinsUtils.cancelPipeline(job, pipeline);
            } else {
                PipelineWatcher.removePipelineFromNoPCList(pipeline);
            }
        } else {
            logger.info("Pipeline changed... flusing pipelines... " + pipeline.getMetadata().getName());
            PipelineWatcher.flushPipelinesWithNoPCList();
        }
    }

    public static synchronized boolean addEventToJenkinsJobRun(Pipeline pipeline) throws IOException {
        if (!AlaudaUtils.isPipelineStrategyPipeline(pipeline)) {
            return false;
        }
        PipelineStatus status = pipeline.getStatus();
        if (status != null) {
            logger.info("Pipeline Status is not null: " + status);
            if (AlaudaUtils.isCancelled(status)) {
                logger.info("Pipeline Status is Cancelled... updating pipeline: " + status);
                AlaudaUtils.updatePipelinePhase(pipeline, "Cancelled");
                return false;
            }
            if (!AlaudaUtils.isNew(status)) {
                logger.info("Pipeline is not new... cancelling... " + status);
                return false;
            }
        }
        WorkflowJob job = JenkinsUtils.getJobFromPipeline(pipeline);
        logger.info("Pipeline got job... " + job);
        if (job != null) {
            logger.info("Pipeline job will trigger... " + job + " pipeline: " + pipeline.getMetadata().getName());
            return JenkinsUtils.triggerJob(job, pipeline);
        }
        logger.info("skipping watch event for pipeline " + pipeline.getMetadata().getName() + " no job at this time");
        PipelineWatcher.addPipelineToNoPCList(pipeline);
        return false;
    }

    public static void addPipelineToNoPCList(Pipeline pipeline) {
        if (!AlaudaUtils.isPipelineStrategyPipeline(pipeline)) {
            return;
        }
        pipelinesWithNoPCList.add(pipeline);
    }

    private static synchronized void removePipelineFromNoPCList(Pipeline pipeline) {
        pipelinesWithNoPCList.remove(pipeline);
    }

    private static synchronized void clearNoPCList() {
        pipelinesWithNoPCList.clear();
    }

    public static void flushPipelinesWithNoPCList() {
        HashSet clone = (HashSet)pipelinesWithNoPCList.clone();
        PipelineWatcher.clearNoPCList();
        for (Pipeline pipeline : clone) {
            WorkflowJob job = JenkinsUtils.getJobFromPipeline(pipeline);
            logger.info("Pipeline flush: " + pipeline.getMetadata().getName() + " - job: " + job);
            if (job != null) {
                try {
                    logger.info("triggering job run for previously skipped pipeline " + pipeline.getMetadata().getName());
                    JenkinsUtils.triggerJob(job, pipeline);
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "flushCachedPipelines", e);
                }
                continue;
            }
            PipelineWatcher.addPipelineToNoPCList(pipeline);
        }
    }

    private static synchronized void innerDeleteEventToJenkinsJobRun(final Pipeline pipeline) throws Exception {
        final WorkflowJob job = JenkinsUtils.getJobFromPipeline(pipeline);
        if (job != null) {
            ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<Void, Exception>(){

                public Void call() throws Exception {
                    JenkinsUtils.cancelPipeline(job, pipeline, true);
                    JenkinsUtils.deleteRun(job, pipeline);
                    return null;
                }
            });
        } else {
            PipelineWatcher.removePipelineFromNoPCList(pipeline);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void deleteEventToJenkinsJobRun(Pipeline pipeline) throws Exception {
        logger.info("Pipeline delete: " + pipeline.getMetadata().getName());
        List ownerRefs = pipeline.getMetadata().getOwnerReferences();
        String pcUid = null;
        for (OwnerReference ref : ownerRefs) {
            if (!"PipelineConfig".equals(ref.getKind()) || ref.getUid() == null || ref.getUid().length() <= 0) continue;
            String string = pcUid = ref.getUid().intern();
            synchronized (string) {
                if (PipelineConfigToJobMap.getJobFromPipelineConfigUid(pcUid) == null) {
                    return;
                }
                PipelineWatcher.innerDeleteEventToJenkinsJobRun(pipeline);
                return;
            }
        }
        PipelineWatcher.innerDeleteEventToJenkinsJobRun(pipeline);
    }

    private static synchronized void reconcileRunsAndPipelines() {
        logger.info("Reconciling job runs and pipelines");
        List jobs = Jenkins.getInstance().getAllItems(WorkflowJob.class);
        for (WorkflowJob job : jobs) {
            PipelineConfigProjectProperty pcpp = (PipelineConfigProjectProperty)job.getProperty(PipelineConfigProjectProperty.class);
            if (pcpp == null) continue;
            PipelineList pipelineList = (PipelineList)((FilterWatchListDeletable)((NonNamespaceOperation)AlaudaUtils.getAuthenticatedAlaudaClient().pipelines().inNamespace(pcpp.getNamespace())).withLabel("pipelineConfig", pcpp.getName())).list();
            logger.info("Checking runs for PipelineConfig " + pcpp.getNamespace() + "/" + pcpp.getName());
            for (WorkflowRun run : job.getBuilds()) {
                boolean found = false;
                JenkinsPipelineCause cause = (JenkinsPipelineCause)run.getCause(JenkinsPipelineCause.class);
                for (Pipeline build : pipelineList.getItems()) {
                    if (cause == null || !cause.getUid().equals(build.getMetadata().getUid())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                JenkinsUtils.deleteRun(run);
            }
        }
    }

    @Override
    public final String getName() {
        return "PipelineWatcher";
    }
}

