/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.watcher;

import antlr.ANTLRException;
import com.cloudbees.hudson.plugins.folder.Folder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.BulkChange;
import hudson.Extension;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.ParameterDefinition;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.remoting.Callable;
import hudson.security.ACL;
import hudson.triggers.SafeTimerTask;
import hudson.util.XStream2;
import io.alauda.devops.client.AlaudaDevOpsClient;
import io.alauda.devops.client.dsl.PipelineConfigResource;
import io.alauda.jenkins.devops.sync.PipelineConfigProjectProperty;
import io.alauda.jenkins.devops.sync.PipelineConfigToJobMapper;
import io.alauda.jenkins.devops.sync.WatcherCallback;
import io.alauda.jenkins.devops.sync.util.AlaudaUtils;
import io.alauda.jenkins.devops.sync.util.CredentialsUtils;
import io.alauda.jenkins.devops.sync.util.JenkinsUtils;
import io.alauda.jenkins.devops.sync.util.NamespaceName;
import io.alauda.jenkins.devops.sync.util.PipelineConfigToJobMap;
import io.alauda.jenkins.devops.sync.util.PipelineConfigUtils;
import io.alauda.jenkins.devops.sync.watcher.AbstractWatcher;
import io.alauda.jenkins.devops.sync.watcher.BaseWatcher;
import io.alauda.jenkins.devops.sync.watcher.PipelineWatcher;
import io.alauda.jenkins.devops.sync.watcher.ResourcesCache;
import io.alauda.kubernetes.api.model.Condition;
import io.alauda.kubernetes.api.model.DoneablePipelineConfig;
import io.alauda.kubernetes.api.model.HasMetadata;
import io.alauda.kubernetes.api.model.ObjectMeta;
import io.alauda.kubernetes.api.model.PipelineConfig;
import io.alauda.kubernetes.api.model.PipelineConfigList;
import io.alauda.kubernetes.api.model.PipelineConfigStatus;
import io.alauda.kubernetes.api.model.PipelineConfigStatusBuilder;
import io.alauda.kubernetes.api.model.PipelineConfigTemplate;
import io.alauda.kubernetes.api.model.PipelineList;
import io.alauda.kubernetes.client.Watch;
import io.alauda.kubernetes.client.Watcher;
import io.alauda.kubernetes.client.dsl.FilterWatchListDeletable;
import io.alauda.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.alauda.kubernetes.client.dsl.NonNamespaceOperation;
import io.alauda.kubernetes.client.dsl.Watchable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import jenkins.model.Jenkins;
import jenkins.security.NotReallyRoleSensitiveCallable;
import jenkins.util.Timer;
import org.acegisecurity.Authentication;
import org.apache.tools.ant.filters.StringInputStream;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

@Extension
public class PipelineConfigWatcher
extends AbstractWatcher
implements BaseWatcher {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final HashSet<String> deletesInProgress = new HashSet();
    private WatcherCallback watcherCallback;

    public static synchronized void deleteInProgress(String pcName) {
        deletesInProgress.add(pcName);
    }

    public static synchronized boolean isDeleteInProgress(String pcID) {
        return deletesInProgress.contains(pcID);
    }

    public static synchronized void deleteCompleted(String pcID) {
        deletesInProgress.remove(pcID);
    }

    @Override
    public void watch() {
        AlaudaDevOpsClient client = AlaudaUtils.getAuthenticatedAlaudaClient();
        if (client == null) {
            this.stop();
            this.logger.severe("client is null, when watch Secret");
            return;
        }
        PipelineConfigList list = (PipelineConfigList)((FilterWatchListMultiDeletable)client.pipelineConfigs().inAnyNamespace()).list();
        String ver = "0";
        if (list != null) {
            ver = list.getMetadata().getResourceVersion();
        }
        this.watcherCallback = new WatcherCallback(this, null);
        this.setWatcher((Watch)((Watchable)((FilterWatchListMultiDeletable)client.pipelineConfigs().inAnyNamespace()).withResourceVersion(ver)).watch((Object)this.watcherCallback));
    }

    @Override
    public WatcherCallback getWatcherCallback() {
        return this.watcherCallback;
    }

    @Override
    public void init(String[] namespaces) {
        PipelineConfigToJobMap.initializePipelineConfigToJobMap();
        for (String namespace : namespaces) {
            this.logger.info("Looking for pipeline configs in namespace " + namespace);
            PipelineConfigList pipelineConfigs = null;
            try {
                this.logger.info("listing PipelineConfigs resources");
                pipelineConfigs = (PipelineConfigList)((NonNamespaceOperation)AlaudaUtils.getAuthenticatedAlaudaClient().pipelineConfigs().inNamespace(namespace)).list();
                this.onInitialPipelineConfigs(pipelineConfigs);
                this.logger.info("handled PipelineConfigs resources");
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to load PipelineConfigs: " + e, e);
            }
        }
    }

    private synchronized void onInitialPipelineConfigs(PipelineConfigList pipelineConfigs) {
        if (pipelineConfigs == null) {
            return;
        }
        List items = pipelineConfigs.getItems();
        if (items != null) {
            for (PipelineConfig pipelineConfig : items) {
                try {
                    if (!ResourcesCache.getInstance().isBinding(pipelineConfig)) continue;
                    this.upsertJob(pipelineConfig);
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "Failed to update job", e);
                }
            }
        }
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"})
    public synchronized void eventReceived(final Watcher.Action action, final PipelineConfig pipelineConfig) {
        String pipelineName = pipelineConfig.getMetadata().getName();
        this.logger.info("PipelineConfigWatcher receive event: " + action + "; name: " + pipelineName);
        boolean bindingToCurrentJenkins = false;
        if (action == Watcher.Action.DELETED) {
            PipelineConfigProjectProperty pro;
            WorkflowJob job = PipelineConfigToJobMap.getJobFromPipelineConfig(pipelineConfig);
            if (job != null && (pro = (PipelineConfigProjectProperty)job.getProperty(PipelineConfigProjectProperty.class)) != null) {
                bindingToCurrentJenkins = pipelineConfig.getMetadata().getUid().equals(pro.getUid());
            }
        } else {
            bindingToCurrentJenkins = ResourcesCache.getInstance().isBinding(pipelineConfig);
        }
        if (!bindingToCurrentJenkins) {
            String pipelineBinding = pipelineConfig.getSpec().getJenkinsBinding().getName();
            String jenkinsService = ResourcesCache.getInstance().getJenkinsService();
            String msg = String.format("%s[%s] is not binding to current jenkins[%s]", pipelineName, pipelineBinding, jenkinsService);
            this.logger.warning(msg);
        }
        try {
            switch (action) {
                case ADDED: {
                    this.upsertJob(pipelineConfig);
                    break;
                }
                case DELETED: {
                    this.deleteEventToJenkinsJob(pipelineConfig);
                    break;
                }
                case MODIFIED: {
                    this.modifyEventToJenkinsJob(pipelineConfig);
                    break;
                }
                case ERROR: {
                    this.logger.warning("watch for PipelineConfig " + pipelineConfig.getMetadata().getName() + " received error event ");
                    break;
                }
                default: {
                    this.logger.warning("watch for PipelineConfig " + pipelineConfig.getMetadata().getName() + " received unknown event " + action);
                }
            }
            ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<Void, Exception>(){

                public Void call() throws Exception {
                    PipelineWatcher.flushPipelinesWithNoPCList();
                    if (action == Watcher.Action.ADDED) {
                        SafeTimerTask backupBuildQuery = new SafeTimerTask(){

                            public void doRun() {
                                PipelineList pipelineList = JenkinsUtils.filterNew((PipelineList)((FilterWatchListDeletable)((NonNamespaceOperation)AlaudaUtils.getAuthenticatedAlaudaClient().pipelines().inNamespace(pipelineConfig.getMetadata().getNamespace())).withLabel("pipelineConfig", pipelineConfig.getMetadata().getName())).list());
                                if (pipelineList.getItems().size() > 0) {
                                    PipelineConfigWatcher.this.logger.info("pipeline backup query for " + pipelineConfig.getMetadata().getName() + " found new pipelines");
                                    PipelineWatcher.onInitialPipelines(pipelineList);
                                }
                            }
                        };
                        Timer.get().schedule((Runnable)backupBuildQuery, 10000L, TimeUnit.MILLISECONDS);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Caught: " + e, e);
        }
    }

    @Override
    public <T> void eventReceived(Watcher.Action action, T resource) {
        PipelineConfig pc = (PipelineConfig)resource;
        this.eventReceived(action, pc);
    }

    private void updateJob(WorkflowJob job, InputStream jobStream, String jobName, PipelineConfig pipelineConfig, PipelineConfigProjectProperty pipelineConfigProjectProperty) throws IOException {
        StreamSource source = new StreamSource(jobStream);
        job.updateByXml((Source)source);
        job.save();
        this.logger.info("Updated job " + jobName + " from PipelineConfig " + NamespaceName.create((HasMetadata)pipelineConfig) + " with revision: " + pipelineConfig.getMetadata().getResourceVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upsertJob(final PipelineConfig pipelineConfig) throws Exception {
        PipelineConfigStatus pipelineConfigStatus = pipelineConfig.getStatus();
        String pipelineConfigPhase = null;
        if (pipelineConfigStatus == null || !"Syncing".equals(pipelineConfigPhase = pipelineConfig.getStatus().getPhase())) {
            this.logger.info(String.format("Do nothing, PipelineConfig [%s], phase [%s].", pipelineConfig.getMetadata().getName(), pipelineConfigPhase));
            return;
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        pipelineConfig.getStatus().setConditions(conditions);
        PipelineConfigUtils.dependencyCheck(pipelineConfig, conditions);
        if (AlaudaUtils.isPipelineStrategyPipelineConfig(pipelineConfig)) {
            String string = pipelineConfig.getMetadata().getUid().intern();
            synchronized (string) {
                ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<Void, Exception>(){

                    public Void call() throws Exception {
                        boolean newJob;
                        Jenkins activeInstance;
                        String jobName = AlaudaUtils.jenkinsJobName(pipelineConfig);
                        String jobFullName = AlaudaUtils.jenkinsJobFullName(pipelineConfig);
                        WorkflowJob job = PipelineConfigToJobMap.getJobFromPipelineConfig(pipelineConfig);
                        Jenkins parent = activeInstance = Jenkins.getInstance();
                        if (job == null) {
                            job = (WorkflowJob)activeInstance.getItemByFullName(jobFullName);
                        }
                        boolean bl = newJob = job == null;
                        if (newJob) {
                            parent = AlaudaUtils.getFullNameParent(activeInstance, jobFullName, AlaudaUtils.getNamespace((HasMetadata)pipelineConfig));
                            job = new WorkflowJob((ItemGroup)parent, jobName);
                        }
                        BulkChange bk = new BulkChange((Saveable)job);
                        PipelineConfigProjectProperty pipelineConfigProjectProperty = (PipelineConfigProjectProperty)job.getProperty(PipelineConfigProjectProperty.class);
                        if (pipelineConfigProjectProperty != null) {
                            long updatedBCResourceVersion = AlaudaUtils.parseResourceVersion((HasMetadata)pipelineConfig);
                            long oldBCResourceVersion = AlaudaUtils.parseResourceVersion(pipelineConfigProjectProperty.getResourceVersion());
                            PipelineConfigProjectProperty newProperty = new PipelineConfigProjectProperty(pipelineConfig);
                            if (updatedBCResourceVersion <= oldBCResourceVersion && newProperty.getUid().equals(pipelineConfigProjectProperty.getUid()) && newProperty.getNamespace().equals(pipelineConfigProjectProperty.getNamespace()) && newProperty.getName().equals(pipelineConfigProjectProperty.getName())) {
                                return null;
                            }
                            pipelineConfigProjectProperty.setUid(newProperty.getUid());
                            pipelineConfigProjectProperty.setNamespace(newProperty.getNamespace());
                            pipelineConfigProjectProperty.setName(newProperty.getName());
                            pipelineConfigProjectProperty.setResourceVersion(newProperty.getResourceVersion());
                        } else {
                            job.addProperty((JobProperty)new PipelineConfigProjectProperty(pipelineConfig));
                        }
                        job.setDisplayName(AlaudaUtils.jenkinsJobDisplayName(pipelineConfig));
                        FlowDefinition flowFromPipelineConfig = PipelineConfigToJobMapper.mapPipelineConfigToFlow(pipelineConfig);
                        if (flowFromPipelineConfig == null) {
                            PipelineConfigWatcher.this.updatePipelineConfigPhase(pipelineConfig);
                            return null;
                        }
                        job.setDefinition(flowFromPipelineConfig);
                        Map<String, ParameterDefinition> paramMap = JenkinsUtils.addJobParamForPipelineParameters(job, pipelineConfig.getSpec().getParameters(), true);
                        job.setConcurrentBuild(!pipelineConfig.getSpec().getRunPolicy().equals("Serial"));
                        List<ANTLRException> triggerExceptions = JenkinsUtils.setJobTriggers(job, pipelineConfig.getSpec().getTriggers());
                        triggerExceptions.forEach(ex -> {
                            Condition condition = new Condition();
                            condition.setReason("contains invalid triggers");
                            condition.setMessage(ex.getMessage());
                            pipelineConfig.getStatus().getConditions().add(condition);
                        });
                        StringInputStream jobStream = new StringInputStream(new XStream2().toXML((Object)job));
                        if (newJob) {
                            try {
                                if (parent instanceof Folder) {
                                    Folder folder = (Folder)parent;
                                    folder.createProjectFromXML(jobName, (InputStream)jobStream).save();
                                } else {
                                    activeInstance.createProjectFromXML(jobName, (InputStream)jobStream).save();
                                }
                                PipelineConfigWatcher.this.logger.info("Created job " + jobName + " from PipelineConfig " + NamespaceName.create((HasMetadata)pipelineConfig) + " with revision: " + pipelineConfig.getMetadata().getResourceVersion());
                            }
                            catch (IllegalArgumentException e) {
                                PipelineConfigWatcher.this.updateJob(job, (InputStream)jobStream, jobName, pipelineConfig, pipelineConfigProjectProperty);
                            }
                        } else {
                            PipelineConfigWatcher.this.updateJob(job, (InputStream)jobStream, jobName, pipelineConfig, pipelineConfigProjectProperty);
                        }
                        bk.commit();
                        String fullName = job.getFullName();
                        WorkflowJob workflowJob = (WorkflowJob)activeInstance.getItemByFullName(fullName, WorkflowJob.class);
                        if (workflowJob == null && parent instanceof Folder) {
                            Folder folder = (Folder)parent;
                            folder.add((TopLevelItem)job, jobName);
                            workflowJob = (WorkflowJob)activeInstance.getItemByFullName(fullName, WorkflowJob.class);
                        }
                        if (workflowJob == null) {
                            PipelineConfigWatcher.this.logger.warning("Could not find created job " + fullName + " for PipelineConfig: " + AlaudaUtils.getNamespace((HasMetadata)pipelineConfig) + "/" + AlaudaUtils.getName((HasMetadata)pipelineConfig));
                        } else {
                            PipelineConfigWatcher.this.updatePipelineConfigPhase(pipelineConfig);
                            JenkinsUtils.verifyEnvVars(paramMap, workflowJob);
                            PipelineConfigToJobMap.putJobWithPipelineConfig(workflowJob, pipelineConfig);
                        }
                        return null;
                    }
                });
            }
        }
    }

    private boolean createFromTpl(@Nonnull PipelineConfig pipelineConfig) {
        PipelineConfigTemplate template = pipelineConfig.getSpec().getStrategy().getTemplate();
        return template != null && template.getSpec() != null;
    }

    private void updatePipelineConfigPhase(PipelineConfig pipelineConfig) {
        PipelineConfigStatusBuilder statusBuilder = new PipelineConfigStatusBuilder();
        PipelineConfigStatus status = pipelineConfig.getStatus();
        List conditions = status.getConditions();
        if (conditions.size() > 0) {
            conditions.forEach(condition -> statusBuilder.addNewConditionLike(condition).endCondition());
            statusBuilder.withMessage("Exists errors in process of creating pipeline job.");
            statusBuilder.withPhase("Error");
        } else {
            statusBuilder.withPhase("Ready");
        }
        AlaudaDevOpsClient client = AlaudaUtils.getAuthenticatedAlaudaClient();
        ObjectMeta metadata = pipelineConfig.getMetadata();
        String namespace = metadata.getNamespace();
        String name = metadata.getName();
        PipelineConfig result = ((DoneablePipelineConfig)((DoneablePipelineConfig)((PipelineConfigResource)((NonNamespaceOperation)client.pipelineConfigs().inNamespace(namespace)).withName(name)).edit()).withNewStatusLike(statusBuilder.build()).endStatus()).done();
        this.logger.info(String.format("Update PipelineConfig's phase %s, name: %s", result.getStatus().getPhase(), result.getMetadata().getName()));
    }

    private synchronized void modifyEventToJenkinsJob(PipelineConfig pipelineConfig) throws Exception {
        if (AlaudaUtils.isPipelineStrategyPipelineConfig(pipelineConfig)) {
            this.upsertJob(pipelineConfig);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerDeleteEventToJenkinsJob(final PipelineConfig pipelineConfig) throws Exception {
        WorkflowJob job = PipelineConfigToJobMap.getJobFromPipelineConfig(pipelineConfig);
        if (job != null) {
            String string = pipelineConfig.getMetadata().getUid().intern();
            synchronized (string) {
                ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<Void, Exception>((Job)job){
                    final /* synthetic */ Job val$job;
                    {
                        this.val$job = job;
                    }

                    public Void call() throws Exception {
                        try {
                            PipelineConfigWatcher.deleteInProgress(pipelineConfig.getMetadata().getNamespace() + pipelineConfig.getMetadata().getName());
                            this.val$job.delete();
                        }
                        finally {
                            PipelineConfigToJobMap.removeJobWithPipelineConfig(pipelineConfig);
                            Jenkins.getInstance().rebuildDependencyGraphAsync();
                            PipelineConfigWatcher.deleteCompleted(pipelineConfig.getMetadata().getNamespace() + pipelineConfig.getMetadata().getName());
                        }
                        return null;
                    }
                });
                CredentialsUtils.deleteSourceCredentials(pipelineConfig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void deleteEventToJenkinsJob(PipelineConfig pipelineConfig) throws Exception {
        String pcUid = pipelineConfig.getMetadata().getUid();
        if (pcUid != null && pcUid.length() > 0) {
            String string = pcUid = pcUid.intern();
            synchronized (string) {
                this.innerDeleteEventToJenkinsJob(pipelineConfig);
                return;
            }
        }
        this.innerDeleteEventToJenkinsJob(pipelineConfig);
    }

    @Override
    public final String getName() {
        return "PipelineConfigWatcher";
    }
}

