/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.watcher;

import com.cloudbees.hudson.plugins.folder.Folder;
import hudson.remoting.Callable;
import hudson.security.ACL;
import io.alauda.devops.client.AlaudaDevOpsClient;
import io.alauda.jenkins.devops.sync.AlaudaFolderProperty;
import io.alauda.jenkins.devops.sync.WatcherCallback;
import io.alauda.jenkins.devops.sync.util.AlaudaUtils;
import io.alauda.jenkins.devops.sync.watcher.AbstractWatcher;
import io.alauda.jenkins.devops.sync.watcher.BaseWatcher;
import io.alauda.kubernetes.api.model.Namespace;
import io.alauda.kubernetes.api.model.NamespaceList;
import io.alauda.kubernetes.client.Watch;
import io.alauda.kubernetes.client.Watcher;
import io.alauda.kubernetes.client.dsl.Watchable;
import java.io.IOException;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.NotReallyRoleSensitiveCallable;
import org.acegisecurity.Authentication;

public class NamespaceWatcher
extends AbstractWatcher
implements BaseWatcher {
    private static final Logger logger = Logger.getLogger(NamespaceWatcher.class.getName());
    private WatcherCallback<Namespace> watcherCallback;

    @Override
    public WatcherCallback getWatcherCallback() {
        return this.watcherCallback;
    }

    @Override
    public <T> void eventReceived(Watcher.Action action, T resource) {
        if (action != Watcher.Action.DELETED || !(resource instanceof Namespace)) {
            return;
        }
        Namespace ns = (Namespace)resource;
        final String folderName = ns.getMetadata().getName();
        logger.info(String.format("namespace [%s] watcher receive delete event.", folderName));
        try {
            ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<Void, Exception>(){

                public Void call() throws Exception {
                    Folder folder = (Folder)Jenkins.getInstance().getItemByFullName(folderName, Folder.class);
                    if (folder == null) {
                        logger.warning(String.format("Folder [%s] can't found.", folderName));
                        return null;
                    }
                    AlaudaFolderProperty alaudaFolderProperty = (AlaudaFolderProperty)folder.getProperties().get(AlaudaFolderProperty.class);
                    if (alaudaFolderProperty == null) {
                        logger.warning(String.format("Folder [%s] don't have AbstractFolderProperty, will skip it.", folderName));
                        return null;
                    }
                    int itemCount = folder.getItems().size();
                    if (itemCount > 0) {
                        logger.warning(String.format("Do not delete folder that still has items, count %s.", itemCount));
                        alaudaFolderProperty.setDirty(true);
                        try {
                            folder.save();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        return null;
                    }
                    try {
                        folder.delete();
                    }
                    catch (IOException | InterruptedException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void watch() {
        AlaudaDevOpsClient client = AlaudaUtils.getAuthenticatedAlaudaClient();
        if (client == null) {
            this.stop();
            logger.severe("client is null, when watch namespace");
            return;
        }
        NamespaceList list = (NamespaceList)client.namespaces().list();
        String ver = "0";
        if (list != null) {
            ver = list.getMetadata().getResourceVersion();
        }
        this.watcherCallback = new WatcherCallback(this, null);
        this.setWatcher((Watch)((Watchable)client.namespaces().withResourceVersion(ver)).watch(this.watcherCallback));
    }

    @Override
    public void init(String[] namespaces) {
    }
}

