/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.watcher;

import hudson.Extension;
import io.alauda.devops.client.AlaudaDevOpsClient;
import io.alauda.jenkins.devops.sync.WatcherCallback;
import io.alauda.jenkins.devops.sync.util.AlaudaUtils;
import io.alauda.jenkins.devops.sync.watcher.AbstractWatcher;
import io.alauda.jenkins.devops.sync.watcher.BaseWatcher;
import io.alauda.jenkins.devops.sync.watcher.ResourcesCache;
import io.alauda.kubernetes.api.model.JenkinsBinding;
import io.alauda.kubernetes.api.model.JenkinsBindingList;
import io.alauda.kubernetes.client.Watch;
import io.alauda.kubernetes.client.Watcher;
import io.alauda.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.alauda.kubernetes.client.dsl.Watchable;
import java.util.List;
import java.util.logging.Logger;

@Extension
public class JenkinsBindingWatcher
extends AbstractWatcher
implements BaseWatcher {
    private final Logger LOGGER = Logger.getLogger(JenkinsBindingWatcher.class.getName());
    private WatcherCallback watcherCallback;

    @Override
    public <T> void eventReceived(Watcher.Action action, T resource) {
        JenkinsBinding jenkinsBinding = (JenkinsBinding)resource;
        this.LOGGER.info("JenkinsBindingWatcher receive action : " + action + "; resource : " + jenkinsBinding.getMetadata().getName());
        switch (action) {
            case ADDED: {
                ResourcesCache.getInstance().addNamespace(jenkinsBinding);
                break;
            }
            case DELETED: {
                ResourcesCache.getInstance().removeNamespace(jenkinsBinding);
            }
        }
    }

    @Override
    public void watch() {
        AlaudaDevOpsClient client = AlaudaUtils.getAuthenticatedAlaudaClient();
        if (client == null) {
            this.stop();
            this.LOGGER.severe("alauda client is null, when watch JenkinsBinding");
            return;
        }
        JenkinsBindingList jenkinsBindingList = (JenkinsBindingList)((FilterWatchListMultiDeletable)client.jenkinsBindings().inAnyNamespace()).list();
        String resourceVersion = "0";
        if (jenkinsBindingList != null) {
            resourceVersion = jenkinsBindingList.getMetadata().getResourceVersion();
            this.cacheBindings(jenkinsBindingList);
        } else {
            this.LOGGER.warning("Can not found JenkinsBindingList.");
        }
        this.watcherCallback = new WatcherCallback(this, null);
        this.setWatcher((Watch)((Watchable)((FilterWatchListMultiDeletable)client.jenkinsBindings().inAnyNamespace()).withResourceVersion(resourceVersion)).watch((Object)this.watcherCallback));
        this.LOGGER.info("JenkinsBindingWatcher already added.");
    }

    @Override
    public WatcherCallback getWatcherCallback() {
        return this.watcherCallback;
    }

    private void cacheBindings(JenkinsBindingList jenkinsBindingList) {
        List items = jenkinsBindingList.getItems();
        if (items == null || items.size() == 0) {
            this.LOGGER.warning("JenkinsBindingList is empty!");
            return;
        }
        this.LOGGER.info("Find JenkinsBinding " + items.size());
        for (JenkinsBinding binding : items) {
            ResourcesCache.getInstance().addJenkinsBinding(binding);
        }
    }

    @Override
    public void init(String[] namespaces) {
    }

    @Override
    public final String getName() {
        return "JenkinsBindingWatcher";
    }
}

