/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.util;

import hudson.model.Result;
import hudson.model.Run;
import hudson.util.RunList;
import io.alauda.devops.client.AlaudaDevOpsClient;
import io.alauda.devops.client.dsl.PipelineResource;
import io.alauda.jenkins.devops.sync.JenkinsPipelineCause;
import io.alauda.jenkins.devops.sync.util.AlaudaUtils;
import io.alauda.jenkins.devops.sync.util.PipelineConfigToJobMap;
import io.alauda.jenkins.devops.sync.watcher.PipelineWatcher;
import io.alauda.kubernetes.api.model.DoneablePipeline;
import io.alauda.kubernetes.api.model.ObjectMeta;
import io.alauda.kubernetes.api.model.PipelineConfig;
import io.alauda.kubernetes.api.model.PipelineFluent;
import io.alauda.kubernetes.api.model.PipelineList;
import io.alauda.kubernetes.client.dsl.FilterWatchListDeletable;
import io.alauda.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.Map;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class PipelineUtils {
    public static boolean delete(String namespace, String name) {
        AlaudaDevOpsClient client = AlaudaUtils.getAuthenticatedAlaudaClient();
        if (client == null) {
            return false;
        }
        return (Boolean)((PipelineResource)((NonNamespaceOperation)client.pipelines().inNamespace(namespace)).withName(name)).delete();
    }

    public static void pipelinesCheck(PipelineConfig config) {
        ObjectMeta configMetadata = config.getMetadata();
        String namespace = configMetadata.getNamespace();
        AlaudaDevOpsClient client = AlaudaUtils.getAuthenticatedAlaudaClient();
        if (client == null) {
            return;
        }
        PipelineList list = (PipelineList)((FilterWatchListDeletable)((NonNamespaceOperation)client.pipelines().inNamespace(namespace)).withLabel("pipelineConfig", configMetadata.getName())).list();
        if (list == null) {
            return;
        }
        WorkflowJob job = PipelineConfigToJobMap.getJobFromPipelineConfig(config);
        list.getItems().forEach(pipeline -> {
            String uid = pipeline.getMetadata().getUid();
            RunList runList = job.getBuilds().filter(run -> {
                JenkinsPipelineCause cause = (JenkinsPipelineCause)run.getCause(JenkinsPipelineCause.class);
                return cause != null && cause.getUid().equals(uid);
            });
            if (runList.isEmpty()) {
                if ("Queued".equals(pipeline.getStatus().getPhase())) {
                    Map labels = pipeline.getMetadata().getLabels();
                    String retry = null;
                    if (labels != null) {
                        retry = (String)labels.get("retry");
                    }
                    if (retry == null) {
                        retry = "1";
                    } else {
                        try {
                            retry = String.valueOf(Integer.parseInt(retry) + 1);
                        }
                        catch (NumberFormatException e) {
                            retry = "1";
                        }
                    }
                    PipelineWatcher.addPipelineToNoPCList(pipeline);
                    ((DoneablePipeline)((PipelineFluent.MetadataNested)((DoneablePipeline)((PipelineResource)((NonNamespaceOperation)client.pipelines().inNamespace(namespace)).withName(pipeline.getMetadata().getName())).edit()).editMetadata().addToLabels("retry", retry)).endMetadata()).done();
                } else {
                    ((PipelineResource)((NonNamespaceOperation)client.pipelines().inNamespace(namespace)).withName(pipeline.getMetadata().getName())).delete();
                }
            } else {
                WorkflowRun build = (WorkflowRun)runList.getLastBuild();
                String phase = PipelineUtils.runToPipelinePhase((Run)build);
                if (!phase.equals(pipeline.getStatus().getPhase())) {
                    ((DoneablePipeline)((PipelineFluent.StatusNested)((DoneablePipeline)((PipelineResource)((NonNamespaceOperation)client.pipelines().inNamespace(namespace)).withName(pipeline.getMetadata().getName())).edit()).editStatus().withPhase(phase)).endStatus()).done();
                }
            }
        });
    }

    public static String runToPipelinePhase(Run run) {
        if (run != null && !run.hasntStartedYet()) {
            if (run.isBuilding()) {
                return "Running";
            }
            Result result = run.getResult();
            if (result != null) {
                if (result.equals(Result.SUCCESS)) {
                    return "Complete";
                }
                if (result.equals(Result.ABORTED)) {
                    return "Cancelled";
                }
                if (result.equals(Result.FAILURE)) {
                    return "Failed";
                }
                if (result.equals(Result.UNSTABLE)) {
                    return "Failed";
                }
                return "Queued";
            }
        }
        return "Pending";
    }
}

