/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.util;

import hudson.Plugin;
import hudson.util.VersionNumber;
import io.alauda.jenkins.devops.sync.util.CollectionUtils;
import io.alauda.kubernetes.api.model.Condition;
import io.alauda.kubernetes.api.model.PipelineConfig;
import io.alauda.kubernetes.api.model.PipelineConfigTemplate;
import io.alauda.kubernetes.api.model.PipelineDependency;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;

public abstract class PipelineConfigUtils {
    private static final Logger logger = Logger.getLogger(PipelineConfigUtils.class.getName());

    private PipelineConfigUtils() {
    }

    public static boolean isSerialPolicy(PipelineConfig pipelineConfig) {
        if (pipelineConfig == null) {
            throw new IllegalArgumentException("param can't be null");
        }
        return "Serial".equals(pipelineConfig.getSpec().getRunPolicy());
    }

    public static boolean isParallel(PipelineConfig pipelineConfig) {
        if (pipelineConfig == null) {
            throw new IllegalArgumentException("param can't be null");
        }
        return "Parallel".equals(pipelineConfig.getSpec().getRunPolicy());
    }

    public static void dependencyCheck(@Nonnull PipelineConfig pipelineConfig, @Nonnull List<Condition> conditions) {
        boolean fromTpl = PipelineConfigUtils.createFromTpl(pipelineConfig);
        if (!fromTpl) {
            return;
        }
        PipelineConfigTemplate template = pipelineConfig.getSpec().getStrategy().getTemplate();
        PipelineDependency dependencies = template.getSpec().getDependencies();
        if (dependencies == null || CollectionUtils.isEmpty(dependencies.getPlugins())) {
            logger.info("PipelineConfig " + pipelineConfig.getMetadata().getName() + " no any dependencies.");
            return;
        }
        Jenkins jenkins = Jenkins.getInstance();
        dependencies.getPlugins().forEach(plugin -> {
            String name = plugin.getName();
            String version = plugin.getVersion();
            VersionNumber verNumber = new VersionNumber(version);
            Condition condition = new Condition();
            condition.setReason("plugin dependencies error");
            Plugin existsPlugin = jenkins.getPlugin(name);
            if (existsPlugin == null) {
                condition.setMessage(String.format("Lack plugin: %s, version: %s", name, version));
            } else {
                VersionNumber currentNumber = existsPlugin.getWrapper().getVersionNumber();
                if (currentNumber.isOlderThan(verNumber)) {
                    condition.setMessage(String.format("Require plugin: %s, version: %s, found %s", name, version, currentNumber));
                }
            }
            if (condition.getMessage() != null) {
                conditions.add(condition);
            }
        });
    }

    public static boolean createFromTpl(@Nonnull PipelineConfig pipelineConfig) {
        PipelineConfigTemplate template = pipelineConfig.getSpec().getStrategy().getTemplate();
        return template != null && template.getSpec() != null;
    }
}

