/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.util;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.Util;
import hudson.model.Fingerprint;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.remoting.Base64;
import hudson.security.ACL;
import io.alauda.devops.client.AlaudaDevOpsClient;
import io.alauda.jenkins.devops.sync.AlaudaSyncGlobalConfiguration;
import io.alauda.jenkins.devops.sync.core.InvalidSecretException;
import io.alauda.jenkins.devops.sync.credential.AlaudaToken;
import io.alauda.jenkins.devops.sync.util.AlaudaUtils;
import io.alauda.jenkins.devops.sync.util.NamespaceName;
import io.alauda.jenkins.devops.sync.util.PipelineConfigSecretToCredentialsMap;
import io.alauda.kubernetes.api.model.HasMetadata;
import io.alauda.kubernetes.api.model.ObjectMeta;
import io.alauda.kubernetes.api.model.PipelineConfig;
import io.alauda.kubernetes.api.model.PipelineConfigSpec;
import io.alauda.kubernetes.api.model.PipelineSource;
import io.alauda.kubernetes.api.model.Secret;
import io.alauda.kubernetes.api.model.SecretKeySetRef;
import io.alauda.kubernetes.client.dsl.NonNamespaceOperation;
import io.alauda.kubernetes.client.dsl.Resource;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.constraints.NotNull;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;

public abstract class CredentialsUtils {
    private static final Logger logger = Logger.getLogger(CredentialsUtils.class.getName());

    private CredentialsUtils() {
    }

    private static synchronized Secret getSourceCredentials(PipelineConfig pipelineConfig) {
        PipelineConfigSpec spec = pipelineConfig.getSpec();
        if (spec == null) {
            return null;
        }
        PipelineSource source = spec.getSource();
        if (source == null) {
            return null;
        }
        SecretKeySetRef secret = source.getSecret();
        if (secret != null && StringUtils.isNotBlank((String)secret.getName())) {
            String namespace = StringUtils.isBlank((String)secret.getNamespace()) ? pipelineConfig.getMetadata().getNamespace() : secret.getNamespace();
            return (Secret)((Resource)((NonNamespaceOperation)AlaudaUtils.getAuthenticatedAlaudaClient().secrets().inNamespace(namespace)).withName(secret.getName())).get();
        }
        return null;
    }

    public static synchronized String updateSourceCredentials(PipelineConfig pipelineConfig) throws IOException {
        String credID;
        Secret sourceSecret = CredentialsUtils.getSourceCredentials(pipelineConfig);
        if (sourceSecret != null) {
            ObjectMeta metadata = sourceSecret.getMetadata();
            String namespace = metadata.getNamespace();
            String name = metadata.getName();
            credID = CredentialsUtils.upsertCredential(sourceSecret, namespace, name);
            PipelineConfigSecretToCredentialsMap.linkPCSecretToCredential(NamespaceName.create((HasMetadata)pipelineConfig).toString(), credID);
        } else {
            credID = PipelineConfigSecretToCredentialsMap.unlinkPCSecretToCrendential(NamespaceName.create((HasMetadata)pipelineConfig).toString());
            if (credID != null) {
                CredentialsUtils.deleteCredential(credID, NamespaceName.create((HasMetadata)pipelineConfig), pipelineConfig.getMetadata().getResourceVersion());
            }
        }
        return credID;
    }

    public static synchronized void deleteSourceCredentials(PipelineConfig pipelineConfig) throws IOException {
        Secret sourceSecret = CredentialsUtils.getSourceCredentials(pipelineConfig);
        if (sourceSecret != null) {
            return;
        }
    }

    public static synchronized String upsertCredential(Secret secret) throws IOException {
        ObjectMeta metadata;
        if (secret != null && (metadata = secret.getMetadata()) != null) {
            return CredentialsUtils.upsertCredential(secret, metadata.getNamespace(), metadata.getName());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String upsertCredential(Secret secret, String namespace, String secretName) throws IOException {
        String id = CredentialsUtils.secretName(namespace, secretName);
        if (secret != null) {
            Credentials credentials = CredentialsUtils.secretToCredentials(secret);
            if (credentials == null) {
                throw new InvalidSecretException(secret.getKind());
            }
            Credentials existingCredentials = CredentialsUtils.lookupCredentials(id);
            SecurityContext previousContext = ACL.impersonate((Authentication)ACL.SYSTEM);
            try {
                CredentialsStore s = (CredentialsStore)CredentialsProvider.lookupStores((ModelObject)Jenkins.getInstance()).iterator().next();
                if (existingCredentials != null) {
                    s.updateCredentials(Domain.global(), existingCredentials, credentials);
                    logger.info("Updated credential " + id + " from Secret " + NamespaceName.create((HasMetadata)secret) + " with revision: " + secret.getMetadata().getResourceVersion());
                } else {
                    s.addCredentials(Domain.global(), credentials);
                    logger.info("Created credential " + id + " from Secret " + NamespaceName.create((HasMetadata)secret) + " with revision: " + secret.getMetadata().getResourceVersion());
                }
                s.save();
            }
            finally {
                SecurityContextHolder.setContext((SecurityContext)previousContext);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteCredential(String id, NamespaceName name, String resourceRevision) throws IOException {
        Credentials existingCred = CredentialsUtils.lookupCredentials(id);
        if (existingCred != null) {
            SecurityContext previousContext = ACL.impersonate((Authentication)ACL.SYSTEM);
            try {
                Fingerprint fp = CredentialsProvider.getFingerprintOf((Credentials)existingCred);
                if (fp != null && fp.getJobs().size() > 0) {
                    StringBuffer sb = new StringBuffer();
                    for (String job : fp.getJobs()) {
                        sb.append(job).append(" ");
                    }
                    logger.info("About to delete credential " + id + "which is referenced by jobs: " + sb.toString());
                }
                CredentialsStore s = (CredentialsStore)CredentialsProvider.lookupStores((ModelObject)Jenkins.getInstance()).iterator().next();
                s.removeCredentials(Domain.global(), existingCred);
                logger.info("Deleted credential " + id + " from Secret " + name + " with revision: " + resourceRevision);
                s.save();
            }
            finally {
                SecurityContextHolder.setContext((SecurityContext)previousContext);
            }
        }
    }

    public static void deleteCredential(Secret secret) throws IOException {
        if (secret != null) {
            String id = CredentialsUtils.secretName(secret.getMetadata().getNamespace(), secret.getMetadata().getName());
            CredentialsUtils.deleteCredential(id, NamespaceName.create((HasMetadata)secret), secret.getMetadata().getResourceVersion());
        }
    }

    public static String getCurrentToken() {
        if (AlaudaSyncGlobalConfiguration.get() == null) {
            logger.info("global plugin configuration is null");
            return "";
        }
        String credentialsId = AlaudaSyncGlobalConfiguration.get().getCredentialsId();
        if (credentialsId.equals("")) {
            return "";
        }
        String token = CredentialsUtils.getToken(credentialsId);
        return token == null ? "" : token;
    }

    public static String getToken(String credentialId) {
        AlaudaToken token = (AlaudaToken)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(AlaudaToken.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialId));
        if (token != null) {
            return token.getToken();
        }
        return null;
    }

    public static Credentials lookupCredentials(String id) {
        return CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(Credentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)id));
    }

    private static String secretName(String namespace, String name) {
        return namespace + "-" + name;
    }

    private static Credentials secretToCredentials(Secret secret) {
        String namespace = secret.getMetadata().getNamespace();
        String name = secret.getMetadata().getName();
        Map data = secret.getData();
        if (data == null) {
            logger.log(Level.WARNING, "An Kubernetes secret was marked for import, but it has no secret data.  No credential will be created.");
            return null;
        }
        String secretName = CredentialsUtils.secretName(namespace, name);
        switch (secret.getType()) {
            case "Opaque": {
                String usernameData = (String)data.get("username");
                String passwordData = (String)data.get("password");
                if (StringUtils.isNotBlank((String)usernameData) && StringUtils.isNotBlank((String)passwordData)) {
                    return CredentialsUtils.newUsernamePasswordCredentials(secretName, usernameData, passwordData);
                }
                String sshKeyData = (String)data.get("ssh-privatekey");
                if (StringUtils.isNotBlank((String)sshKeyData)) {
                    return CredentialsUtils.newSSHUserCredential(secretName, (String)data.get("username"), sshKeyData);
                }
                logger.log(Level.WARNING, "Opaque secret either requires {0} and {1} fields for basic auth or {2} field for SSH key", new Object[]{"username", "password", "ssh-privatekey"});
                return null;
            }
            case "kubernetes.io/basic-auth": {
                return CredentialsUtils.newUsernamePasswordCredentials(secretName, (String)data.get("username"), (String)data.get("password"));
            }
            case "kubernetes.io/ssh-auth": {
                return CredentialsUtils.newSSHUserCredential(secretName, (String)data.get("username"), (String)data.get("ssh-privatekey"));
            }
            case "kubernetes.io/dockerconfigjson": {
                String dockerData = (String)data.get(".dockerconfigjson");
                return CredentialsUtils.newDockerCredentials(secretName, dockerData);
            }
            case "kubernetes.io/service-account-token": {
                String token = (String)secret.getData().get("token");
                return CredentialsUtils.newTokenCredentials(secretName, token);
            }
            case "devops.alauda.io/oauth2": {
                String accessTokenKey = (String)secret.getData().get("accessTokenKey");
                String clientSecret = (String)secret.getData().get("accessToken");
                return CredentialsUtils.newOauth2Credentials(secretName, accessTokenKey, clientSecret);
            }
        }
        logger.log(Level.WARNING, "Unknown secret type: " + secret.getType());
        return null;
    }

    private static Credentials newSSHUserCredential(String secretName, String username, String sshKeyData) {
        if (secretName == null || secretName.length() == 0 || sshKeyData == null || sshKeyData.length() == 0) {
            logger.log(Level.WARNING, "Invalid secret data, secretName: " + secretName + " sshKeyData is null: " + (sshKeyData == null) + " sshKeyData is empty: " + (sshKeyData != null ? sshKeyData.length() == 0 : false));
            return null;
        }
        return new BasicSSHUserPrivateKey(CredentialsScope.GLOBAL, secretName, Util.fixNull((String)username), (BasicSSHUserPrivateKey.PrivateKeySource)new BasicSSHUserPrivateKey.DirectEntryPrivateKeySource(new String(Base64.decode((String)sshKeyData), StandardCharsets.UTF_8)), null, secretName);
    }

    private static Credentials newUsernamePasswordCredentials(String secretName, String usernameData, String passwordData) {
        if (secretName == null || secretName.length() == 0 || usernameData == null || usernameData.length() == 0 || passwordData == null || passwordData.length() == 0) {
            logger.log(Level.WARNING, "Invalid secret data, secretName: " + secretName + " usernameData is null: " + (usernameData == null) + " usernameData is empty: " + (usernameData != null ? usernameData.length() == 0 : false) + " passwordData is null: " + (passwordData == null) + " passwordData is empty: " + (passwordData != null ? passwordData.length() == 0 : false));
            return null;
        }
        return new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, secretName, secretName, new String(Base64.decode((String)usernameData), StandardCharsets.UTF_8), new String(Base64.decode((String)passwordData), StandardCharsets.UTF_8));
    }

    public static Credentials newTokenCredentials(String secretName, String token) {
        token = new String(Base64.decode((String)token), StandardCharsets.UTF_8);
        hudson.util.Secret secret = hudson.util.Secret.fromString((String)token);
        return new AlaudaToken(CredentialsScope.GLOBAL, secretName, null, secret);
    }

    private static Credentials newOauth2Credentials(String secretName, String accessTokenKey, String clientSecret) {
        return CredentialsUtils.newUsernamePasswordCredentials(secretName, accessTokenKey, clientSecret);
    }

    private static Credentials newDockerCredentials(String secretName, String dockerData) {
        if (secretName == null || secretName.length() == 0 || dockerData == null || dockerData.length() == 0) {
            logger.log(Level.WARNING, "Invalid secret data, secretName: " + secretName + " dockerData is null: " + (dockerData == null));
            return null;
        }
        dockerData = new String(Base64.decode((String)dockerData), StandardCharsets.UTF_8);
        try {
            JSONObject obj = new JSONObject(dockerData);
            JSONObject auths = obj.getJSONObject("auths");
            if (auths == null) {
                throw new Exception("Auths key in dockerconfig is null: " + dockerData);
            }
            while (auths.keys().hasNext()) {
                JSONObject authData;
                String key = (String)auths.keys().next();
                if (key == null || key.length() == 0 || (authData = auths.getJSONObject(key)) == null) continue;
                String username = authData.getString("username");
                String password = authData.getString("password");
                logger.info(String.format("Username: %s password: ***", username));
                if (StringUtils.isEmpty((String)username) || StringUtils.isEmpty((String)password)) {
                    logger.log(Level.WARNING, "Invalid docker data, secretName: " + secretName + " username is empty? " + StringUtils.isEmpty((String)username) + " password is empty?" + StringUtils.isEmpty((String)password));
                }
                return new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, secretName, secretName, username, password);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Invalid docker data, secretName: " + secretName + " dockerData is " + dockerData + " e:" + e, e);
            return null;
        }
        return null;
    }

    public static boolean hasCredentials() {
        AlaudaDevOpsClient client = AlaudaUtils.getAuthenticatedAlaudaClient();
        if (client == null) {
            return false;
        }
        return !StringUtils.isEmpty((String)client.getConfiguration().getOauthToken());
    }
}

