/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.listener;

import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.workflow.rest.external.AtomFlowNodeExt;
import com.cloudbees.workflow.rest.external.FlowNodeExt;
import com.cloudbees.workflow.rest.external.PendingInputActionsExt;
import com.cloudbees.workflow.rest.external.RunExt;
import com.cloudbees.workflow.rest.external.StageNodeExt;
import com.cloudbees.workflow.rest.external.StatusExt;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Predicate;
import com.jenkinsci.plugins.badge.action.BadgeAction;
import hudson.Extension;
import hudson.PluginManager;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.triggers.SafeTimerTask;
import io.alauda.devops.client.AlaudaDevOpsClient;
import io.alauda.devops.client.dsl.PipelineResource;
import io.alauda.jenkins.devops.sync.AlaudaSyncGlobalConfiguration;
import io.alauda.jenkins.devops.sync.JenkinsPipelineCause;
import io.alauda.jenkins.devops.sync.util.AlaudaUtils;
import io.alauda.jenkins.devops.sync.util.JenkinsUtils;
import io.alauda.jenkins.devops.sync.util.PipelineUtils;
import io.alauda.jenkins.devops.sync.util.WorkflowJobUtils;
import io.alauda.kubernetes.api.model.Pipeline;
import io.alauda.kubernetes.api.model.PipelineStatus;
import io.alauda.kubernetes.api.model.PipelineStatusBuilder;
import io.alauda.kubernetes.api.model.PipelineStatusJenkins;
import io.alauda.kubernetes.api.model.PipelineStatusJenkinsBuilder;
import io.alauda.kubernetes.client.KubernetesClientException;
import io.alauda.kubernetes.client.dsl.NonNamespaceOperation;
import io.jenkins.blueocean.rest.factory.BlueRunFactory;
import io.jenkins.blueocean.rest.model.BluePipelineNode;
import io.jenkins.blueocean.rest.model.BluePipelineStep;
import io.jenkins.blueocean.rest.model.BlueRun;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import jenkins.model.Jenkins;
import jenkins.util.Timer;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.support.steps.input.InputAction;
import org.jenkinsci.plugins.workflow.support.steps.input.InputStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

@Extension
public class PipelineSyncRunListener
extends RunListener<Run> {
    private static final Logger logger = Logger.getLogger(PipelineSyncRunListener.class.getName());
    private long pollPeriodMs = 5000L;
    private long delayPollPeriodMs = 1000L;
    private static final long maxDelay = 30000L;
    private transient Set<Run> runsToPoll = new CopyOnWriteArraySet<Run>();
    private transient AtomicBoolean timerStarted = new AtomicBoolean(false);
    private transient AtomicBoolean unSyncedTimerStarted = new AtomicBoolean(false);

    public PipelineSyncRunListener() {
    }

    @DataBoundConstructor
    public PipelineSyncRunListener(long pollPeriodMs) {
        this.pollPeriodMs = pollPeriodMs;
    }

    public static String joinPaths(String ... strings) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            sb.append(strings[i]);
            if (i >= strings.length - 1) continue;
            sb.append("/");
        }
        String joined = sb.toString();
        return joined.replaceAll("/+", "/").replaceAll("/\\?", "?").replaceAll("/#", "#").replaceAll(":/", "://");
    }

    public void onInitialize(Run run) {
        super.onInitialize(run);
    }

    public void onStarted(Run run, TaskListener listener) {
        if (this.shouldPollRun(run)) {
            try {
                JenkinsPipelineCause cause = (JenkinsPipelineCause)run.getCause(JenkinsPipelineCause.class);
                if (cause != null) {
                    run.setDescription(cause.getShortDescription());
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Cannot set build description: " + e);
            }
            if (this.runsToPoll.add(run)) {
                logger.info("starting polling build " + run.getUrl());
            }
            this.checkTimerStarted();
        } else {
            logger.fine("not polling polling pipeline " + run.getUrl() + " as its not a WorkflowJob");
        }
    }

    protected void checkTimerStarted() {
        if (this.timerStarted.compareAndSet(false, true)) {
            Timer.get().scheduleAtFixedRate((Runnable)new SafeTimerTask(){

                protected void doRun() throws Exception {
                    PipelineSyncRunListener.this.pollLoop();
                }
            }, this.delayPollPeriodMs, this.pollPeriodMs, TimeUnit.MILLISECONDS);
        }
        if (this.unSyncedTimerStarted.compareAndSet(false, true)) {
            Timer.get().scheduleAtFixedRate((Runnable)new SafeTimerTask(){

                protected void doRun() throws Exception {
                    PipelineSyncRunListener.this.findUnSyncedRecords();
                }
            }, this.delayPollPeriodMs, this.pollPeriodMs * 20L, TimeUnit.MILLISECONDS);
        }
    }

    private void findUnSyncedRecords() {
        List folders = Jenkins.getInstance().getItems(Folder.class);
        if (folders == null) {
            return;
        }
        folders.forEach(folder -> {
            Collection jobs = folder.getAllJobs();
            if (jobs == null) {
                return;
            }
            jobs.forEach(job -> {
                if (WorkflowJobUtils.hasNotAlaudaProperty(job)) {
                    return;
                }
                job.getBuilds().filter((Predicate)new UnSyncedBuild()).forEach(run -> {
                    if (run instanceof Run) {
                        this.runsToPoll.add((Run)run);
                    }
                });
            });
        });
    }

    public void onCompleted(Run run, @Nonnull TaskListener listener) {
        if (this.shouldPollRun(run)) {
            try {
                this.pollRun(run);
                this.runsToPoll.remove(run);
                logger.info("onCompleted " + run.getUrl());
                JenkinsUtils.maybeScheduleNext((WorkflowJob)((WorkflowRun)run).getParent());
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void onDeleted(Run run) {
        if (!this.shouldPollRun(run)) {
            return;
        }
        JenkinsPipelineCause cause = (JenkinsPipelineCause)run.getCause(JenkinsPipelineCause.class);
        if (cause != null) {
            String namespace = cause.getNamespace();
            String pipelineName = cause.getName();
            boolean result = false;
            try {
                result = PipelineUtils.delete(namespace, pipelineName);
            }
            catch (KubernetesClientException e) {
                logger.warning(e.getMessage());
            }
            int buildNum = run.getNumber();
            logger.info("Delete `Pipeline` result is: " + result + "; name is: " + pipelineName + "; buildNum is: " + buildNum);
        }
        this.runsToPoll.remove(run);
        logger.info("onDeleted " + run.getUrl());
    }

    public synchronized void onFinalized(Run run) {
        if (this.shouldPollRun(run)) {
            try {
                this.pollRun(run);
                this.runsToPoll.remove(run);
                logger.info("onFinalized " + run.getUrl());
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void pollLoop() {
        for (Run run : this.runsToPoll) {
            try {
                this.pollRun(run);
                this.runsToPoll.remove(run);
            }
            catch (KubernetesClientException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private synchronized void pollRun(Run run) throws TimeoutException, InterruptedException {
        if (!(run instanceof WorkflowRun)) {
            throw new IllegalStateException("Cannot poll a non-workflow run");
        }
        RunExt wfRunExt = RunExt.create((WorkflowRun)((WorkflowRun)run));
        BlueRun blueRun = null;
        try {
            blueRun = BlueRunFactory.getRun((Run)run, null);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "pollRun", t);
        }
        try {
            this.upsertPipeline(run, wfRunExt, blueRun);
        }
        catch (KubernetesClientException e) {
            if (e.getCode() == 422) {
                this.runsToPoll.remove(run);
                logger.log(Level.WARNING, "Cannot update status: {0}", e.getMessage());
                return;
            }
            throw e;
        }
    }

    private boolean shouldUpdatePipeline(JenkinsPipelineCause cause, int latestStageNum, int latestNumFlowNodes, StatusExt status) {
        long currTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        logger.fine(String.format("shouldUpdatePipeline curr time %s last update %s curr stage num %s last stage num %scurr flow num %s last flow num %s status %s", String.valueOf(currTime), String.valueOf(cause.getLastUpdateToAlaudaDevOps()), String.valueOf(latestStageNum), String.valueOf(cause.getNumStages()), String.valueOf(latestNumFlowNodes), String.valueOf(cause.getNumFlowNodes()), status.toString()));
        if (currTime > cause.getLastUpdateToAlaudaDevOps() + 30000L) {
            return true;
        }
        if (cause.getNumStages() != latestStageNum) {
            return true;
        }
        if (cause.getNumFlowNodes() != latestNumFlowNodes) {
            return true;
        }
        return status != StatusExt.IN_PROGRESS;
    }

    private String toBlueJson(@NotNull PipelineJson pipeJson) {
        ObjectMapper blueJsonMapper = new ObjectMapper();
        blueJsonMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        blueJsonMapper.disable(SerializationFeature.FAIL_ON_SELF_REFERENCES);
        try {
            return blueJsonMapper.writeValueAsString((Object)pipeJson);
        }
        catch (JsonProcessingException e) {
            logger.log(Level.SEVERE, "Failed to serialize blueJson run. " + (Object)((Object)e), e);
            logger.log(Level.SEVERE, "blueJson data: " + pipeJson);
            return null;
        }
    }

    private void upsertPipeline(Run run, RunExt wfRunExt, BlueRun blueRun) throws TimeoutException, InterruptedException {
        String logsBlueOceanUrl;
        String logsConsoleUrl;
        String logsUrl;
        String buildUrl;
        String rootUrl;
        String namespace;
        JenkinsPipelineCause cause;
        AlaudaDevOpsClient client;
        block25: {
            if (run == null) {
                return;
            }
            client = AlaudaUtils.getAuthenticatedAlaudaClient();
            if (client == null) {
                return;
            }
            cause = (JenkinsPipelineCause)run.getCause(JenkinsPipelineCause.class);
            if (cause == null) {
                return;
            }
            namespace = cause.getNamespace();
            rootUrl = AlaudaUtils.getJenkinsURL(client, namespace);
            buildUrl = PipelineSyncRunListener.joinPaths(rootUrl, run.getUrl());
            logsUrl = PipelineSyncRunListener.joinPaths(buildUrl, "/consoleText");
            logsConsoleUrl = PipelineSyncRunListener.joinPaths(buildUrl, "/console");
            logsBlueOceanUrl = null;
            try {
                ClassLoader cl;
                PluginManager pluginMgr;
                Jenkins jenkins = Jenkins.getInstance();
                if (jenkins != null && (pluginMgr = jenkins.getPluginManager()) != null && (cl = pluginMgr.uberClassLoader) != null) {
                    Class<?> weburlbldr = cl.loadClass("org.jenkinsci.plugins.blueoceandisplayurl.BlueOceanDisplayURLImpl");
                    Constructor<?> ctor = weburlbldr.getConstructor(new Class[0]);
                    Object displayURL = ctor.newInstance(new Object[0]);
                    Method getRunURLMethod = weburlbldr.getMethod("getRunURL", Run.class);
                    Object blueOceanURI = getRunURLMethod.invoke(displayURL, run);
                    logsBlueOceanUrl = blueOceanURI.toString();
                    logsBlueOceanUrl = (logsBlueOceanUrl = logsBlueOceanUrl.replaceAll("http://unconfigured-jenkins-location/", "")).startsWith("http://") || logsBlueOceanUrl.startsWith("https://") ? PipelineSyncRunListener.joinPaths("", logsBlueOceanUrl) : PipelineSyncRunListener.joinPaths(rootUrl, logsBlueOceanUrl);
                }
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.FINE)) break block25;
                logger.log(Level.FINE, "upsertPipeline", t);
            }
        }
        HashMap<String, BlueRun.BlueRunResult> blueRunResults = new HashMap<String, BlueRun.BlueRunResult>();
        PipelineJson pipeJson = new PipelineJson();
        HashMap<String, PipelineStage> stageMap = new HashMap<String, PipelineStage>();
        try {
            if (blueRun != null && blueRun.getNodes() != null) {
                for (BluePipelineNode node : blueRun.getNodes()) {
                    if (node == null) continue;
                    BlueRun.BlueRunResult result = node.getResult();
                    BlueRun.BlueRunState state = node.getStateObj();
                    PipelineStage pipeStage = new PipelineStage(node.getId(), node.getDisplayName(), state != null ? state.name() : "NOT_BUILT", result != null ? result.name() : "UNKNOWN", node.getStartTimeString(), node.getDurationInMillis(), 0L, node.getEdges());
                    stageMap.put(node.getDisplayName(), pipeStage);
                    pipeJson.addStage(pipeStage);
                    blueRunResults.put(node.getDisplayName(), node.getResult());
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to fetch stages from blue ocean API. " + e, e);
        }
        if (!wfRunExt.get_links().self.href.matches("^https?://.*$")) {
            wfRunExt.get_links().self.setHref(PipelineSyncRunListener.joinPaths(rootUrl, wfRunExt.get_links().self.href));
        }
        int newNumStages = wfRunExt.getStages().size();
        int newNumFlowNodes = 0;
        ArrayList<StageNodeExt> validStageList = new ArrayList<StageNodeExt>();
        ArrayList blueStages = new ArrayList();
        for (StageNodeExt stage : wfRunExt.getStages()) {
            PipelineStage pipeStage;
            BlueRun.BlueRunResult result = (BlueRun.BlueRunResult)blueRunResults.get(stage.getName());
            if (result != null && result == BlueRun.BlueRunResult.NOT_BUILT) {
                logger.info("skipping stage " + stage.getName() + " for the status JSON for pipeline run " + run.getDisplayName() + " because it was not executed (most likely because of a failure in another stage)");
                continue;
            }
            validStageList.add(stage);
            FlowNodeExt.FlowNodeLinks links = stage.get_links();
            if (!links.self.href.matches("^https?://.*$")) {
                links.self.setHref(PipelineSyncRunListener.joinPaths(rootUrl, links.self.href));
            }
            if (links.getLog() != null && !links.getLog().href.matches("^https?://.*$")) {
                links.getLog().setHref(PipelineSyncRunListener.joinPaths(rootUrl, links.getLog().href));
            }
            newNumFlowNodes += stage.getStageFlowNodes().size();
            for (AtomFlowNodeExt node : stage.getStageFlowNodes()) {
                FlowNodeExt.FlowNodeLinks nodeLinks = node.get_links();
                if (!nodeLinks.self.href.matches("^https?://.*$")) {
                    nodeLinks.self.setHref(PipelineSyncRunListener.joinPaths(rootUrl, nodeLinks.self.href));
                }
                if (nodeLinks.getLog() == null || nodeLinks.getLog().href.matches("^https?://.*$")) continue;
                nodeLinks.getLog().setHref(PipelineSyncRunListener.joinPaths(rootUrl, nodeLinks.getLog().href));
            }
            StatusExt status = stage.getStatus();
            if (status == null || (pipeStage = (PipelineStage)stageMap.get(stage.getName())) == null) continue;
            pipeStage.pause_duration_millis = stage.getPauseDurationMillis();
        }
        wfRunExt.setStages(validStageList);
        boolean needToUpdate = this.shouldUpdatePipeline(cause, newNumStages, newNumFlowNodes, wfRunExt.getStatus());
        if (!needToUpdate) {
            return;
        }
        String json = null;
        try {
            json = new ObjectMapper().writeValueAsString((Object)wfRunExt);
        }
        catch (JsonProcessingException e) {
            logger.log(Level.SEVERE, "Failed to serialize workflow run. " + (Object)((Object)e), e);
        }
        String phase = this.runToPipelinePhase(run);
        long started = this.getStartTime(run);
        String startTime = null;
        String completionTime = null;
        String updatedTime = AlaudaUtils.getCurrentTimestamp();
        if (started > 0L) {
            startTime = AlaudaUtils.formatTimestamp(started);
            long duration = this.getDuration(run);
            if (duration > 0L) {
                completionTime = AlaudaUtils.formatTimestamp(started + duration);
            }
        }
        logger.log(Level.INFO, "Patching pipeline {0}/{1}: setting phase to {2}", new Object[]{cause.getNamespace(), cause.getName(), phase});
        Pipeline pipeline = (Pipeline)((PipelineResource)((NonNamespaceOperation)client.pipelines().inNamespace(cause.getNamespace())).withName(cause.getName())).get();
        if (pipeline == null) {
            cause.setSynced(false);
            logger.warning(() -> String.format("Pipeline name[%s], namesapce[%s] don't exists", cause.getName(), cause.getNamespace()));
            return;
        }
        String blueJson = this.toBlueJson(pipeJson);
        Map annotations = pipeline.getMetadata().getAnnotations();
        annotations.put("alauda.io/jenkins-status-json", json);
        annotations.put("alauda.io/jenkins-stages-json", blueJson);
        annotations.put("alauda.io/jenkins-build-uri", buildUrl);
        annotations.put("alauda.io/jenkins-log-url", logsUrl);
        annotations.put("alauda.io/jenkins-console-log-url", logsConsoleUrl);
        annotations.put("alauda.io/jenkins-blueocean-log-url", logsBlueOceanUrl);
        pipeline.getMetadata().setAnnotations(annotations);
        this.badgeHandle(run, annotations);
        PipelineStatus status = this.createPipelineStatus(pipeline, phase, startTime, completionTime, updatedTime, blueJson, run, wfRunExt);
        pipeline.setStatus(status);
        try {
            Pipeline result = (Pipeline)((PipelineResource)((NonNamespaceOperation)client.pipelines().inNamespace(namespace)).withName(pipeline.getMetadata().getName())).patch((Object)pipeline);
            logger.fine("updated pipeline: " + result);
        }
        catch (Exception e) {
            cause.setSynced(false);
            throw e;
        }
        cause.setNumFlowNodes(newNumFlowNodes);
        cause.setNumStages(newNumStages);
        cause.setLastUpdateToAlaudaDevOps(TimeUnit.NANOSECONDS.toMillis(System.nanoTime()));
    }

    private void badgeHandle(@NotNull Run run, Map<String, String> annotations) {
        if (annotations == null) {
            return;
        }
        JSONArray jsonArray = new JSONArray();
        List actions = run.getAllActions();
        actions.stream().filter(action -> action instanceof BadgeAction).forEach(action -> {
            BadgeAction badgeAction = (BadgeAction)action;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("text", (Object)badgeAction.getText());
            jsonObject.put("displayName", (Object)badgeAction.getDisplayName());
            jsonObject.put("iconPath", (Object)badgeAction.getIconPath());
            jsonObject.put("iconFileName", (Object)badgeAction.getIconFileName());
            jsonObject.put("link", (Object)badgeAction.getLink());
            jsonObject.put("isTextOnly", (Object)badgeAction.isTextOnly());
            jsonArray.add((Object)jsonObject);
        });
        annotations.put("alauda.io/jenkins-badges", jsonArray.toString());
    }

    private PipelineStatus createPipelineStatus(Pipeline pipeline, String phase, String startTime, String completionTime, String updatedTime, String blueJson, Run run, RunExt wfRunExt) {
        PipelineStatus status = pipeline.getStatus();
        if (status == null) {
            status = new PipelineStatusBuilder().build();
        }
        status.setPhase(phase);
        status.setStartedAt(startTime);
        status.setFinishedAt(completionTime);
        status.setUpdatedAt(updatedTime);
        PipelineStatusJenkins statusJenkins = status.getJenkins();
        if (statusJenkins == null) {
            statusJenkins = new PipelineStatusJenkinsBuilder().build();
        }
        status.setJenkins(statusJenkins);
        statusJenkins.setBuild(String.valueOf(this.getRunNumber(run)));
        if (blueJson != null) {
            statusJenkins.setStages(blueJson);
        }
        statusJenkins.setResult(this.getRunResult(run));
        statusJenkins.setStatus(wfRunExt.getStatus().name());
        return status;
    }

    private String getPendingActionsJson(WorkflowRun run) throws TimeoutException, InterruptedException {
        List executions;
        ArrayList<PendingInputActionsExt> pendingInputActions = new ArrayList<PendingInputActionsExt>();
        InputAction inputAction = (InputAction)run.getAction(InputAction.class);
        if (inputAction != null && (executions = inputAction.getExecutions()) != null && !executions.isEmpty()) {
            for (InputStepExecution inputStepExecution : executions) {
                pendingInputActions.add(PendingInputActionsExt.create((InputStepExecution)inputStepExecution, (WorkflowRun)run));
            }
        }
        try {
            return new ObjectMapper().writeValueAsString(pendingInputActions);
        }
        catch (JsonProcessingException e) {
            logger.log(Level.SEVERE, "Failed to serialize pending actions. " + (Object)((Object)e), e);
            return null;
        }
    }

    private long getStartTime(Run run) {
        return run.getStartTimeInMillis();
    }

    private long getDuration(Run run) {
        return run.getDuration();
    }

    @Deprecated
    private String runToPipelinePhase(Run run) {
        if (run != null && !run.hasntStartedYet()) {
            if (run.isBuilding()) {
                return "Running";
            }
            Result result = run.getResult();
            if (result != null) {
                if (result.equals(Result.SUCCESS)) {
                    return "Complete";
                }
                if (result.equals(Result.ABORTED)) {
                    return "Cancelled";
                }
                if (result.equals(Result.FAILURE)) {
                    return "Failed";
                }
                if (result.equals(Result.UNSTABLE)) {
                    return "Failed";
                }
                return "Queued";
            }
        }
        return "Pending";
    }

    private String getRunResult(Run run) {
        Result result = run.getResult();
        if (result != null) {
            return result.toString();
        }
        return Result.NOT_BUILT.toString();
    }

    private String getRunStatus(Run run) {
        if (run.hasntStartedYet()) {
            return "QUEUED";
        }
        if (run.isBuilding()) {
            return "RUNNING";
        }
        if (!run.isLogUpdated()) {
            return "FINISHED";
        }
        return "SKIPPED";
    }

    private int getRunNumber(Run run) {
        return run.getNumber();
    }

    protected boolean shouldPollRun(Run run) {
        return run instanceof WorkflowRun && run.getCause(JenkinsPipelineCause.class) != null && AlaudaSyncGlobalConfiguration.get().isEnabled();
    }

    private static class PipelineStage {
        public String id;
        public String name;
        public String status;
        public String result;
        public String start_time;
        public Long duration_millis;
        public Long pause_duration_millis;
        public List<BluePipelineNode.Edge> edges;

        PipelineStage(String id, String name, String status, String result, String start_time, Long duration_millis, Long pause_duration_millis, List<BluePipelineNode.Edge> edges) {
            this.id = id;
            this.name = name;
            this.status = status;
            this.result = result;
            this.start_time = start_time;
            this.duration_millis = duration_millis;
            this.pause_duration_millis = pause_duration_millis;
            this.edges = edges;
        }
    }

    private static class PipelineJson {
        public String start_stage_id = null;
        public List<PipelineStage> stages = new ArrayList<PipelineStage>();

        public void addStage(PipelineStage stage) {
            if (this.start_stage_id == null) {
                this.start_stage_id = stage.id;
            }
            this.stages.add(stage);
        }
    }

    private static class BlueJsonStage {
        public StageNodeExt stage;
        public BlueRun.BlueRunResult result;
        public List<BluePipelineNode.Edge> edges;

        public BlueJsonStage(StageNodeExt stage, BlueRun.BlueRunResult result, List<BluePipelineNode.Edge> edges, List<BluePipelineStep> steps) {
            this.stage = stage;
            this.result = result;
            this.edges = edges;
        }
    }

    class UnSyncedBuild
    implements Predicate<Run> {
        UnSyncedBuild() {
        }

        public boolean apply(@Nullable Run run) {
            if (run == null) {
                return false;
            }
            JenkinsPipelineCause cause = (JenkinsPipelineCause)run.getCause(JenkinsPipelineCause.class);
            if (cause == null) {
                return false;
            }
            return !cause.isSynced();
        }
    }
}

