/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.listener;

import hudson.Extension;
import hudson.model.Cause;
import hudson.model.Queue;
import hudson.model.queue.QueueListener;
import io.alauda.devops.client.dsl.PipelineResource;
import io.alauda.jenkins.devops.sync.JenkinsPipelineCause;
import io.alauda.jenkins.devops.sync.util.AlaudaUtils;
import io.alauda.kubernetes.api.model.DoneablePipeline;
import io.alauda.kubernetes.api.model.PipelineFluent;
import io.alauda.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.List;
import java.util.logging.Logger;

@Extension
public class PipelineQueueListener
extends QueueListener {
    private static final Logger logger = Logger.getLogger(PipelineQueueListener.class.getName());

    public void onLeft(Queue.LeftItem leftItem) {
        super.onLeft(leftItem);
        boolean isCancelled = leftItem.isCancelled();
        if (!isCancelled) {
            return;
        }
        JenkinsPipelineCause pipelineCause = null;
        List causes = leftItem.getCauses();
        if (causes != null) {
            for (Cause cause : causes) {
                if (!(cause instanceof JenkinsPipelineCause)) continue;
                pipelineCause = (JenkinsPipelineCause)cause;
            }
        }
        String itemUrl = leftItem.getUrl();
        if (pipelineCause != null) {
            String namespace = pipelineCause.getNamespace();
            String name = pipelineCause.getName();
            ((DoneablePipeline)((PipelineFluent.StatusNested)((DoneablePipeline)((PipelineResource)((NonNamespaceOperation)AlaudaUtils.getAuthenticatedAlaudaClient().pipelines().inNamespace(namespace)).withName(name)).edit()).editOrNewStatus().withAborted(Boolean.TRUE)).endStatus()).done();
            logger.info("Item " + leftItem + " already sync with alauda'resource.");
        } else {
            logger.warning("Can not found JenkinsPipelineCause, item url: " + itemUrl);
        }
    }
}

