/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.listener;

import com.google.common.base.Objects;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.listeners.ItemListener;
import io.alauda.devops.client.AlaudaDevOpsClient;
import io.alauda.devops.client.dsl.PipelineConfigResource;
import io.alauda.jenkins.devops.sync.AlaudaSyncGlobalConfiguration;
import io.alauda.jenkins.devops.sync.PipelineConfigProjectProperty;
import io.alauda.jenkins.devops.sync.PipelineConfigToJobMapper;
import io.alauda.jenkins.devops.sync.util.AlaudaUtils;
import io.alauda.jenkins.devops.sync.util.JenkinsUtils;
import io.alauda.jenkins.devops.sync.util.NamespaceName;
import io.alauda.jenkins.devops.sync.util.PipelineConfigToJobMap;
import io.alauda.jenkins.devops.sync.watcher.PipelineConfigWatcher;
import io.alauda.kubernetes.api.model.DoneablePipelineConfig;
import io.alauda.kubernetes.api.model.HasMetadata;
import io.alauda.kubernetes.api.model.Namespace;
import io.alauda.kubernetes.api.model.ObjectMeta;
import io.alauda.kubernetes.api.model.PipelineConfig;
import io.alauda.kubernetes.api.model.PipelineConfigBuilder;
import io.alauda.kubernetes.api.model.PipelineConfigFluent;
import io.alauda.kubernetes.api.model.PipelineConfigSpec;
import io.alauda.kubernetes.api.model.PipelineConfigSpecFluent;
import io.alauda.kubernetes.api.model.PipelineSource;
import io.alauda.kubernetes.api.model.PipelineSourceGit;
import io.alauda.kubernetes.api.model.PipelineStrategy;
import io.alauda.kubernetes.api.model.PipelineStrategyJenkins;
import io.alauda.kubernetes.client.KubernetesClientException;
import io.alauda.kubernetes.client.dsl.NonNamespaceOperation;
import io.alauda.kubernetes.client.dsl.Resource;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.kohsuke.stapler.DataBoundConstructor;

@Extension
public class JenkinsPipelineJobListener
extends ItemListener {
    private static final Logger logger = Logger.getLogger(JenkinsPipelineJobListener.class.getName());
    private String server;
    private String[] namespaces;
    private String jenkinsService;
    private String jobNamePattern;

    public JenkinsPipelineJobListener() {
        this.reconfigure();
    }

    @DataBoundConstructor
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public JenkinsPipelineJobListener(String server, String jenkinsService, String jobNamePattern) {
        this.server = server;
        this.jenkinsService = jenkinsService;
        this.jobNamePattern = jobNamePattern;
        this.init();
    }

    private void init() {
        AlaudaDevOpsClient client = AlaudaUtils.getAlaudaClient();
        if (client == null) {
            logger.severe("Can't get AlaudaDevOpsClient when init JenkinsPipelineJobListener.");
            return;
        }
        this.namespaces = AlaudaUtils.getNamespaceOrUseDefault(this.jenkinsService, client);
    }

    public void onCreated(Item item) {
        if (!AlaudaSyncGlobalConfiguration.get().isEnabled()) {
            return;
        }
        this.reconfigure();
        super.onCreated(item);
        this.upsertItem(item);
    }

    public void onUpdated(Item item) {
        if (!AlaudaSyncGlobalConfiguration.get().isEnabled()) {
            return;
        }
        this.reconfigure();
        this.upsertItem(item);
        super.onUpdated(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void onDeleted(Item item) {
        JenkinsPipelineJobListener.logger.info("onDelete: Item: " + item);
        if (!AlaudaSyncGlobalConfiguration.get().isEnabled()) {
            JenkinsPipelineJobListener.logger.info("no configuration... onDelete ignored...");
            return;
        }
        super.onDeleted(item);
        client = AlaudaUtils.getAuthenticatedAlaudaClient();
        if (client == null) {
            JenkinsPipelineJobListener.logger.severe("alauda client is null, stop from onDeleted.");
            return;
        }
        if (item instanceof WorkflowJob && (property = this.pipelineConfigProjectForJob(job = (WorkflowJob)item)) != null) {
            pipelineName = AlaudaUtils.pipelineConfigNameFromJenkinsJobName(property.getName(), property.getNamespace());
            namespace = pipelineName.getNamespace();
            pipelineConfigName = pipelineName.getName();
            pipelineConfig = (PipelineConfig)((PipelineConfigResource)((NonNamespaceOperation)client.pipelineConfigs().inNamespace(namespace)).withName(pipelineConfigName)).get();
            if (pipelineConfig != null) {
                JenkinsPipelineJobListener.logger.info((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$onDeleted$0(java.lang.String java.lang.String ), ()Ljava/lang/String;)((String)namespace, (String)pipelineConfigName));
                try {
                    ((PipelineConfigResource)((NonNamespaceOperation)client.pipelineConfigs().inNamespace(namespace)).withName(pipelineConfigName)).delete();
                    JenkinsPipelineJobListener.logger.info((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$onDeleted$1(java.lang.String java.lang.String ), ()Ljava/lang/String;)((String)namespace, (String)pipelineConfigName));
                }
                catch (KubernetesClientException e) {
                    if (404 == e.getCode()) ** GOTO lbl33
                    JenkinsPipelineJobListener.logger.log(Level.WARNING, "Failed to delete PipelineConfig in namespace: " + namespace + " for name: " + pipelineConfigName, e);
                }
                catch (Exception e) {
                    JenkinsPipelineJobListener.logger.log(Level.WARNING, "Failed to delete PipelineConfig in namespace: " + namespace + " for name: " + pipelineConfigName, e);
                }
                finally {
                    PipelineConfigToJobMap.removeJobWithPipelineConfig(pipelineConfig);
                }
            } else {
                JenkinsPipelineJobListener.logger.info((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$onDeleted$2(java.lang.String java.lang.String ), ()Ljava/lang/String;)((String)namespace, (String)pipelineConfigName));
            }
        }
lbl33:
        // 7 sources

        this.reconfigure();
    }

    public void upsertItem(Item item) {
        if (item instanceof WorkflowJob) {
            this.upsertWorkflowJob((WorkflowJob)item);
        } else if (item instanceof ItemGroup) {
            this.upsertItemGroup((ItemGroup)item);
        }
    }

    private void upsertItemGroup(ItemGroup itemGroup) {
        Collection items = itemGroup.getItems();
        if (items != null) {
            for (Object child : items) {
                if (child instanceof WorkflowJob) {
                    this.upsertWorkflowJob((WorkflowJob)child);
                    continue;
                }
                if (!(child instanceof ItemGroup)) continue;
                this.upsertItemGroup((ItemGroup)child);
            }
        }
    }

    private void upsertWorkflowJob(WorkflowJob job) {
        PipelineConfigProjectProperty property = this.pipelineConfigProjectForJob(job);
        if (this.canUpdate(job, property)) {
            logger.info(() -> "Upsert WorkflowJob " + job.getName() + " to PipelineConfig: " + property.getNamespace() + "/" + property.getName() + " in Alauda Kubernetes");
            this.upsertPipelineConfigForJob(job, property);
        }
    }

    private boolean canUpdate(WorkflowJob job, PipelineConfigProjectProperty property) {
        return property != null && this.isNotDeleteInProgress(property);
    }

    private boolean isNotDeleteInProgress(PipelineConfigProjectProperty property) {
        return !PipelineConfigWatcher.isDeleteInProgress(property.getNamespace() + property.getName());
    }

    private PipelineConfigProjectProperty pipelineConfigProjectForJob(WorkflowJob job) {
        PipelineConfigProjectProperty property = (PipelineConfigProjectProperty)job.getProperty(PipelineConfigProjectProperty.class);
        if (property != null && StringUtils.isNotBlank((String)property.getNamespace()) && StringUtils.isNotBlank((String)property.getName())) {
            logger.info("Found PipelineConfigProjectProperty for namespace: " + property.getNamespace() + " name: " + property.getName());
            return property;
        }
        String patternRegex = this.jobNamePattern;
        String jobName = JenkinsUtils.getFullJobName(job);
        if (StringUtils.isNotEmpty((String)jobName) && StringUtils.isNotEmpty((String)patternRegex) && jobName.matches(patternRegex)) {
            String pipelineConfigName = AlaudaUtils.convertNameToValidResourceName(JenkinsUtils.getBuildConfigName(job));
            String uuid = null;
            String resourceVersion = null;
            String pipelineRunPolicy = "Serial";
            int n = 0;
            String[] stringArray = this.namespaces;
            int n2 = stringArray.length;
            if (n < n2) {
                String namespace = stringArray[n];
                logger.info("Creating PipelineConfigProjectProperty for namespace: " + namespace + " name: " + pipelineConfigName);
                if (property != null) {
                    property.setNamespace(namespace);
                    property.setName(pipelineConfigName);
                    return property;
                }
                return new PipelineConfigProjectProperty(namespace, pipelineConfigName, uuid, resourceVersion);
            }
        }
        return null;
    }

    private void upsertPipelineConfigForJob(WorkflowJob job, PipelineConfigProjectProperty pipelineConfigProjectProperty) {
        String uid;
        boolean create = false;
        AlaudaDevOpsClient client = AlaudaUtils.getAuthenticatedAlaudaClient();
        String namespace = pipelineConfigProjectProperty.getNamespace();
        String jobName = pipelineConfigProjectProperty.getName();
        if (client == null) {
            logger.warning("Can't get kubernetes client in method upsertPipelineConfigForJob.");
            return;
        }
        PipelineConfigResource pipelineConfigResource = (PipelineConfigResource)((NonNamespaceOperation)client.pipelineConfigs().inNamespace(namespace)).withName(jobName);
        PipelineConfig jobPipelineConfig = (PipelineConfig)pipelineConfigResource.get();
        if (jobPipelineConfig == null) {
            Namespace targetNS = (Namespace)((Resource)client.namespaces().withName(namespace)).get();
            String msg = String.format("There's not namespace with name: %s. Can't create PipelineConfig.", namespace);
            if (targetNS == null) {
                logger.severe(msg);
                return;
            }
            logger.info("Can't find PipelineConfig, will create. namespace:" + namespace + "; name: " + jobName);
            create = true;
            jobPipelineConfig = ((PipelineConfigBuilder)((PipelineConfigFluent.SpecNested)((PipelineConfigSpecFluent.StrategyNested)((PipelineConfigBuilder)((PipelineConfigFluent.MetadataNested)((PipelineConfigFluent.MetadataNested)((PipelineConfigFluent.MetadataNested)new PipelineConfigBuilder().withNewMetadata().withName(jobName)).withNamespace(namespace)).addToAnnotations("jenkins.alauda.io/generated-by", "jenkins")).endMetadata()).withNewSpec().withNewStrategy().withNewJenkins().endJenkins()).endStrategy()).endSpec()).build();
        } else {
            ObjectMeta metadata = jobPipelineConfig.getMetadata();
            if (metadata == null) {
                logger.warning("PipelineConfig's metadata is missing.");
                return;
            }
            uid = pipelineConfigProjectProperty.getUid();
            if (StringUtils.isEmpty((String)uid)) {
                pipelineConfigProjectProperty.setUid(metadata.getUid());
            } else if (!Objects.equal((Object)uid, (Object)metadata.getUid())) {
                return;
            }
        }
        PipelineConfigToJobMapper.updatePipelineConfigFromJob(job, jobPipelineConfig);
        if (!this.hasEmbeddedPipelineOrValidSource(jobPipelineConfig)) {
            return;
        }
        if (create) {
            AlaudaUtils.addAnnotation((HasMetadata)jobPipelineConfig, "jenkins.alauda.io/job-path", JenkinsUtils.getFullJobName(job));
            try {
                PipelineConfig pc = (PipelineConfig)((NonNamespaceOperation)client.pipelineConfigs().inNamespace(jobPipelineConfig.getMetadata().getNamespace())).create((Object[])new PipelineConfig[]{jobPipelineConfig});
                uid = pc.getMetadata().getUid();
                pipelineConfigProjectProperty.setUid(uid);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to create PipelineConfig: " + NamespaceName.create((HasMetadata)jobPipelineConfig) + ". " + e, e);
            }
        } else {
            try {
                PipelineConfigSpec spec = jobPipelineConfig.getSpec();
                ((DoneablePipelineConfig)((PipelineConfigFluent.SpecNested)((PipelineConfigFluent.SpecNested)((PipelineConfigFluent.SpecNested)((PipelineConfigFluent.SpecNested)((DoneablePipelineConfig)((PipelineConfigResource)((NonNamespaceOperation)client.pipelineConfigs().inNamespace(namespace)).withName(jobName)).edit()).editOrNewSpec().withTriggers(spec.getTriggers())).withParameters(spec.getParameters())).withSource(spec.getSource())).withStrategy(spec.getStrategy())).endSpec()).done();
                logger.info("PipelineConfig update success, " + jobName);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to update PipelineConfig: " + NamespaceName.create((HasMetadata)jobPipelineConfig) + ". " + e, e);
            }
        }
    }

    private boolean hasEmbeddedPipelineOrValidSource(PipelineConfig pipelineConfig) {
        PipelineStrategyJenkins jenkinsPipelineStrategy;
        PipelineStrategy strategy;
        PipelineConfigSpec spec = pipelineConfig.getSpec();
        if (spec != null && (strategy = spec.getStrategy()) != null && (jenkinsPipelineStrategy = strategy.getJenkins()) != null) {
            PipelineSourceGit git;
            PipelineSource source;
            if (StringUtils.isNotBlank((String)jenkinsPipelineStrategy.getJenkinsfile())) {
                return true;
            }
            if (StringUtils.isNotBlank((String)jenkinsPipelineStrategy.getJenkinsfilePath()) && (source = spec.getSource()) != null && (git = source.getGit()) != null) {
                return StringUtils.isNotBlank((String)git.getUri());
            }
        }
        return false;
    }

    private void reconfigure() {
        AlaudaSyncGlobalConfiguration config = AlaudaSyncGlobalConfiguration.get();
        if (config != null) {
            this.jobNamePattern = config.getJobNamePattern();
            this.jenkinsService = config.getJenkinsService();
            this.server = config.getServer();
            this.init();
        }
    }

    public String toString() {
        return "JenkinsPipelineJobListener{server='" + this.server + '\'' + ", jenkinsService='" + this.jenkinsService + '\'' + ", namespace='" + Arrays.toString(this.namespaces) + '\'' + ", jobNamePattern='" + this.jobNamePattern + '\'' + '}';
    }

    private static /* synthetic */ String lambda$onDeleted$2(String namespace, String pipelineConfigName) {
        return "No pipeline config for " + namespace + "/" + pipelineConfigName;
    }

    private static /* synthetic */ String lambda$onDeleted$1(String namespace, String pipelineConfigName) {
        return "Deleting PipelineConfig " + namespace + "/" + pipelineConfigName;
    }

    private static /* synthetic */ String lambda$onDeleted$0(String namespace, String pipelineConfigName) {
        return "Got pipeline config for  " + namespace + "/" + pipelineConfigName;
    }
}

