/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync;

import io.alauda.jenkins.devops.sync.AlaudaSyncGlobalConfiguration;
import io.alauda.jenkins.devops.sync.watcher.AbstractWatcher;
import io.alauda.kubernetes.client.KubernetesClientException;
import io.alauda.kubernetes.client.Watcher;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class WatcherCallback<T>
implements Watcher<T> {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final AbstractWatcher watcher;
    private final String namespace;
    private final ScheduledExecutorService service;
    private final AtomicInteger retryAttempt = new AtomicInteger(0);
    private static final int maxIntervalExponent = 5;
    private final int reconnectLimit = -1;
    private final int reconnectInterval = 1000;
    private long lastEvent;
    private ScheduledFuture<Boolean> future;

    public WatcherCallback(AbstractWatcher w, String n) {
        this.watcher = w;
        this.namespace = n;
        this.service = Executors.newScheduledThreadPool(1);
    }

    public void eventReceived(Watcher.Action action, T resource) {
        this.watcher.eventReceived(action, resource);
        this.lastEvent = System.currentTimeMillis();
    }

    public void onClose(KubernetesClientException cause) {
        if (cause != null) {
            this.logger.warning(() -> "Client is closed, prepare to re-watch");
            this.reWatch();
        } else if (this.isReWatching()) {
            this.future.cancel(true);
            this.future = null;
        }
    }

    public long getLastEvent() {
        return this.lastEvent;
    }

    private void reWatch() {
        if (this.isReWatching()) {
            return;
        }
        this.future = this.service.schedule(() -> {
            this.watcher.stop();
            try {
                this.watcher.watch();
                if (this.watcher.getWatcher() == null) {
                    this.service.schedule(() -> this.reWatch(), this.nextInterval(), TimeUnit.MILLISECONDS);
                    return false;
                }
                this.retryAttempt.set(0);
                AlaudaSyncGlobalConfiguration.get().reloadNamespaces();
                this.watcher.init(AlaudaSyncGlobalConfiguration.get().getNamespaces());
            }
            catch (Exception e) {
                this.service.schedule(() -> this.reWatch(), this.nextInterval(), TimeUnit.MILLISECONDS);
                return false;
            }
            return true;
        }, this.nextInterval(), TimeUnit.MILLISECONDS);
    }

    private long nextInterval() {
        int exponentOfTwo = this.retryAttempt.getAndIncrement();
        if (exponentOfTwo > 5) {
            exponentOfTwo = 5;
        }
        long ret = 1000L * (1L << exponentOfTwo);
        this.logger.info("Current re-watch back off is " + ret + " milliseconds (T" + exponentOfTwo + ")");
        return ret;
    }

    private boolean isReWatching() {
        return this.future != null && !this.future.isCancelled() && !this.future.isDone();
    }
}

