/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync;

import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.TaskListener;
import io.alauda.jenkins.devops.sync.AlaudaSyncGlobalConfiguration;
import io.alauda.jenkins.devops.sync.watcher.AbstractWatcher;
import io.alauda.kubernetes.client.KubernetesClientException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

@Extension
public class WatcherAliveCheck
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(WatcherAliveCheck.class.getName());
    private static final int MINMAM = 1;

    public WatcherAliveCheck() {
        super("Watcher alive check work");
    }

    protected void execute(TaskListener listener) throws IOException, InterruptedException {
        boolean invalid;
        AlaudaSyncGlobalConfiguration sync = AlaudaSyncGlobalConfiguration.get();
        boolean bl = invalid = !sync.isValid();
        if (invalid) {
            LOGGER.warning("Sync is invalid.");
            return;
        }
        ArrayList<AbstractWatcher> watcherList = new ArrayList<AbstractWatcher>();
        watcherList.add(sync.getPipelineConfigWatcher());
        watcherList.add(sync.getPipelineWatcher());
        watcherList.add(sync.getSecretWatcher());
        watcherList.add(sync.getJenkinsBindingWatcher());
        watcherList.add(sync.getNamespaceWatcher());
        if (watcherList.contains(null)) {
            LOGGER.warning("Get broken watcher, need to restart sync.");
            try {
                sync.configChange();
            }
            catch (KubernetesClientException e) {
                e.printStackTrace();
            }
            return;
        }
        long timeout = this.getRecurrencePeriod();
        boolean needRestart = watcherList.stream().anyMatch(watcher -> {
            boolean result;
            long lastEvent = watcher.getWatcherCallback().getLastEvent();
            boolean bl = result = System.currentTimeMillis() - lastEvent > timeout;
            if (result) {
                LOGGER.warning(watcher.getName() + " did't receive event in " + timeout + "ms!");
            }
            return result;
        });
        if (needRestart) {
            LOGGER.info("Will restart all watchers!");
            sync.configChange();
        } else {
            LOGGER.info("No need to restart watchers.");
        }
    }

    public long getRecurrencePeriod() {
        AlaudaSyncGlobalConfiguration sync = AlaudaSyncGlobalConfiguration.get();
        return TimeUnit.MINUTES.toMillis(sync.getWatcherAliveCheck() >= 1 ? (long)sync.getWatcherAliveCheck() : 1L);
    }
}

