/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync;

import hudson.model.BooleanParameterDefinition;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.StringParameterDefinition;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.scm.SCM;
import hudson.triggers.SCMTrigger;
import hudson.triggers.TimerTrigger;
import io.alauda.jenkins.devops.sync.core.InvalidSecretException;
import io.alauda.jenkins.devops.sync.util.AlaudaUtils;
import io.alauda.jenkins.devops.sync.util.CredentialsUtils;
import io.alauda.jenkins.devops.sync.util.NamespaceName;
import io.alauda.kubernetes.api.model.Condition;
import io.alauda.kubernetes.api.model.HasMetadata;
import io.alauda.kubernetes.api.model.PipelineConfig;
import io.alauda.kubernetes.api.model.PipelineConfigSpec;
import io.alauda.kubernetes.api.model.PipelineParameter;
import io.alauda.kubernetes.api.model.PipelineParameterBuilder;
import io.alauda.kubernetes.api.model.PipelineSource;
import io.alauda.kubernetes.api.model.PipelineSourceGit;
import io.alauda.kubernetes.api.model.PipelineStrategy;
import io.alauda.kubernetes.api.model.PipelineStrategyJenkins;
import io.alauda.kubernetes.api.model.PipelineTrigger;
import io.alauda.kubernetes.api.model.PipelineTriggerBuilder;
import io.alauda.kubernetes.api.model.PipelineTriggerFluent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.branch.Branch;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.BranchJobProperty;

public abstract class PipelineConfigToJobMapper {
    private static final Logger LOGGER = Logger.getLogger(PipelineConfigToJobMapper.class.getName());

    private PipelineConfigToJobMapper() {
    }

    public static FlowDefinition mapPipelineConfigToFlow(PipelineConfig pc) throws IOException {
        if (!AlaudaUtils.isPipelineStrategyPipelineConfig(pc)) {
            return null;
        }
        PipelineConfigSpec spec = pc.getSpec();
        PipelineSource source = null;
        String jenkinsfile = null;
        String jenkinsfilePath = null;
        if (spec != null) {
            PipelineStrategyJenkins pipelineStrategyJenkins;
            source = spec.getSource();
            PipelineStrategy strategy = spec.getStrategy();
            if (strategy != null && (pipelineStrategyJenkins = strategy.getJenkins()) != null) {
                jenkinsfile = pipelineStrategyJenkins.getJenkinsfile();
                jenkinsfilePath = pipelineStrategyJenkins.getJenkinsfilePath();
            }
        }
        if (StringUtils.isBlank(jenkinsfile)) {
            if (source != null && PipelineConfigToJobMapper.isValidSource(source)) {
                if (jenkinsfilePath == null) {
                    jenkinsfilePath = "Jenkinsfile";
                }
                PipelineSourceGit gitSource = source.getGit();
                String branchRef = gitSource.getRef();
                List<Object> branchSpecs = Collections.emptyList();
                if (StringUtils.isNotBlank((String)branchRef)) {
                    branchSpecs = Collections.singletonList(new BranchSpec(branchRef));
                }
                String credentialsId = null;
                try {
                    credentialsId = CredentialsUtils.updateSourceCredentials(pc);
                }
                catch (InvalidSecretException e) {
                    Condition condition = new Condition();
                    condition.setReason("not support credential type");
                    condition.setMessage(e.getMessage());
                    pc.getStatus().getConditions().add(condition);
                }
                List<UserRemoteConfig> configs = Collections.singletonList(new UserRemoteConfig(gitSource.getUri(), null, null, credentialsId));
                GitSCM scm = new GitSCM(configs, branchSpecs, Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
                return new CpsScmFlowDefinition((SCM)scm, jenkinsfilePath);
            }
            Condition condition = new Condition();
            condition.setReason("invalid source");
            condition.setMessage("please check git uri");
            pc.getStatus().getConditions().add(condition);
            LOGGER.warning("PipelineConfig does not contain source repository information - cannot map PipelineConfig to Jenkins job");
            return null;
        }
        return new CpsFlowDefinition(jenkinsfile, true);
    }

    private static boolean isValidSource(PipelineSource source) {
        return source != null && source.getGit() != null && source.getGit().getUri() != null;
    }

    private static PipelineTrigger findPipelineTriggers(@Nonnull PipelineConfig pipelineConfig, @Nonnull String type) {
        List triggers = pipelineConfig.getSpec().getTriggers();
        if (triggers == null) {
            return null;
        }
        for (PipelineTrigger trigger : triggers) {
            if (!trigger.getType().equals(type)) continue;
            return trigger;
        }
        return null;
    }

    private static void updateTrigger(WorkflowJob job, PipelineConfig pipelineConfig) {
        List pipelineConfigTriggers = pipelineConfig.getSpec().getTriggers();
        Map triggers = job.getTriggers();
        pipelineConfigTriggers.clear();
        if (triggers == null) {
            return;
        }
        triggers.forEach((desc, trigger) -> {
            PipelineTrigger pipelineTrigger = null;
            if (trigger instanceof SCMTrigger) {
                pipelineTrigger = ((PipelineTriggerBuilder)((PipelineTriggerFluent.CodeChangeNested)((PipelineTriggerFluent.CodeChangeNested)((PipelineTriggerBuilder)new PipelineTriggerBuilder().withType("codeChange")).withNewCodeChange().withEnabled(Boolean.valueOf(true))).withPeriodicCheck(trigger.getSpec())).endCodeChange()).build();
            } else if (trigger instanceof TimerTrigger) {
                pipelineTrigger = ((PipelineTriggerBuilder)((PipelineTriggerBuilder)new PipelineTriggerBuilder().withType("cron")).withNewCron(Boolean.valueOf(true), trigger.getSpec())).build();
            }
            if (pipelineTrigger != null) {
                pipelineConfigTriggers.add(pipelineTrigger);
            } else {
                LOGGER.warning(() -> "Not support trigger type : " + trigger.getClass());
            }
        });
    }

    public static boolean updatePipelineConfigFromJob(WorkflowJob job, PipelineConfig pipelineConfig) {
        Branch branch;
        PipelineStrategy strategy;
        NamespaceName namespaceName = NamespaceName.create((HasMetadata)pipelineConfig);
        PipelineStrategyJenkins pipelineStrategyJenkins = null;
        PipelineConfigSpec spec = pipelineConfig.getSpec();
        if (spec != null) {
            strategy = spec.getStrategy();
            if (strategy == null) {
                LOGGER.warning(() -> "No available JenkinsPipelineStrategy in the PipelineConfig " + namespaceName);
                return false;
            }
        } else {
            LOGGER.warning("Not spec in PipelineConfig");
            return false;
        }
        pipelineStrategyJenkins = strategy.getJenkins();
        PipelineConfigToJobMapper.updateTrigger(job, pipelineConfig);
        PipelineConfigToJobMapper.updateParameters(job, pipelineConfig);
        FlowDefinition definition = job.getDefinition();
        if (definition instanceof CpsScmFlowDefinition) {
            CpsScmFlowDefinition cpsScmFlowDefinition = (CpsScmFlowDefinition)definition;
            String scriptPath = cpsScmFlowDefinition.getScriptPath();
            if (scriptPath != null && scriptPath.trim().length() > 0) {
                SCM scm;
                boolean rc = false;
                PipelineSource source = PipelineConfigToJobMapper.getOrCreatePipelineSource(spec);
                if (!scriptPath.equals(pipelineStrategyJenkins.getJenkinsfilePath())) {
                    LOGGER.log(Level.FINE, "updating PipelineConfig " + namespaceName + " jenkinsfile path to " + scriptPath + " from ");
                    rc = true;
                    pipelineStrategyJenkins.setJenkinsfilePath(scriptPath);
                }
                if ((scm = cpsScmFlowDefinition.getScm()) instanceof GitSCM) {
                    PipelineConfigToJobMapper.populateFromGitSCM(pipelineConfig, source, (GitSCM)scm, null);
                    LOGGER.log(Level.FINE, "updating bc " + namespaceName);
                    rc = true;
                } else {
                    LOGGER.warning(() -> "Not support scm type: " + scm);
                }
                return rc;
            }
            return false;
        }
        if (definition instanceof CpsFlowDefinition) {
            CpsFlowDefinition cpsFlowDefinition = (CpsFlowDefinition)definition;
            String jenkinsfile = cpsFlowDefinition.getScript();
            if (jenkinsfile != null && jenkinsfile.trim().length() > 0 && !jenkinsfile.equals(pipelineStrategyJenkins.getJenkinsfile())) {
                LOGGER.log(Level.FINE, "updating PipelineConfig " + namespaceName + " jenkinsfile to " + jenkinsfile + " where old jenkinsfile was " + pipelineStrategyJenkins.getJenkinsfile());
                pipelineStrategyJenkins.setJenkinsfile(jenkinsfile);
                return true;
            }
            return false;
        }
        BranchJobProperty property = (BranchJobProperty)job.getProperty(BranchJobProperty.class);
        if (property != null && (branch = property.getBranch()) != null) {
            String ref = branch.getName();
            SCM scm = branch.getScm();
            PipelineSource source = PipelineConfigToJobMapper.getOrCreatePipelineSource(spec);
            if (scm instanceof GitSCM && PipelineConfigToJobMapper.populateFromGitSCM(pipelineConfig, source, (GitSCM)scm, ref)) {
                if (StringUtils.isEmpty((String)pipelineStrategyJenkins.getJenkinsfilePath())) {
                    pipelineStrategyJenkins.setJenkinsfilePath("Jenkinsfile");
                }
                return true;
            }
        }
        LOGGER.warning("Cannot update PipelineConfig " + namespaceName + " as the definition is of class " + (definition == null ? "null" : definition.getClass().getName()));
        return false;
    }

    private static void updateParameters(WorkflowJob job, PipelineConfig pipelineConfig) {
        PipelineConfigSpec spec = pipelineConfig.getSpec();
        if (spec.getParameters() == null) {
            spec.setParameters(new ArrayList());
        } else {
            spec.getParameters().clear();
        }
        ParametersDefinitionProperty paramsDefPro = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class);
        if (paramsDefPro == null) {
            return;
        }
        List paramDefs = paramsDefPro.getParameterDefinitions();
        if (paramDefs == null || paramDefs.size() == 0) {
            return;
        }
        for (ParameterDefinition def : paramDefs) {
            spec.getParameters().add(PipelineConfigToJobMapper.convertTo(def));
        }
    }

    public static boolean isSupportParamType(@Nonnull ParameterDefinition paramDef) {
        return StringParameterDefinition.class.equals(paramDef.getClass()) || BooleanParameterDefinition.class.equals(paramDef.getClass());
    }

    @Nonnull
    private static PipelineParameter convertTo(ParameterDefinition def) {
        if (!PipelineConfigToJobMapper.isSupportParamType(def)) {
            String errDesc = "Not support type:" + def.getType() + ", please fix these.";
            def = new StringParameterDefinition(def.getName(), "", errDesc);
        }
        String value = "";
        ParameterValue defVal = def.getDefaultParameterValue();
        if (defVal != null && defVal.getValue() != null) {
            value = defVal.getValue().toString();
        }
        return ((PipelineParameterBuilder)((PipelineParameterBuilder)((PipelineParameterBuilder)((PipelineParameterBuilder)new PipelineParameterBuilder().withType(PipelineConfigToJobMapper.paramType(def))).withName(def.getName())).withValue(value)).withDescription(def.getDescription())).build();
    }

    public static String paramType(@Nonnull ParameterDefinition parameterDefinition) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(new StringParameterDefinition("", "").getType(), "string");
        map.put(new BooleanParameterDefinition("", false, "").getType(), "boolean");
        return (String)map.get(parameterDefinition.getType());
    }

    private static boolean populateFromGitSCM(PipelineConfig pipelineConfig, PipelineSource source, GitSCM gitSCM, String ref) {
        URIish urIish;
        String gitUrl;
        RemoteConfig remoteConfig;
        List urIs;
        List repositories;
        if (source.getGit() == null) {
            source.setGit(new PipelineSourceGit());
        }
        if ((repositories = gitSCM.getRepositories()) != null && repositories.size() > 0 && (urIs = (remoteConfig = (RemoteConfig)repositories.get(0)).getURIs()) != null && urIs.size() > 0 && (gitUrl = (urIish = (URIish)urIs.get(0)).toString()) != null && gitUrl.length() > 0) {
            List branches;
            if (StringUtils.isEmpty((String)ref) && (branches = gitSCM.getBranches()) != null && branches.size() > 0) {
                BranchSpec branchSpec = (BranchSpec)branches.get(0);
                String branch = branchSpec.getName();
                while (branch.startsWith("*") || branch.startsWith("/")) {
                    branch = branch.substring(1);
                }
                if (!branch.isEmpty()) {
                    ref = branch;
                }
            }
            AlaudaUtils.updateGitSourceUrl(pipelineConfig, gitUrl, ref);
            return true;
        }
        return false;
    }

    private static PipelineSource getOrCreatePipelineSource(PipelineConfigSpec spec) {
        PipelineSource source = spec.getSource();
        if (source == null) {
            source = new PipelineSource();
            spec.setSource(source);
        }
        return source;
    }
}

